/* 
 * Copyright (C) 1993 Mark Boyns (boyns@sdsu.edu)
 *
 * This file is part of rplay.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#ifndef _audio_h
#define _audio_h

#include "conf.h"

extern int	audio_timeout;
extern int	audio_bufsize;
extern char	*audio_device;
extern int	audio_open_count;

#ifdef __STDC__
extern void	audio_open();
extern int	audio_isopen();
extern void	audio_close();
extern void	audio_write(int amount);
extern void	audio_init();
extern int	audio_set_volume(int volume);
extern int	audio_get_volume();
#else
extern void	audio_open();
extern int	audio_isopen();
extern void	audio_close();
extern void	audio_write(/* int amount */);
extern void	audio_init();
extern int	audio_set_volume(/* int volume */);
extern int	audio_get_volume();
#endif

#endif /* _audio_h */
