/* 
 * Copyright (C) 1993 Mark Boyns (boyns@sdsu.edu)
 *
 * This file is part of rplay.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#ifndef _rplay_h
#define _rplay_h

#include <sys/types.h>
#include <sys/socket.h>
#include <netinet/in.h>
#include <stdio.h>

#undef FALSE
#define FALSE	0
#undef TRUE
#define TRUE	1

#define RPLAY_PORT		55555
#define RPTP_PORT		55556

#define RPLAY_NULL		0
#define RPLAY_PLAY		1
#define RPLAY_STOP		2
#define RPLAY_PAUSE		3
#define RPLAY_CONTINUE		4
#define RPLAY_SOUND		5
#define RPLAY_VOLUME		6
#define RPLAY_NSOUNDS		7
#define RPLAY_COMMAND		8
#define RPLAY_APPEND		9
#define RPLAY_INSERT		10
#define RPLAY_DELETE		11
#define RPLAY_CHANGE		12
#define RPLAY_COUNT		13
#define RPLAY_LIST_COUNT	14
#define RPLAY_PRIORITY		15
#define RPLAY_RANDOM_SOUND	16
#define RPLAY_PING		17
#define RPLAY_RPTP_SERVER	18
#define RPLAY_RPTP_SERVER_PORT	19
#define RPLAY_RPTP_SEARCH	20
#define RPLAY_RPTP_FROM_SENDER	21

#define RPLAY_MIN_VOLUME	0
#define RPLAY_DEFAULT_VOLUME	127
#define RPLAY_MAX_VOLUME	255

#define RPLAY_DEFAULT_COUNT		1
#define RPLAY_DEFAULT_LIST_COUNT	1

#define RPLAY_MIN_PRIORITY		0
#define RPLAY_DEFAULT_PRIORITY		0
#define RPLAY_MAX_PRIORITY		255

#define RPLAY_DEFAULT_RANDOM_SOUND	-1

/*
 * rplay errors used by rplay_errno
 */
#define RPLAY_ERROR_NONE	0
#define RPLAY_ERROR_MEMORY	1
#define RPLAY_ERROR_HOST	2
#define RPLAY_ERROR_CONNECT	3
#define RPLAY_ERROR_SOCKET	4
#define RPLAY_ERROR_WRITE	5
#define RPLAY_ERROR_CLOSE	6 
#define RPLAY_ERROR_PACKET_SIZE	7
#define RPLAY_ERROR_BROADCAST	8
#define RPLAY_ERROR_ATTRIBUTE	9
#define RPLAY_ERROR_COMMAND	10
#define RPLAY_ERROR_INDEX	11
#define RPLAY_ERROR_MODIFIER	12

/*
 * RPTP errors used by rptp_errno
 */
#define RPTP_ERROR_NONE		0
#define RPTP_ERROR_MEMORY	1
#define RPTP_ERROR_HOST		2
#define RPTP_ERROR_CONNECT	3
#define RPTP_ERROR_SOCKET	4
#define RPTP_ERROR_OPEN		5
#define RPTP_ERROR_READ		6
#define RPTP_ERROR_WRITE	7
#define RPTP_ERROR_PING		8
#define RPTP_ERROR_TIMEOUT	9

/*
 * RPTP response types
 */
#define RPTP_ERROR		'-'
#define RPTP_OK			'+'
#define RPTP_TIMEOUT		'!'

/*
 * rplay 2.0 support
 */
#define OLD_RPLAY_PLAY		1
#define OLD_RPLAY_STOP		2
#define OLD_RPLAY_PAUSE		3
#define OLD_RPLAY_CONTINUE	4

/*
 * rplay attributes
 */
typedef struct _rplay_attrs
{
	struct _rplay_attrs	*next;
	char			*sound;
	int			volume;
	int			count;
	char			*rptp_server;
	unsigned short		rptp_server_port;
	int			rptp_search;
} RPLAY_ATTRS;

/*
 * the rplay object
 */
typedef struct _rplay
{
	struct _rplay_attrs	*attrs;
	struct _rplay_attrs	**attrsp;
	char			*buf;
	int			len;
	int			size;
	int			command;
	int			nsounds;
	int			count;
	int			priority;
	int			random_sound;
} RPLAY;

#define RPTP_MAX_LINE	1024
#define RPTP_MAX_ARGS	32

extern int	rplay_errno;
extern int	rptp_errno;
extern char	*rplay_errlist[];
extern char	*rptp_errlist[];

#ifdef __cplusplus
#ifndef __STDC__
#define __STDC__
#endif
extern "C" {
#endif

#ifdef __STDC__
extern RPLAY	*rplay_create(int rplay_command);
extern char	*rplay_convert(char *buf);
extern int	rplay_pack(RPLAY *rp);
extern RPLAY	*rplay_unpack(char *buf);
extern void	rplay_destroy(RPLAY *rp);
extern int	rplay_set(RPLAY *, ...);
extern int	rplay_get(RPLAY *, ...);
extern int	rplay_open(char *host);
extern int	rplay_open_sockaddr_in(struct sockaddr_in *saddr);
extern int	rplay(int, RPLAY *rp);
extern int	rplay_close(int rplay_fd);
extern void	rplay_perror(char *message);
extern int	rplay_open_display(void);
extern int	rplay_display(char *sound);
extern int	rplay_local(char *sound);
extern int	rplay_host(char *host, char *sound);
extern int	rplay_host_volume(char *host, char *sound, int volume);
extern int	rplay_sound(int rplay_fd, char *sound);
extern int	rplay_ping(char *host);
extern int	rplay_ping_sockaddr_in(struct sockaddr_in *saddr);
extern int	rplay_ping_sockfd(int sock_fd);
extern char	*rplay_default_host(void);
extern int	rplay_default(char *sound);
extern int	rplay_open_default(void);
extern int	rptp_open(char *host, int port, char *response, int response_size);
extern int	rptp_read(int rptp_fd, char *buf, int nbytes);
extern int	rptp_write(int rptp_fd, char *buf, int nbytes);
extern int	rptp_close(int rptp_fd);
extern void	rptp_perror(char *message);
extern int	rptp_putline(int rptp_fd, char *fmt, ...);
extern int	rptp_getline(int rptp_fd, char *buf, int nbytes);
extern int	rptp_command(int rptp_fd, char *command, char *response, int response_size);
#else
extern RPLAY	*rplay_create(/* int rplay_command */);
extern char	*rplay_convert(/* char *buf */);
extern int	rplay_pack(/* RPLAY *rp */);
extern RPLAY	*rplay_unpack(/* char *buf */);
extern void	rplay_destroy(/* RPLAY *rp */);
extern int	rplay_set(/* RPLAY *, ... */);
extern int	rplay_get(/* RPLAY *, ... */);
extern int	rplay_open(/* char *host */);
extern int	rplay_open_sockaddr_in(/* struct sockaddr_in *saddr */);
extern int	rplay(/* int, RPLAY *rp */);
extern int	rplay_close(/* int rplay_fd */);
extern void	rplay_perror(/* char *message */);
extern int	rplay_open_display();
extern int	rplay_display(/* char *sound */);
extern int	rplay_local(/* char *sound */);
extern int	rplay_host(/* char *host, char *sound */);
extern int	rplay_host_volume(/* char *host, char *sound, int volume */);
extern int	rplay_sound(/* int rplay_fd, char *sound */);
extern int	rplay_ping(/* char *host */);
extern int	rplay_ping_sockaddr_in(/* struct sockaddr_in *saddr */);
extern int	rplay_ping_sockfd(/* int sock_fd */);
extern char	*rplay_default_host();
extern int	rplay_default(/* char *sound */);
extern int	rplay_open_default();
extern int	rptp_open(/* char *host, int port, char *response, int response_size */);
extern int	rptp_read(/* int rptp_fd, char *buf, int nbytes */);
extern int	rptp_write(/* int rptp_fd, char *buf, int nbytes */);
extern int	rptp_close(/* int rptp_fd */);
extern void	rptp_perror(/* char *message */);
extern int	rptp_putline(/* int rptp_fd, char *fmt, ... */);
extern int	rptp_getline(/* int rptp_fd, char *buf, int nbytes */);
extern int	rptp_command(/* int rptp_fd, char *command, char *response, int response_size */);
#endif

#ifdef __cplusplus
}
#endif

#ifdef NEED_STRDUP
#ifdef __STDC__
extern char	*strdup(char *str);
#else
extern char	*strdup(/* char *str */);
#endif
#endif /* NEED_STRDUP */

#endif /* _rplay_h */
