#include <X11/Xlib.h>
#include <X11/Xutil.h>
#include <X11/Xatom.h>
#include <stdio.h>
#include <string.h>
#include <malloc.h>
#include "Message.h"
#include "al.h"


Message * CreateMessage(Window win)
{
	Message	*message = (Message *) malloc(sizeof(Message));
	message->win = win;
	message->x = message->y = 0;
	message->label = NULL;

	return message;
}


void SetMessageLocation(Message *message, int x, int y)
{
	message->x = x;
	message->y = y;
}


void SetMessageLabel(Message *message, char *label)
{
	if (message->label)
		free(message->label);
	message->label = strdup(label);
}


void MessageRedraw(Message *message)
{
	int			direction, ascent, descent;
	XCharStruct	overall;

	/*
	 * Compute the message dimensions from the label string
	 */
	XTextExtents(state.normal_font, message->label, strlen(message->label),
		&direction, &ascent, &descent, &overall);

	message->string_x = message->x + 8;
	message->string_y = message->y + state.normal_font->ascent +  3;

	XDrawString(state.display, message->win, state.gc[GC_NORMAL],
		message->string_x, message->string_y, message->label, strlen(message->label));
}


