/* 
 * Copyright (C) 1993 Mark Boyns (boyns@sdsu.edu)
 *
 * volume
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#include <stdio.h>
#include <rplay.h>

char	*progname;

main(argc, argv)
int	argc;
char	**argv;
{
	int		i;
	int		rptp_fd;
	char		response[RPTP_MAX_LINE];
	char		command[RPTP_MAX_LINE];
	char		*rptp_host = NULL;
	int		rptp_port = RPTP_PORT;
	int		volume;
	extern int	optind;
	extern char	*optarg;

	progname = argv[0];

	while ((i = getopt(argc, argv, "h:p:")) != -1)
	{
		switch (i)
		{
		case 'h':
			rptp_host = optarg;
			break;

		case 'p':
			rptp_port = atoi(optarg);
			break;

		default:
			usage();
			exit(0);
		}
	}

	if (optind == argc) 
	{
		volume = -1;
	}
	else if (optind+1 == argc)
	{
		volume = atoi(argv[optind]);
	}
	else
	{
		usage();
		exit(1);
	}

	if (rptp_host == NULL)
	{
		rptp_host = rplay_default_host();
	}

	rptp_fd = rptp_open(rptp_host, rptp_port, response, sizeof(response));
	if (rptp_fd < 0)
	{
		fprintf(stderr, "%s: %s\n", progname, rptp_errlist[rptp_errno]);
		exit(1);
	}

	if (volume >= 0)
	{
		sprintf(command, "volume %d", volume);
	}
	else
	{
		sprintf(command, "volume");
	}

	switch (rptp_command(rptp_fd, command, response, sizeof(response)))
	{
	case -1:
		fprintf(stderr, "%s: %s\n", progname, rptp_errlist[rptp_errno]);
		exit(1);

	case 1:
		fprintf(stderr, "%s: %s\n", progname, response+1);
		exit(1);

	default:
		printf("%d\n", atoi(response+1));
		break;
	}

	rptp_close(rptp_fd);
	exit(0);
}

usage()
{
	fprintf(stderr, "usage: %s [new_volume]\n", progname);
}
