/* 
 * Copyright (C) 1993 Mark Boyns (boyns@sdsu.edu)
 *
 * This file is part of rplay.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#ifndef _sound_h
#define _sound_h

#include "conf.h"
#include "buffer.h"

#define SOUND_LIST_SIZE	256	/* maximum size of a sound list */

/*
 * sound status values
 */
#define SOUND_NULL	0
#define SOUND_READY	1	/* sound is ready to be played */
#define SOUND_NOT_READY	2	/* sound is being transferred */
#define SOUND_SEARCH	3	/* sound is searched for */

/*
 * sound lookup modes
 */
#define SOUND_FIND		1
#define SOUND_DONT_FIND		2
#define SOUND_DONT_COUNT	3

typedef struct _sound
{
	struct _sound	*list;		/* next pointer for entire sound list */
	struct _sound	*list_prev;	/* prev pointer for entire sound list */
	struct _sound	*next;		/* list for sounds with the same hash key */
	struct _sound	*prev;		/* prev pointer for the next list */
	char		*name;
	char		*hash_key;
	char		*path;
	char		*buf;
	char		*start;
	char		*stop;
	int		size;
	int		status;
	int		count;
} SOUND;

extern SOUND	*sounds;
extern int	sound_count;
extern BUFFER	*sound_list;

#ifdef __STDC__
extern void	sound_read(char *filename);
extern SOUND	*sound_lookup(char *sound_name, int mode);
extern SOUND	*sound_create();
extern SOUND	*sound_insert(char *, int);
extern int	sound_load(SOUND *s);
extern void	sound_delete(SOUND *s);
extern int	sound_map(SOUND *s, char *buf, int size);
extern BUFFER	*sound_list_create();
extern void	sound_unmap(SOUND *s);
extern void	sound_cleanup();
#else
extern void	sound_read(/* char *filename */);
extern SOUND	*sound_lookup(/* char *sound_name, int mode */);
extern SOUND	*sound_create();
extern SOUND	*sound_insert(/* char *, int */);
extern int	sound_load(/* SOUND *s */);
extern void	sound_delete(/* SOUND *s */);
extern int	sound_map(/* SOUND *s, char *buf, int size */);
extern BUFFER	*sound_list_create();
extern void	sound_unmap(/* SOUND *s */);
extern void	sound_cleanup();
#endif

#endif /* _sound_h */
