/* 
 * Copyright (C) 1993 Mark Boyns (boyns@sdsu.edu)
 *
 * This file is part of rplay.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#ifndef _rplayd_h
#define _rplayd_h

#include "conf.h"
#include <rplay.h>
#include "misc.h"

extern int	spool_size;
extern fd_set	read_mask;
extern fd_set	write_mask;
extern int	debug;
extern int	inetd;
extern int	rptp_timeout;
extern char	hostname[];
extern int	rplay_fd;
extern int	rptp_fd;
extern int	errno;
extern char	*sys_errlist[];

#ifdef __STDC__
extern void		usage();
extern void		done(int exit_value);
extern unsigned long	inet_addr(char *);
extern char		*inet_ntoa(struct in_addr);
extern void		report(char *fmt, ...);
extern void		rplayd_read();
extern void		rplayd_init();
extern int		rplayd_play(RPLAY *rp, struct sockaddr_in sin);
extern int		rplayd_stop(RPLAY *rp, struct sockaddr_in sin);
extern int		rplayd_pause(RPLAY *rp, struct sockaddr_in sin);
extern int		rplayd_continue(RPLAY *rp, struct sockaddr_in sin);
#else
extern void		usage();
extern void		done(/* int exit_value */);
extern unsigned long	inet_addr(/* char * */);
extern char		*inet_ntoa(/* struct in_addr */);
extern void		report(/* char *fmt, ... */);
extern void		rplayd_read();
extern void		rplayd_init();
extern int		rplayd_play(/* RPLAY *rp, struct sockaddr_in sin */);
extern int		rplayd_stop(/* RPLAY *rp, struct sockaddr_in sin */);
extern int		rplayd_pause(/* RPLAY *rp, struct sockaddr_in sin */);
extern int		rplayd_continue(/* RPLAY *rp, struct sockaddr_in sin */);
#endif

#endif /* _rplayd_h */
