/* 
 * X11: init and draw 
 */

#include "netmaze.h"
#include "bitmap.h"
#include "bitmaps/unilogo.xbm"
#include <math.h>

extern struct shared_struct *sm;

GC hwallgc,vwallgc,blackgc,whitegc,topgc,bottomgc,unilogogc;

static char gamename[] = "Netmaze - The Multiplayercombatgame";
static char mapname1[] = "Rotate-Map";
static char iconname[] = "Netmaze";
static char statusname[] = "Status";
static char killname[] = "Kills";

static int gfxshift;

static void set_colors(PLAYER*);
static void gamebgtofg(void);
static GC mkmonomap(char *bitmap);
static GC mkunilogo(void);
static GC mkcolormap(char *name);
static GC mkdithermap(char *bitmap,char *fg,char *bg);
static int calc_pos(int num,int len);
static int calc_fitlen(int fit,int height);
/*
static int clipit(int x1,int h1,int x2,int h2,int c);
*/

extern void init_smiley(void);
extern void draw_smiley(Drawable,short,short,short,short);

char *infotext[] = { "Welcome to Netmaze by MH! Pre-Version V0.71-Jan94" , ""};

static Pixmap unilogo;

/************************************************
 * Init X11-datas, (open Display,setup gcs, ..)
 */

void x11_init(int argc,char **argv)
{
  sm->grafix.display = sm->grafix.display1 = XOpenDisplay ("");

  sm->grafix.display1  = XOpenDisplay ("");

  if((sm->grafix.display == NULL) || (sm->grafix.display1 == NULL))
  {
    fprintf(stderr,"%s: Can't open Display\n",argv[0]);
    exit(-1);
  }

  sm->grafix.root = DefaultRootWindow(sm->grafix.display); 
  sm->grafix.screen = DefaultScreen(sm->grafix.display);
  sm->grafix.cmap = DefaultColormap(sm->grafix.display,sm->grafix.screen);
  XGetWindowAttributes(sm->grafix.display,sm->grafix.root,&sm->grafix.attribute);
  sm->grafix.gc = XCreateGC (sm->grafix.display,sm->grafix.root,0,0);

  switch(sm->outputsize)
  {
    case 0:
      sm->grafix.gamewidth = sm->grafix.shint.width = 640; 
      sm->grafix.gameheight = sm->grafix.shint.height = 400;  
      gfxshift = 0;
      break;
    case 1:
      sm->grafix.gamewidth = sm->grafix.shint.width = 320; 
      sm->grafix.gameheight = sm->grafix.shint.height = 200;  
      gfxshift = 1;
      break;
    case 2:
      sm->grafix.gamewidth = sm->grafix.shint.width = 160;
      sm->grafix.gameheight = sm->grafix.shint.height = 100;  
      gfxshift = 2;
      break;
    case 3:
      sm->grafix.gamewidth = sm->grafix.shint.width = 1280;
      sm->grafix.gameheight = sm->grafix.shint.height = 800;  
      gfxshift = -1;
      break;
  }
  sm->grafix.shint.flags = PSize; 

  sm->grafix.gamefg = XCreateSimpleWindow(sm->grafix.display,sm->grafix.root,
                      100,100,sm->grafix.shint.width,sm->grafix.shint.height,
                      5,0,BlackPixel(sm->grafix.display,sm->grafix.screen));  

  sm->grafix.gamebg = XCreatePixmap (sm->grafix.display,sm->grafix.gamefg,
                      sm->grafix.gamewidth,sm->grafix.gameheight,
                      sm->grafix.attribute.depth);

  sm->grafix.mapfg  = XCreateSimpleWindow(sm->grafix.display,sm->grafix.root,
                      100,100,MAPSIZE,MAPSIZE,
                      5,0,BlackPixel(sm->grafix.display,sm->grafix.screen)); 

  sm->grafix.mapbg  = XCreatePixmap(sm->grafix.display,sm->grafix.mapfg,
                      MAPSIZE,MAPSIZE,sm->grafix.attribute.depth);

  sm->grafix.sthint.width  = 200;
  sm->grafix.sthint.height = 100;
  sm->grafix.sthint.flags  = PSize; 
  sm->grafix.statusfg = XCreateSimpleWindow(sm->grafix.display,sm->grafix.root,
                       100,100,sm->grafix.sthint.width,sm->grafix.sthint.height,
                        5,0,BlackPixel(sm->grafix.display,sm->grafix.screen));

  sm->grafix.khint.width  = 204;
  sm->grafix.khint.height = 84;
  sm->grafix.khint.flags  = PSize; 
  sm->grafix.killfg = XCreateSimpleWindow(sm->grafix.display,sm->grafix.root,
                       100,100,sm->grafix.khint.width,sm->grafix.khint.height,
                        5,0,BlackPixel(sm->grafix.display,sm->grafix.screen));

  XSetStandardProperties (sm->grafix.display,sm->grafix.mapfg,mapname1,
                          mapname1,None,argv,argc,NULL);
  XSetStandardProperties (sm->grafix.display,sm->grafix.gamefg,gamename,
                          iconname,None,argv,argc,&sm->grafix.shint);
  XSetStandardProperties (sm->grafix.display,sm->grafix.statusfg,statusname,
                          statusname,None,argv,argc,&sm->grafix.sthint);
  XSetStandardProperties (sm->grafix.display,sm->grafix.killfg,killname,
                          killname,None,argv,argc,&sm->grafix.khint);

  unilogo = XCreateBitmapFromData(sm->grafix.display,sm->grafix.root,
            unilogo_bits,unilogo_width,unilogo_height);

  set_colors(sm->playfeld);

  XSelectInput (sm->grafix.display1,sm->grafix.gamefg,
                ExposureMask | KeyPressMask | ButtonReleaseMask |
                ButtonPressMask | KeyReleaseMask | StructureNotifyMask );
  if(sm->mapdraw) 
    XSelectInput (sm->grafix.display1,sm->grafix.mapfg,ExposureMask);

  XSelectInput(sm->grafix.display1,sm->grafix.statusfg,
                 ExposureMask | StructureNotifyMask);
  XSelectInput(sm->grafix.display1,sm->grafix.killfg,
                 ExposureMask | StructureNotifyMask);


  if(sm->mapdraw) 
    XMapRaised (sm->grafix.display,sm->grafix.mapfg);
  XMapRaised (sm->grafix.display,sm->grafix.statusfg);
  XMapRaised (sm->grafix.display,sm->grafix.gamefg);
  XMapRaised (sm->grafix.display,sm->grafix.killfg);
  XFlush(sm->grafix.display);
  XFlush(sm->grafix.display1);

  init_smiley();
}

/********************************+++
 * Draw the map
 */

void draw_map(MAZE *mazeadd)
{
  int (*vfeld)[MAZEDIMENSION],(*hfeld)[MAZEDIMENSION];
  int i,j,dim;

  hfeld = mazeadd->hwalls;
  vfeld = mazeadd->vwalls;
  dim = mazeadd->xdim;    

  for(i=0;i<dim+1;i++)
    for(j=0;j<dim;j++)
    {
      if(hfeld[j][i] == TRUE)
      {
        XDrawLine(sm->grafix.display,sm->grafix.gamefg,sm->grafix.gc,
                  j*SCALE+5,i*SCALE+5,j*SCALE+5+SCALE,i*SCALE+5);
      }
      if(vfeld[j][i] == TRUE)
      {
        XDrawLine(sm->grafix.display,sm->grafix.gamefg,sm->grafix.gc,
                  i*SCALE+5,j*SCALE+5,i*SCALE+5,j*SCALE+5+SCALE);
      }
    }    
}

/****************************+
 * draw rotate-map
 */

void draw_rmap(PLAYER *play,XSegment *lines,int anzahl)
{
  int x;
  XFillRectangle(sm->grafix.display,sm->grafix.mapbg,blackgc,0,0,MAPSIZE,MAPSIZE);
  XDrawSegments(sm->grafix.display,sm->grafix.mapbg,sm->grafix.gc,lines,anzahl);
  /* Targets */
  for(x=0; x<sm->marks; x++)
  {
    int nr = sm->markers[x].player;
    XFillArc(sm->grafix.display,sm->grafix.mapbg,sm->pgfx[play[nr].team].xgc, 
             sm->markers[x].x-2, sm->markers[x].y-2,5,5,0,360*64);
  }
  XDrawArc(sm->grafix.display,sm->grafix.mapbg,sm->grafix.gc,
           MAPSIZE/2-2,MAPSIZE/2-2,5,5,0,360*64);
  XCopyArea(sm->grafix.display,sm->grafix.mapbg,sm->grafix.mapfg,sm->grafix.gc,
            0,0,MAPSIZE,MAPSIZE,0,0);
}

/******************************
 * Draw 'game-over' Screen
 */

void draw_end(PLAYER *play,int nr)
{
  int r,i,j;

  if(gfxshift >= 0)
    r = 128>>gfxshift;
  else
    r = 128<<(-gfxshift);

  XFillRectangle(sm->grafix.display,sm->grafix.gamebg,blackgc,
                  0,0,sm->grafix.gamewidth,sm->grafix.gameheight); 
  XFillArc(sm->grafix.display,sm->grafix.gamebg,sm->pgfx[play[nr].team].xgc,
           (sm->grafix.gamewidth>>1)-r,(sm->grafix.gameheight>>1)-r,
           r<<1,r<<1,0,360*64);
  draw_smiley(sm->grafix.gamebg,sm->grafix.gamewidth>>1,sm->grafix.gameheight>>1,0,r);

  for(i=0,j=0;i<sm->anzplayers;i++)
  {
    if(play[nr].team == play[i].team)
    {
      XDrawImageString(sm->grafix.display,sm->grafix.gamebg,sm->grafix.gc,
                       5,32+j*16,play[i].name,strlen(play[i].name));
      j++;
    }
  }
  if(j == 1)
  {
    XDrawImageString(sm->grafix.display,sm->grafix.gamebg,sm->grafix.gc,
                   0,16,"The Winner is:",14);
  }
  else
  {
    XDrawImageString(sm->grafix.display,sm->grafix.gamebg,sm->grafix.gc,
                   0,16,"The Winners are:",16);
  }

  gamebgtofg();
}

/***************************************
 * Draw maze (3D)
 */

double deg(double x,double y)		/* degrees 0..256 */
{
  return (x != 0.0 ? 256.0 - 256.0/4.0 - atan(y/x)/(M_PI*2.0) * 256.0 : 0.0);
}

void draw_maze(WALL *walls,PLAYER *play,int anzahl,int nr)
{
  int id,i,r,r2;
  unsigned int width,high,hwidth,hhigh,x1;
  XPoint points[4]; 
  GC gc;

  width = sm->grafix.gamewidth;
  high  = sm->grafix.gameheight;

  if(play[nr].hitbycnt == 0)
  {
    XFillRectangle (sm->grafix.display,sm->grafix.gamebg,topgc,
                    0,0,width,high>>1);
    XFillRectangle (sm->grafix.display,sm->grafix.gamebg,bottomgc,
                    0,high>>1,width,high>>1);
  }
  else
  {
    XFillRectangle(sm->grafix.display,sm->grafix.gamebg,
                   sm->pgfx[play[nr].hitby].xgc,0,0,width,high);
  }

  hwidth = width >> 1;
  hhigh  = high  >> 1;
  
  for(i=anzahl-1;i>=0;i--)
  {
    id = walls[i].ident;

    if(id >= 0x100)
    {
      if(id == 0x100) 
        gc = hwallgc;
      else 
        gc = vwallgc;

/*
      if(sm->clipsides)
      {
        if(walls[i].x1+2 < walls[i].lclip)
        {
          walls[i].h1 = clipit(walls[i].x1,walls[i].h1,
                               walls[i].x2,walls[i].h2,walls[i].lclip);
          walls[i].x1 = walls[i].lclip;
        }
        if(walls[i].x2-2 > walls[i].rclip)
        {
          walls[i].h2 = clipit(walls[i].x1,walls[i].h1,
                               walls[i].x2,walls[i].h2,walls[i].rclip);
          walls[i].x2 = walls[i].rclip;
        }
      }
*/

      switch(sm->outputsize)
      {
        case 0:
         points[0].x = hwidth + walls[i].x1; points[0].y = hhigh + walls[i].h1;
         points[1].x = hwidth + walls[i].x2; points[1].y = hhigh + walls[i].h2;
         points[2].x = hwidth + walls[i].x2; points[2].y = hhigh - walls[i].h2;
         points[3].x = hwidth + walls[i].x1; points[3].y = hhigh - walls[i].h1;
         break;
        case 1:
         points[0].x=hwidth+(walls[i].x1>>1);points[0].y=hhigh+(walls[i].h1>>1);
         points[1].x=hwidth+(walls[i].x2>>1);points[1].y=hhigh+(walls[i].h2>>1);
         points[2].x=hwidth+(walls[i].x2>>1);points[2].y=hhigh-(walls[i].h2>>1);
         points[3].x=hwidth+(walls[i].x1>>1);points[3].y=hhigh-(walls[i].h1>>1);
         break; 
        case 2:
         points[0].x=hwidth+(walls[i].x1>>2);points[0].y=hhigh+(walls[i].h1>>2);
         points[1].x=hwidth+(walls[i].x2>>2);points[1].y=hhigh+(walls[i].h2>>2);
         points[2].x=hwidth+(walls[i].x2>>2);points[2].y=hhigh-(walls[i].h2>>2);
         points[3].x=hwidth+(walls[i].x1>>2);points[3].y=hhigh-(walls[i].h1>>2);
         break; 
        default:
         points[0].x=hwidth+(walls[i].x1<<1);points[0].y=hhigh+(walls[i].h1<<1);
         points[1].x=hwidth+(walls[i].x2<<1);points[1].y=hhigh+(walls[i].h2<<1);
         points[2].x=hwidth+(walls[i].x2<<1);points[2].y=hhigh-(walls[i].h2<<1);
         points[3].x=hwidth+(walls[i].x1<<1);points[3].y=hhigh-(walls[i].h1<<1);
         break; 
      }

      XFillPolygon (sm->grafix.display,sm->grafix.gamebg,gc,
                    points,4,Convex,CoordModeOrigin);

      if(walls[i].x1 == walls[i].lclip)
        XDrawLine(sm->grafix.display,sm->grafix.gamebg,whitegc,
                  points[0].x,points[0].y,points[3].x,points[3].y);
      if(walls[i].x2 == walls[i].rclip)
        XDrawLine(sm->grafix.display,sm->grafix.gamebg,whitegc,
                  points[1].x,points[1].y,points[2].x,points[2].y);  
    }
    else if(id < 64)
    {
      switch(sm->outputsize)
      {
        case 0:
          r2 = (r = (walls[i].h1))>>1;
          x1 = walls[i].x1;
          break;
        case 1:
          r2 = (r = (walls[i].h1>>1))>>1;
          x1 = walls[i].x1>>1;
          break;
        case 2:
          r2 = (r = (walls[i].h1>>2))>>1;
          x1 = walls[i].x1>>2;
          break;
        default:
          r2 = (r = (walls[i].h1<<1))>>1;
          x1 = walls[i].x1<<1;
          break;
      }
      if(id < 32)
      {
        if(play[id].hitbycnt == 0)
        {
          XFillArc(sm->grafix.display,sm->grafix.gamebg,
                   sm->pgfx[play[id].team].xgc,
                   x1+hwidth-r2,hhigh-r2,r,r,0,360*64);
        }
        else
        {
          XFillArc(sm->grafix.display,sm->grafix.gamebg,
                   sm->pgfx[play[id].hitby].xgc,
                   x1+hwidth-r2,hhigh-r2,r,r,0,360*64); 
        }
        XFillArc(sm->grafix.display,sm->grafix.gamebg,blackgc, /* shadow */
                 x1+hwidth-r2+(r2>>2),hhigh+r2*SMSCALE-(r2>>2),
                 r-(r2>>1),r2>>1,0,360*64);
        draw_smiley(sm->grafix.gamebg,x1+hwidth,hhigh,walls[i].h2,r2);
      }
      else if(id < 64)
      {
        XFillArc(sm->grafix.display,sm->grafix.gamebg, /* shot */
                 sm->pgfx[play[id-32].team].xgc,
                 x1+hwidth-r2,hhigh-r2,r,r,0,360*64);
        XFillArc(sm->grafix.display,sm->grafix.gamebg,blackgc, /* shadow */
                 x1+hwidth-r2+(r2>>2),
                 hhigh+r2*STSCALE,r-(r2>>1),r2>>1,0,360*64);
      }
    }
  }
 
  if(play[nr].hide)
  {
    XDrawLine(sm->grafix.display,sm->grafix.gamebg,blackgc,
              hwidth-5,hhigh,hwidth+5,hhigh);
    XDrawLine(sm->grafix.display,sm->grafix.gamebg,blackgc,
              hwidth,hhigh-5,hwidth,hhigh+5);
  }
  else
  {
    XDrawLine(sm->grafix.display,sm->grafix.gamebg,sm->grafix.gc,
              hwidth-5,hhigh,hwidth+5,hhigh);
    XDrawLine(sm->grafix.display,sm->grafix.gamebg,sm->grafix.gc,
              hwidth,hhigh-5,hwidth,hhigh+5);
  }
/*
	Follow arrow.
	look at winkel, and player follow winkel,
	and distance to player.
*/
  if((nr != play[nr].follow) && (play[nr].follow != -1) && sm->locator) 
  {
    PLAYER *me   = play+nr;
    PLAYER *them = play+me->follow;
    int mx,my;
    int tx,ty;
    int dx,dy;
    static long count=0;
    int angle, diff;

    if (me && them)
    {
      mx = (int) ((me->x) >> 24);
      my = (int) ((me->y) >> 24);
      tx = (int) ((them->x) >> 24);
      ty = (int) ((them->y) >> 24);
      dx = mx-tx;
      dy = my-ty;

      count++;
      /*
       ** Angle from me to target,
       ** map-based angle.
       */
      angle = (int)deg((double)dy,(double)dx);

      /*
       ** Now its me-based
       */
      diff = angle;
      diff -= 128;
#define max(a,b) ((a)>(b)?(a):(b))

      /*
       * update telltale.
       */
      {
        int dist = sqrt((double)(dx*dx + dy*dy))*6.0;
        if ((count%8) < 4)
        {
          int radius = max(1,(50 - dist));
          XDrawArc(sm->grafix.display,sm->grafix.gamebg,
                   sm->pgfx[play[me->follow].team].xgc,
                   hwidth-radius/2,hhigh-radius/2,radius, radius, 0, 360*64);
        }
      }
    }
  }
  gamebgtofg(); 
}

/*
static int clipit(int x1,int h1,int x2,int h2,int c)
{
  double t;
 
  t = (double) (x2 - c) / (double) (x2 - x1);
  h1 = h2 - (int) ((double) (h2 - h1) * t);
  return h1;
}
*/

/*********************************************
 * Copy background-pixmap to the foreground
 */

static void gamebgtofg(void)
{
  int x,y;
  unsigned int height,width;

  width  = sm->grafix.shint.width;
  height = sm->grafix.shint.height;
  
  x = (width-sm->grafix.gamewidth) >> 1; y = (height-sm->grafix.gameheight) >> 1;
  if((x > 0) || (y > 0))
  {
    XDrawRectangle(sm->grafix.display,sm->grafix.gamefg,sm->grafix.gc,
                   x-1,y-1,sm->grafix.gamewidth+1,sm->grafix.gameheight+1);
  }
  XCopyArea(sm->grafix.display,sm->grafix.gamebg,sm->grafix.gamefg,blackgc,
            0,0,sm->grafix.gamewidth,sm->grafix.gameheight,x,y);

  XSync(sm->grafix.display,0);
}

/***********************************
 * Draw 'Killed by' -Screen
 */

void draw_kill(PLAYER *play,int k)
{
  int r;
  char string[32];

  strcpy(string,play[k].name);
  strcpy(string+strlen(string)," says:");

  if(gfxshift >= 0)
    r = 128>>gfxshift;
  else
    r = 128<<(-gfxshift);

  XFillRectangle(sm->grafix.display,sm->grafix.gamebg,blackgc,
                 0,0,sm->grafix.gamewidth,sm->grafix.gameheight);  
  XFillArc(sm->grafix.display,sm->grafix.gamebg,sm->pgfx[play[k].team].xgc,
                 (sm->grafix.gamewidth>>1)-r,(sm->grafix.gameheight>>1)-r,
                 r<<1,r<<1,0,360*64);
  draw_smiley(sm->grafix.gamebg,sm->grafix.gamewidth>>1,sm->grafix.gameheight>>1,0,r);
  XDrawImageString(sm->grafix.display,sm->grafix.gamebg,sm->grafix.gc,
                   0,16,string,strlen(string));
  XDrawImageString(sm->grafix.display,sm->grafix.gamebg,sm->grafix.gc,
                   0,32,play[k].comment,strlen(play[k].comment));
  gamebgtofg();
}

/***************************+++
 * Draw Status
 */

void draw_status(int nr,PLAYER *play)
{
  int i,j,k;
  int len,fitpos,step,len1;
  int width = sm->grafix.sthint.width;
  int height = sm->grafix.sthint.height;
  XPoint points[1024];  

  if((play[nr].statchg == FALSE) && (sm->statchg == FALSE)) return;

  fitpos = width - 15;
  if(fitpos < 0) fitpos = 0;
  step = height / sm->numteams;
  if(step > 16) step = 16;
  len = width - 30;
  if(len < 0) len = 0; 
 
  if(sm->statchg)
  {
    XFillRectangle(sm->grafix.display,sm->grafix.statusfg,blackgc,0,0,width,height);

    for(i=1,k=0;i<=sm->numteams;i++)
      for(j=1;j<=sm->winneranz;j++)
        if(k<1024)
        {
          points[k].x = calc_pos(j,len);
          points[k].y = i*step-1;
          k++;
        }
    XDrawPoints(sm->grafix.display,sm->grafix.statusfg,whitegc,
                points,k,CoordModeOrigin);

    for(i=0;i<sm->numteams;i++) /* numteams */
    {
      XFillRectangle(sm->grafix.display,sm->grafix.statusfg,sm->pgfx[i].xgc,
                     0,i*step,calc_pos(sm->teams[i].kills,len),step-1);
    }
    if(nr >= 0)
    {
      len1 = calc_fitlen(play[nr].fitness,height);
      XFillRectangle(sm->grafix.display,sm->grafix.statusfg,
                     sm->pgfx[play[nr].team].xgc,fitpos,height-len1,10,len1);
    }
 /*   sm->statchg = FALSE; */
  }
  else
  {
    len1 = calc_fitlen(play[nr].fitness,height);
    XFillRectangle(sm->grafix.display,sm->grafix.statusfg,blackgc,
                   fitpos,0,10,height-len1);
    XFillRectangle(sm->grafix.display,sm->grafix.statusfg,
                   sm->pgfx[play[nr].team].xgc,fitpos,height-len1,10,len1);
  }
}

static int calc_pos(int num,int len)
{
  return ((int) ( (double) num / (double) sm->winneranz * (double) len));
}

static int calc_fitlen(int fit,int height)
{
  int i;
  i = (int) (( (long) fit * (long) height) / 2000) ;
  return (i<0)?0:i;
}

/******************************
 * Draw Kills
 */

void draw_kills(int nr,PLAYER *play)
{
  int i;

  if(sm->killchg)
  {
    XFillRectangle(sm->grafix.display,sm->grafix.killfg,blackgc,0,0,200,80);
    for(i=0;i<play[nr].killanz;i++)
    {
      XFillArc(sm->grafix.display,sm->grafix.killfg,
               sm->pgfx[play[play[nr].killtable[i]].team].xgc,
               (i%5)*40+4,(i/5)*40+4,36,36,0,360*64);
      draw_smiley(sm->grafix.killfg,(i%5)*40+22,(i/5)*40+22,0,18);
    }
    sm->killchg = FALSE;  
  }
  else if(play[nr].killchg)
  {
    if( (i = play[nr].killanz-1) < 0) return;
      XFillArc(sm->grafix.display,sm->grafix.killfg,
               sm->pgfx[play[play[nr].killtable[i]].team].xgc,
               (i%5)*40+4,(i/5)*40+4,36,36,0,360*64);
      draw_smiley(sm->grafix.killfg,(i%5)*40+22,(i/5)*40+22,0,18);    
  }
}


/******************************
 * Draw Info
 */

void draw_info(void)
{
  int i;
  int x,y;
  unsigned int height,width;

  width  = sm->grafix.shint.width;
  height = sm->grafix.shint.height;

  if((sm->screendraw) || (sm->winnerdraw))
  {
    x = (width-sm->grafix.gamewidth)>>1; y = (height-sm->grafix.gameheight)>>1;
    if((x <= 0) && (y <= 0)) return;

    XFillRectangle(sm->grafix.display,sm->grafix.gamefg,unilogogc,
                   0,0,sm->grafix.shint.width,y);
    XFillRectangle(sm->grafix.display,sm->grafix.gamefg,unilogogc,
                   0,y,x,sm->grafix.gameheight);
    XFillRectangle(sm->grafix.display,sm->grafix.gamefg,unilogogc,
                   x+sm->grafix.gamewidth,y,x,sm->grafix.gameheight);
    XFillRectangle(sm->grafix.display,sm->grafix.gamefg,unilogogc,
                   0,y+sm->grafix.gameheight,width,y);    
  }
  else
  {
    XFillRectangle(sm->grafix.display,sm->grafix.gamefg,unilogogc,
                   0,0,sm->grafix.shint.width,sm->grafix.shint.height);
  
  }

  for(i=0;strlen(infotext[i])!=0;i++)
  {
    XDrawImageString(sm->grafix.display,sm->grafix.gamefg,sm->grafix.gc,
                     5,16*(i+1),infotext[i],strlen(infotext[i]));
  }
}

/******************************
 * Setup Colors
 */

static void set_colors(PLAYER *players)
{
  XColor dummy,color;
  int i,j;

  char *colornames[] = { "Yellow" ,"Red" , "Green" , "Blue" , "SandyBrown" , 
                         "DarkOliveGreen", "Orange" , "DarkOrchid" , "Pink",
                         "VioletRed" , "LightBlue" , "LightCyan" , 
                         "RosyBrown" , "IndianRed" , "DeepPink" , "LightPink" ,
                         "yellowGreen" ,"orchid" , "lavender" , "lemonchiffon" ,
                         "YellowGreen" , "khaki" , "DarkKhaki" , "violet" , 
                         "plum" , "DarkOrchid" , "DarkViolet" , "PaleTurquoise" ,
                         "Turquoise" , "darkturquoise" , "coral" , "Black" ,NULL};


  char *dithercolors[] = {  "Yellow", "Red", "Green", "Blue", "cyan",
                             "magenta", "white", "black", NULL };
  char **colorpoint = colornames;
  char **bitmappoint = player_bits;
  char **ditherpoint = dithercolors; 
 
  if(sm->graymode && (sm->grafix.attribute.depth >= 4))
  {
    for(j=0,i=0;i<MAXPLAYERS;i++,bitmappoint++,j++)
    {
      if(*bitmappoint == NULL) bitmappoint--;
      sm->pgfx[i].xgc = mkmonomap(*bitmappoint);
    }
    hwallgc  = mkcolormap("DimGray");
    vwallgc  = mkcolormap("Gray");
    topgc    = mkcolormap("LightGray");
    bottomgc = mkcolormap("DarkGrey");

    XSetForeground(sm->grafix.display,sm->grafix.gc,
                   WhitePixel(sm->grafix.display,sm->grafix.screen)); 
  }
  else if((sm->grafix.attribute.depth >= 8) && !sm->monomode && !sm->dithermode)
  {
    hwallgc  = mkcolormap("DimGray");
    vwallgc  = mkcolormap("Gray");
    topgc    = mkcolormap("cornflowerblue");
    bottomgc = mkcolormap("steelblue");
    for(j=0,i=0;i<MAXPLAYERS;i++,colorpoint++,j++)
    {
      if(*colorpoint == NULL) colorpoint--;
      sm->pgfx[i].xgc = mkcolormap(*colorpoint);
    }
    XAllocNamedColor(sm->grafix.display,sm->grafix.cmap,"Yellow",&dummy,&color);
    XSetForeground(sm->grafix.display,sm->grafix.gc,color.pixel);   
  }
  else if((sm->grafix.attribute.depth >= 6) && !sm->monomode)
  {
    hwallgc = mkcolormap("DimGray");
    vwallgc = mkcolormap("Gray");
    topgc   = mkcolormap("cornflowerblue");
    bottomgc = mkcolormap("steelblue");

    colorpoint = dithercolors;

    for(j=0,i=0;i<MAXPLAYERS;i++,colorpoint++,j++)
    {
      if(*colorpoint == NULL) 
      {
        colorpoint = dithercolors;
        ditherpoint++;
        if (ditherpoint == NULL) 
          ditherpoint --;
      }
      sm->pgfx[i].xgc = mkdithermap(hwall_bits, *colorpoint, *ditherpoint);
    }

    XAllocNamedColor(sm->grafix.display,sm->grafix.cmap,"Yellow",&dummy,&color);
    XSetForeground(sm->grafix.display,sm->grafix.gc,color.pixel);   
  }
  else
  {
    for(j=0,i=0;i<MAXPLAYERS;i++,bitmappoint++,j++)
    {
      if(*bitmappoint == NULL) bitmappoint--;
      sm->pgfx[i].xgc = mkmonomap(*bitmappoint);
    }
    hwallgc  = mkmonomap(hwall_bits);
    vwallgc  = mkmonomap(vwall_bits);
    topgc    = mkmonomap(bgtop_bits);
    bottomgc = mkmonomap(bgbottom_bits);

    XSetForeground(sm->grafix.display,sm->grafix.gc,
                   WhitePixel(sm->grafix.display,sm->grafix.screen));  
  }
  
  unilogogc = mkunilogo();

  blackgc = XCreateGC(sm->grafix.display,sm->grafix.root,0,0);
  XSetForeground(sm->grafix.display,blackgc,
                 BlackPixel(sm->grafix.display,sm->grafix.screen));  
  XSetBackground(sm->grafix.display,blackgc,
                 WhitePixel(sm->grafix.display,sm->grafix.screen));
  whitegc = XCreateGC(sm->grafix.display,sm->grafix.root,0,0);
  XSetForeground(sm->grafix.display,whitegc,
                 WhitePixel(sm->grafix.display,sm->grafix.screen));  
  XSetBackground(sm->grafix.display,blackgc,
                 BlackPixel(sm->grafix.display,sm->grafix.screen));
  XSetBackground(sm->grafix.display,sm->grafix.gc,
                 BlackPixel(sm->grafix.display,sm->grafix.screen));
}

/****************************
 * Setup unilogo-gc
 */

static GC mkunilogo(void)
{
  Pixmap bitmp;
  GC gc;

  bitmp = XCreateBitmapFromData(sm->grafix.display,sm->grafix.root,unilogo_bits,
                                unilogo_width,unilogo_height);
  gc = XCreateGC (sm->grafix.display,sm->grafix.root,0,0);
  XSetStipple(sm->grafix.display,gc,bitmp);
  XSetFillStyle(sm->grafix.display,gc,FillOpaqueStippled);
  XSetForeground(sm->grafix.display,gc,
                 WhitePixel(sm->grafix.display,sm->grafix.screen));
  XSetBackground(sm->grafix.display,gc,
                 BlackPixel(sm->grafix.display,sm->grafix.screen));
  return gc;
}

/*********************************++
 * Setup Bitmap-Mono-gcs 
 */

static GC mkmonomap(char *bitmap)
{
  Pixmap bitmp;
  GC gc;

  bitmp = XCreateBitmapFromData(sm->grafix.display,sm->grafix.root,bitmap,16,16);
  gc = XCreateGC (sm->grafix.display,sm->grafix.root,0,0);
  XSetStipple(sm->grafix.display,gc,bitmp);
  XSetFillStyle(sm->grafix.display,gc,FillOpaqueStippled);
  XSetForeground(sm->grafix.display,gc,
                 WhitePixel(sm->grafix.display,sm->grafix.screen));
  XSetBackground(sm->grafix.display,gc,
                 BlackPixel(sm->grafix.display,sm->grafix.screen));
  return gc;
}

/***********************************
 * Setup color-gcs 
 */
 
static GC mkcolormap(char *name)
{
  XColor dummy,color;
  GC gc;
  Status s;

  s=XAllocNamedColor (sm->grafix.display,sm->grafix.cmap,name,&dummy,&color);  
  if(!s)
    fprintf(stderr, "Warning: Cannot allocate colormap entry for \"%s\"\n",name);
  gc = XCreateGC (sm->grafix.display,sm->grafix.root,0,0);
  XSetForeground (sm->grafix.display,gc,color.pixel);

  return gc;
}

/********************************
 * dither-gcs
 */

static GC mkdithermap(char *bitmap, char *fg, char *bg)
{
  Pixmap bitmp;
  XColor dummy,color;
  GC gc;
  Status s;

  bitmp = XCreateBitmapFromData(sm->grafix.display,sm->grafix.root,bitmap,16,16);
  gc = XCreateGC (sm->grafix.display,sm->grafix.root,0,0);
  XSetStipple(sm->grafix.display,gc,bitmp);
  XSetFillStyle(sm->grafix.display,gc,FillOpaqueStippled);

  s=XAllocNamedColor (sm->grafix.display, sm->grafix.cmap,fg,&dummy,&color);
  if (s == 0) 
    fprintf(stderr, "Warning: Cannot allocate colormap entry for \"%s\"\n",fg);
  XSetForeground(sm->grafix.display,gc, color.pixel);

  s=XAllocNamedColor (sm->grafix.display, sm->grafix.cmap,bg,&dummy,&color);
  if (s == 0) 
    fprintf(stderr, "Warning: Cannot allocate colormap entry for \"%s\"\n",bg);
  XSetBackground(sm->grafix.display,gc, color.pixel);
  return gc;
}

