#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <sys/param.h>

#include <X11/Xlib.h>
#include <X11/Xutil.h>
#include <X11/keysym.h>

/* select ONE of the following environments 
 * Use SunOS4, if you don't find your system in the list 
 */

#include "config.h" /* check out config.h for configuration */

#define NETMAZEPORT 12346

#define TRUE  1
#define FALSE 0

#define DRAWWAIT 1       /* 1 = Draw 3D-view every 'heart-beat' (if possible)*/
#define DRAWTIME 36000L  /* time per 'heart-beat' in microsec */

#define WINKEL_STEP 4    /* Rotate-Step (don't change) */
#define MAX_WINKEL 256   /* maximum-angel (don't change) */

#define XMAX 320	/* internal x-resolution (right-border)  */
#define XMIN -320	/* internal X-resolution (left-border)*/
#define YMAX 400	/* internal Y-resolution */

#define SCREEN 360	/* relativ position of the Screen (3D) */
#define FLUCHT -80	/*  */
#define WALLHEIGHT 80   /* wall-height / 2  */
#define SMILEYHEIGHT 100 /* Smileyheight */
#define SHOTHEIGHT 40   /* shotheight */
#define SMSCALE 1.6
#define STSCALE 4.0

#define MAXPLAYERS 32	 /* max. players (don't change) */
#define MAXSHOTS 16
#define MAZEDIMENSION 64 /* Groesse eines Mazes (maximal) */
#define BPL 128		 /* Bytes per Line (Maze) */
#define SCALE 20	 /* Vergroesserungsfaktor (Screen) */

#define SICHTWEITE 11	/* visual range in fields */

#define JOY_UP     0x01	/* OR-Codes for Joy-Values */
#define JOY_DOWN   0x02
#define JOY_LEFT   0x04
#define JOY_RIGHT  0x08
#define JOY_RADAR  0x10
#define JOY_HIDE   0x20
#define JOY_BUTTON 0x80

#define PRADIUS 0x40
#define SRADIUS 0x20

#define HITPOWER 1000
#define RECHARGESPEED 30
#define REFITSPEED  2
#define RELIVESPEED 10

#define WINNERANZ 10

#define MAXNAME 16
#define MAXCOMMENT 32

#define MAPSIZE 100

/* GAME-MODES ('-' = not used) */
#define GM_CLASSIC         0x0000 /* no options selectd */
#define GM_REFLECTINGSHOTS 0x0001 /* shots can bounce */
#define GM_DECAYINGSHOTS   0x0002 /* shots lose power */
#define GM_MULTIPLESHOTS   0x0004 /* allow more than one shot */
#define GM_WEAKINGSHOTS    0x0008 /* shooting weaks the player */
#define GM_REPOWERONKILL   0x0010 /* - repower player, if he kills an enemy */
#define GM_FASTRECHARGE    0x0020 /* faster recharg */
#define GM_FASTWALKING     0x0040 /* double-speed-walking */
#define GM_SHOWGHOST       0x0080 /* - ghostmode */
#define GM_ALLOWHIDE       0x0100 /* allow hideing */
#define GM_ALLOWRADAR      0x0200 /* allow radar */
#define GM_DESTRUCTSHOTS   0x1000 /* - destruct shots on kill */
#define GM_DECSCORE        0x2000 /* - decrease score of a killed player */
#define GM_RANKSCORE       0x4000 /* - rankingdependend score-bonus */

struct fd_mask 
{
  u_long fds_bits[NOFILE/32+1];  
}; 

typedef struct {
   int i;
  /* Namen , Sticks, Shoots, Positionen, Maze, Infos, Statistik, Teams ... */
  /* Settings , Farben, Muster .... */
} GAME;

/* Structur auf MAZE. Enthaelt alle wichtigen Daten zum Maze */

typedef struct {
 /* 
  MAZE *prev_maze;
  MAZE *next_maze;  
 */
  int hwalls[MAZEDIMENSION][MAZEDIMENSION];
  int vwalls[MAZEDIMENSION][MAZEDIMENSION];

  int xdim;
  int ydim;
  char *setlist;
  long *bitlist;
} MAZE;

/* PLAYER-Struct */

typedef struct {
  long sx;
  long sy;
  long sxd;
  long syd;
  int  salive;
  long power;
  int  next; /* next shot in chain */
  int  last; /* last shot in chain */
} SHOT;  

typedef struct { 
  short shot_power;
  short shot_weaking;
  short bounce_decay; /* 16384 = 1.0 */ 
  short shot_decay;   /* ! */
  short start_fitness;
  short max_shots;
  short relive; /* ! */
  short repower; /* ! */
  short recharge_delay; /* ! */
  short recolour_delay; /* ! */
  short angle_step; /* ! */
  short max_kills;
  int divider; /* ! */
} CONFIG;

typedef struct {
  char name[MAXNAME+1];
  char comment[MAXCOMMENT+1];
  int team;
  long x;
  long y;
  int winkel;
  int fitness;
  int follow;
  int hide,radar;
  int ownkills;       /* number of deaths */
  int ownkiller;      /* playernumber of latest killer */
  int killanz;        /* number of kills */
  int killtable[256]; /* table of killed players */
  int alive;          /* alive? */

  SHOT shots[MAXSHOTS];
  int shotqueue1;
  int shotqueue2;
  int numofshots;

  int  recharge;
  int  hitbycnt;
  int  hitby;
  int  statchg; /* Status changed .. (redraw) */
  int  killchg;
} PLAYER;	

typedef struct {
  int kills;
  char teamname[MAXNAME+1];
} TEAM;

typedef struct {
  int x1,h1;
  int x2,h2;
  int ident;
  int rclip,lclip;
  long xd,yd;
  long rmax,rmin;
} WALL;

typedef struct {
  Display    *display;
  Display    *display1;
  int        screen;
  Window     root;
  Drawable   gamefg;
  Drawable   gamebg;
  int        gamewidth;
  int        gameheight;
  Drawable   statusfg;
  Drawable   killfg;
  Drawable   mapfg;
  Drawable   mapbg;
  Colormap   cmap;
  GC         gc;
  XWindowAttributes attribute;
  XSizeHints shint;
  XSizeHints sthint;
  XSizeHints khint;
} GRAFIX;

typedef struct {
 GC xgc;
 GC facegc;
} PGRAFIX; 

typedef struct mapmark {
        int     x,y;
        int     player;
} mapmark;

struct shared_struct /* the most should be volatile */
{
  int shmid;                       /* Shared Memory id */
  char ownname[MAXNAME+1];         /* Playername */
  char owncomment[MAXCOMMENT+1];   /* Comment, if you kill another one */
  char hostname[256];              /* Remotehostname */

  volatile int winner;             /* Winner-Number */
  int anzplayers;                  /* Number of Players */
  int numteams;                    /* Number of Teams */
  int shownumber,shownumbertmp;    /* Player-View-Number */
  int joynumber;                   /* Player-Joy-Number (Solo) */
  int gamemode;			   /* GAME-MODES: not supported yet */
  CONFIG config;                   /* important configurevalues (unused) */
  PLAYER playfeld[MAXPLAYERS];     /* Player-Data-Field */
  PLAYER playfeld1[MAXPLAYERS];    /* Copy */
  TEAM teams[MAXPLAYERS];          /* team-data */
  PGRAFIX pgfx[MAXPLAYERS];        /* Player-Grafix-datas */
  int sticks[MAXPLAYERS];          /* Stick/Cursor/Mouse-Data */
  int ownstick;                    /* Joystick-Data on this machine */
  MAZE std_maze;                   /* MAZE-DATA */
  GRAFIX grafix;                   /* Grafix-(X11)-Data */
  XSegment maplines[1000];         /* Map-Line-Buffer */
  int anzlines;
  int marks;                       /* # markers */
  mapmark markers[32];             /* Map markers */
  int rndshiftpos;                 /* Random */
  long rndshifttab[55];            /* more random-stuff */
  volatile unsigned long drawwait; /* delay Draw .. */

  /* flags */
  volatile int gameflag:1;             /* Game-is-running-flag */
  int exitprg:1;                       /* Exitflag */
  int bgdraw:1,redraw:1;               /* Mainwindowredrawflag */
  int screendraw:1,winnerdraw:1;       /* more Mainwindowredrawflags */
  int statchg:1,statchg1:1,statchg2:1; /* Statusredrawflags */
  int killchg:1;                       /* Killsredrawflags */
  int sologame:1,mapdraw:1,debug:1;    /* Solomode-,Mapdraw-,Debugflag */
  int newmap:1,locator:1;
  int monomode:1,graymode:1,dithermode:1; /* Screenoutputflags */
  int outputsize;                      /* Outputsize */

  /* game-settings: */
  int winneranz;  /* Number of kills to win */  
};

