#include <stdio.h>
#include <stdlib.h>

#include <Intrinsic.h>
#include <StringDefs.h>
#include <Xaw/Command.h>
#include <Xaw/Label.h>
#include <Xaw/Form.h>
#include <Xaw/AsciiText.h>
#include "defs.h"
#include "externs.h"


Widget frequencyForm,frequencyHigh,frequencyLow;


/* Get the int value of a textwidget,
 * that expects user input of a number
 */
int GetWidgetNumberval(Widget w){
	String str;
	char tempstr[100];
	int retval;
	
	XtVaGetValues(w,XtNstring,&str,NULL);
	retval = atoi(str);
	if(retval == 0)
		tempstr[0] = '\0';
	else
		sprintf(tempstr,"%d",retval);
	
	XtVaSetValues(w,XtNstring,tempstr,NULL);
	return (retval);
}
/* UpdateFrequency()
 *	Change frequency restrictions on range of kanji used
 */
void 
UpdateFrequency(Widget w,XEvent *event,String *params,Cardinal *num_parags){
	int *setthis,oldvalue;

	if(w == frequencyHigh){
		setthis = &highfrequency;
		setstatus("Setting high frequency limit");
	} else if( w == frequencyLow){
		setthis = &lowfrequency;
		setstatus("Setting low frequency limit");
	} else {
		puts("??? HUh??? got update callback from imaginary widget??");
		exit(0);
	}

	oldvalue = *setthis;
	*setthis = GetWidgetNumberval(w);
	CountKanji();
	if(numberofkanji <9){
		char tempstr[30];
		setstatus("Too few kanji available!!");
		Beep();
		*setthis = oldvalue;
		sprintf(tempstr,"%d",oldvalue);
		XtVaSetValues(w,XtNstring,tempstr,NULL);
		/* and just reset numberofkanji value!! */
		CountKanji();
	} else {
		char numbuff[100];
		sprintf(numbuff,"%d characters active",numberofkanji);
		setstatus(numbuff);
	}
	
}


static char * freqAccel = 
 " <Key>Return:  update-frequency()";


/* MakeFrequency:
 *  make specialised "dialog box" that takes
 *  two input values, with labels next to each input area, and
 *  one make dialog label
 */
void MakeFrequency(){
	Widget mainlabel,highlabel,lowlabel;
	XtAccelerators Accel;
	char highvalue[10] = "";
	char lowvalue[10] = "";

	
	
	if(lowfrequency !=0)
		sprintf(lowvalue,"%d",lowfrequency);
	if(highfrequency !=0)
		sprintf(highvalue,"%d",highfrequency);

	frequencyForm = XtVaCreateManagedWidget(
			"freqForm",formWidgetClass,buttonform,
			XtNhorizDistance,GRADEDISTANCE,
			XtNvertDistance,10,
			XtNfromHoriz,usefilebutton,
			XtNfromVert,gradelevelForm,
			NULL);

	mainlabel = XtVaCreateManagedWidget("freqLabel",labelWidgetClass,frequencyForm,
			XtNlabel,"        Frequency Range",
			XtNborderWidth,0,
			NULL);

	highlabel = XtVaCreateManagedWidget(
			"freqhighLabel",labelWidgetClass,frequencyForm,
			XtNlabel,"High:",
			XtNfromVert,mainlabel,
			XtNborderWidth,0,
			NULL);
	frequencyHigh = XtVaCreateManagedWidget(
			"freqHigh",asciiTextWidgetClass,frequencyForm,
			XtNfromVert,mainlabel,
			XtNfromHoriz,highlabel,
			XtNeditType,XawtextEdit,
			XtNwidth,45,
			XtNstring,highvalue,
			NULL);
	lowlabel = XtVaCreateManagedWidget(
			"freqlowLabel",labelWidgetClass,frequencyForm,
			XtNlabel,"Low:",
			XtNfromVert,mainlabel,
			XtNfromHoriz,frequencyHigh,
			XtNborderWidth,0,
			NULL);
	frequencyLow = XtVaCreateManagedWidget(
			"freqLow",asciiTextWidgetClass,frequencyForm,
			XtNfromVert,mainlabel,
			XtNfromHoriz,lowlabel,
			XtNeditType,XawtextEdit,
			XtNwidth,50,
			XtNstring,lowvalue,
			NULL);

	Accel = XtParseAcceleratorTable(freqAccel);
	XtOverrideTranslations(frequencyHigh,Accel);
	XtOverrideTranslations(frequencyLow,Accel);
}
