/* $Id: install.c,v 1.1 94/04/28 17:41:23 leon Exp $ */
#include <stdio.h>
#include <signal.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <pwd.h>
#if defined(Mips) && defined(BSD43)
#include <sys/types.h>
#include <sys/dir.h>
#else
#include <dirent.h>
#include <stdlib.h>
#endif
#include <X11/Intrinsic.h>
#include <Xm/MessageB.h>
#include "main.h"
#include "error.h"
#include "misc.h"
#ifdef GCC_SUCKS
#include "gcc_sucks.h"
#endif /* GCC_SUCKS */

static Boolean exit_loop = False;

/* does a Xt main loop until the global exit_loop is true;
 * 
 * returns: 
 */
void 
LocalMainLoop()
{
    XEvent event;
    for (;;) {
	if(exit_loop) return;
    	XtAppNextEvent(app_context, &event);
	XtDispatchEvent(&event);
    }
}


/* Checks for installation of a mail dispatch mechanism
 * first looks for ~/.procmailrc, then for ~/.maildelivery
 * returns: TRUE if dispatch mechanism is detected, FALSE elsewhere
 */
int
CheckInstall()
{
    FILE *file;
    char fname[256];

    sprintf(fname, "%s/.procmailrc", getenv("HOME"));
    file = fopen(fname, "r");
    if(NULL != file) {
	fclose(file);
	return TRUE;
    }

    sprintf(fname, "%s/.maildelivery", getenv("HOME"));
    file = fopen(fname, "r");
    if(NULL != file) {
	fclose(file);
	return TRUE;
    }
    return FALSE;
}



/* DOES NOTHING
 * 
 * returns: nothing
 */
static void
TryInstallCB(Widget w, XtPointer client_data, XtPointer call_data)
{
    DisplayError(MSG[M_NOT_YET_IMPLEMENTED]);
}




/* Builds and Manages the install dialog
 * 
 * returns: void
 */
void
PopInstallDialog(Widget parent)
{
    static Widget installD = NULL;

    if(NULL == installD) {
	Widget w;
	installD = XmCreateWarningDialog(parent, "installD", 0, 0);
	w = XmMessageBoxGetChild(installD, XmDIALOG_CANCEL_BUTTON);
	XtUnmanageChild(w);
	XtAddCallback(installD, XmNhelpCallback, TryInstallCB, 0);
    }
    XtManageChild(installD);
}




/* if path does not exist, create it
 * 
 * returns: 
 */
static void
CheckDir(char *path)
{
    DIR *dir;

    dir = opendir(path);
    if(NULL == dir) {
#if defined(Mips) && defined(BSD43)
	mkdir(path, S_IREAD|S_IWRITE|S_IEXEC);
#else
	mkdir(path, S_IRWXU);
#endif
	return;
    }
    closedir(dir);
}


static void
ContinueCB(Widget w, 
	   XtPointer client_data, 
	   XtPointer call_data)
{
    exit_loop = True;
}



static void
AbortCB(Widget w, 
	   XtPointer client_data, 
	   XtPointer call_data)
{
    exit(1);
}


/* checks for some files
 * If .protocol-notify, another k-lendars may be running, raise an alert.
 * returns: 
 */
void
SanityChecks()
{
    char name[256];
    FILE *file;
    struct stat status;

    sprintf(name, "%s/.%s", getenv("HOME"), APP_NAME);
    CheckDir(name);
    sprintf(name, "%s/.%s/.groups", getenv("HOME"), APP_NAME);
    CheckDir(name);
    sprintf(name, "%s@%s", getlogin(), Globals.mailDomain);
    userEmail = strdup(name);

    /* write process id for dispatch scripts */
    sprintf(name, "%s/.%s/.protocol-notify", getenv("HOME"), APP_NAME);
    if(!stat(name, &status)) {
	/* another k-lendars may be running */
	Widget d, w;
	d = XmCreateErrorDialog(toplevel, "lockD", 0, 0);
	w = XmMessageBoxGetChild(d, XmDIALOG_HELP_BUTTON);
	XtUnmanageChild(w);
	XtAddCallback(d, XmNcancelCallback, AbortCB, 0);
	XtAddCallback(d, XmNokCallback, ContinueCB, 0);
	XtManageChild(d);
	XtRealizeWidget(d);
	exit_loop = False;
	LocalMainLoop();
    }
    sprintf(name, "%s/.%s/.protocol-notify", getenv("HOME"), APP_NAME);
    file = fopen(name, "w");
    gethostname(name, 256);
    if(NULL != file) {
	fprintf(file, "rsh %s kill -%d %d\n", name, SIGUSR1, getpid());
	fclose(file);
    }
}



void
Uninstall()
{
    char name[256];
    sprintf(name, "%s/.%s/.protocol-notify", getenv("HOME"), APP_NAME);
    unlink(name);
    
}
