/* $Id: alarm.c,v 1.1 94/04/28 17:41:08 leon Exp $ */
#include <stdio.h>
#include <X11/Intrinsic.h>
#include <Xm/PushB.h>
#include <Xm/MessageB.h>
#include <Xm/Scale.h>
#include "main.h"
#include "date.h"
#include "alarmD.h"
#include "alarm.h"

static Widget appointmentD = NULL;
extern AppointmentRec current;

static void
AlarmProc(XtPointer client_data, XtIntervalId *id);



/* update alarm values in the current appointment
 * 
 * returns: 
 */
static void
RegisterAlarmCB(Widget w,
	XtPointer client_data,
	XtPointer call_data)
{
    XmScaleGetValue(alarmD_minutes,  &current.alarm.minutes);
    XmScaleGetValue(alarmD_hours,  &current.alarm.hours);
    XmScaleGetValue(alarmD_days,  &current.alarm.days);
    XmScaleGetValue(alarmD_repeat,  &current.every);
    current.every *= 60; /* secs */
}

/* pops up the alarm dialog
 * 
 * returns: 
 */
void
AlarmCB(Widget w,
	XtPointer client_data,
	XtPointer call_data)
{
    if(NULL == alarmD) {
	Build_alarmD_1(toplevel);
	XtAddCallback(alarmD_ok, XmNactivateCallback, RegisterAlarmCB, 0);
    }
    XmScaleSetValue(alarmD_minutes,  current.alarm.minutes);
    XmScaleSetValue(alarmD_hours,  current.alarm.hours);
    XmScaleSetValue(alarmD_days,  current.alarm.days);
    XmScaleSetValue(alarmD_repeat,  current.every);
    XtManageChild(alarmD);
}


/* called when the user press the snooze button
 * If the alarm contains snooze time, use it, else use the defaultSnooze
 * global variable
 * returns: 
 */
static void
SnoozeCB(Widget w,
	 XtPointer client_data,
	 XtPointer call_data)
{
    Appointment ap;
    XtIntervalId id;
    XtVaGetValues(appointmentD, XmNuserData, &ap, 0);
    if(0 != ap->every) {
	id=
	XtAppAddTimeOut(app_context, (unsigned long)ap->every*1000UL, 
			AlarmProc, (XtPointer)ap);
    }
    else {
	id=
	XtAppAddTimeOut(app_context, 
			(unsigned long)Globals.defaultSnooze*1000UL, 
			AlarmProc, (XtPointer)ap);	
    }
    ap->timeout = id;
}


/* called when user press "shut up"
 * set the next alarm for the considered appointment
 * returns: 
 */
static void
ShutUpCB(Widget w,
	 XtPointer client_data,
	 XtPointer call_data)
{
    Appointment ap;
    XtVaGetValues(appointmentD, XmNuserData, &ap, 0);
    InstallAlarmsFor(ap);
}



/* Pops up the alarm message.
 * If this alarm has a repeat condition, sets a new timeout.
 * returns: 
 */
void
AlarmProc(XtPointer client_data, XtIntervalId *id)
{
    XmString xms;
    Appointment ap = (Appointment)client_data;

    if(NULL == appointmentD) {
	appointmentD = XmCreateMessageDialog(toplevel, "appointmentD", 0, 0);
	XtAddCallback(appointmentD, XmNcancelCallback, SnoozeCB, 0);
	XtAddCallback(appointmentD, XmNokCallback, ShutUpCB, 0);
	XtUnmanageChild(XmMessageBoxGetChild(appointmentD, 
					     XmDIALOG_HELP_BUTTON));
    }
    xms = XmStringCreateSimple(ap->note);
    XtVaSetValues(appointmentD, 
		  XmNmessageString, xms, 
		  XmNuserData, (XtPointer)ap,
		  0);
    XmStringFree(xms);
    XtManageChild(appointmentD);
    
}




/* Install an Xt timeout to be called on  date - ap->alarm
 * 
 * returns: timeout Id if an alarm as been set, 0 elsewhere
 */
XtIntervalId
InstallAlarm(AppointmentId ap, CalendarId ignored, void *closure)
{
    long secs, alarm;
    Date *date = (Date *)closure;

    if((0 == ap->alarm.days) &&
       (0 == ap->alarm.hours) &&
       (0 == ap->alarm.minutes))
	/* no alarm set */
	return 0;
    alarm = (((ap->alarm.days * 24) + ap->alarm.hours) * 60) + 
	ap->alarm.minutes;
    alarm *= 60; /* seconds */
    secs = DateToTime_t(*date) - time(0) - alarm;
    if(secs < 0)              /* alarm passed */
	return 0;
#ifdef Debug
    fprintf(stderr, "setting alarm in %d minutes (%d secs)\n", secs/60, secs);
#endif /* Debug */
    /* remove old timeout if there's one */
    if(ap->timeout)
	XtRemoveTimeOut(ap->timeout);
    ap->timeout = 
	XtAppAddTimeOut(app_context, (unsigned long)secs*1000UL, 
			AlarmProc, (XtPointer)ap);
    return ap->timeout;
}




/* Install alarms for the appointment
 * As an alarm may be set one week before, we must check if this appointment
 * requires an alarm on 7 days.
 * we set only the first alarm for this appointment, next one will be set
 * once the alarm trigger.
 * returns: 
 */
void
InstallAlarmsFor(Appointment ap)
{
    Date day;
    int i;
    day = Today();

    for(i = 0; i < 7; i++) {
	if(AppointmentDayMatch(ap, &day)) {
	    day.hour = ap->date.hour;
	    day.minute = ap->date.minute;
	    if(InstallAlarm(ap, 0, (void *)&day)) 
		return;
	}
	day = NextDay(day);
    }
}


/* if there is an alarm set for ap, remove it
 * 
 * returns: 
 */
void
RemoveAlarmsFor(Appointment ap)
{
    if(0 != ap->timeout)
	XtRemoveTimeOut(ap->timeout);
}




void
InstallWeekAlarms()
{
    AgendaEnumerateAnyAppointments(agenda, 
				  (AgendaIteratorProc)InstallAlarmsFor, 0);
}

