/* $Id: Year.h,v 1.1 94/04/28 17:41:02 leon Exp $ */

#ifndef _Year_h
#define _Year_h

/****************************************************************
 *
 * Year widget
 *
 ****************************************************************/

typedef struct _YearClassRec*	YearWidgetClass;
typedef struct _YearRec*	YearWidget;


#include "date.h"
#include "cal.h"


#define XtNagenda "agenda"
#define XtCAgenda "Agenda"
#define XtNyear "year"
#define XtCYear "Year"
#define XtNdateCallback "dateCallback"
#define XtRWeekDay "WeekDay"
#define XtCMonthColor "MonthColor"
#define XtNappointmentColor "appointmentColor"
#define XtCAppointmentColor "AppointmentColor"


#define XtNdayForeground "dayForeground"
#define XtNdayBackground "dayBackground"
#define XtNclosedDayForeground "closedDayForeground"
#define XtNclosedDayBackground "closedDayBackground"
#define XtNtodayForeground "todayForeground"
#define XtNtodayBackground "todayBackground"
#define XtCDayForeground "DayForeground"
#define XtCDayBackground "DayBackground"

#define XtNclosedDaysFile "closedDaysFile"


#define XtNjanuary "january"
#define XtCJanuary "January"
#define XtNjanuaryColor "januaryColor"
#define XtNfebruary "february"
#define XtCFebruary "February"
#define XtNfebruaryColor "februaryColor"
#define XtNmarch "march"
#define XtCMarch "March"
#define XtNmarchColor "marchColor"
#define XtNapril "april"
#define XtCApril "April"
#define XtNaprilColor "aprilColor"
#define XtNmay "may"
#define XtCMay "May"
#define XtNmayColor "mayColor"
#define XtNjune "june"
#define XtCJune "June"
#define XtNjuneColor "juneColor"
#define XtNjuly "july"
#define XtCJuly "July"
#define XtNjulyColor "julyColor"
#define XtNaugust "august"
#define XtCAugust "August"
#define XtNaugustColor "augustColor"
#define XtNseptember "september"
#define XtCSeptember "September"
#define XtNseptemberColor "septemberColor"
#define XtNoctober "october"
#define XtCOctober "October"
#define XtNoctoberColor "octoberColor"
#define XtNnovember "november"
#define XtCNovember "November"
#define XtNnovemberColor "novemberColor"
#define XtNdecember "december"
#define XtCDecember "December"
#define XtNdecemberColor "decemberColor"


#define XtNdateFormat "dateFormat"
#define XtCDateFormat "DateFormat"

#define XtNmonday "monday"
#define XtCMonday "Monday"
#define XtNtuesday "tuesday"
#define XtCTuesday "Tuesday"
#define XtNwednesday "wednesday"
#define XtCWednesday "Wednesday"
#define XtNthursday "thursday"
#define XtCThursday "Thursday"
#define XtNfriday "friday"
#define XtCFriday "Friday"
#define XtNsaturday "saturday"
#define XtCSaturday "Saturday"
#define XtNsunday "sunday"
#define XtCSunday "Sunday"



#define XtNlayout "layout"
#define XtCLayout "Layout"




extern String XtNmonths[];
extern WidgetClass yearWidgetClass;


typedef struct _YearCallbackStruct {
    int reason;
    XEvent *event;
    Calendar cal;
    Date date;
} YearCallbackStruct;




/* 
   D: Check if the specified day is closed
   P: (the Year Widget, month, day)
   R: True, if this day is closed for the widget's year. False otherwise
   E: 
   */
Boolean
YearIsClosedDay(Widget w, Month m, Day d);


/*
  D: mark the specified day as having an appointment
  P: (the Year Widget, month, day)
  R: 
  E: 
  */
void
YearAddAppointment(Widget w, Month month, Day day);




/* D: Check if the specified day has an appointment
   P: (the Year Widget, month, day)
   R: True, if this day has appointment for the widget's year. 
   False otherwise
   E: 
   */
Boolean
YearFindAppointment(Widget w, 
		    Month month, 
		    Day day);



/* D: rebuild the appointment list for the widget's year
   P: the Year widget
   R: 
   E: 
   */
void
YearScanAppointments(Widget w);




/* D: rebuild the closed days list for the widget's year
   P: the Year widget
   R: 
   E: 
   */
void
YearScanClosedDays(Widget w);



/* D: find the xy location of the month in the Year widget, depending of the 
   widget's layout
   P: the Year widget
   R: the x & y coordinates
   E:
   */
void
YearLocateMonth(Widget w, Month month, int *x, int *y);


/* checks if today's date in the widget is today, redraws it if different.
 * 
 * returns: 
 */
void
YearCheckToday(Widget w);


void
YearGetDateString(Widget w, 
		  Date date, 
		  char *str);


#endif /* _Year_h */
