#ifndef DRAW_H_
#define DRAW_H_

#include <X11/Xlib.h>

#include "data.h"


typedef struct {
    int x;
    int y;
    int w;
    int h;
} Rectangle;

extern void add_rect (int x, int y, int w, int h);
extern void flush_rects (void);

extern void present (void);
extern void do_scroll (void);
extern void draw_init (void);
extern void draw_room (void);
extern void xor_floor (int x, int y);
extern void xor_item (int val, int x, int y, int maskno, int forcecolor);
extern int make_teleport_sprite (int sprite);
extern void put_sprite (int sprite, int x, int y, int c);
extern void put_sprite_noxor (int sprite, int x, int y, int c);
extern void draw_rescue (int cnt);
extern void show_tripswitch (int state);
extern void show_nb_items_taken (void);
extern void show_time (int cnt);
extern void flash_dead (int x, int y, int n);

extern void draw_liane_pixels (XPoint *points, int n);
extern void draw_thread (int x, int y, int cnt);
extern void move_rocket (void);
extern void move_boat (void);
extern void move_tree (void);
extern void clear_tree (void);


#define XSPRITE 32
#define YSPRITE 32
typedef unsigned int bits32;
extern bits32 mask[NMONSTERS][YSPRITE];

extern int sprites_collide (int spr1, int x1, int y1, int spr2,int x2,int y2);
extern int pixel_collide (int spr, int xs, int ys, int x, int y);


extern void set_colormaps (int on);
extern void enable_colormap (int enable);


#endif /* DRAW_H_ */
