/* $Id: xpm.c,v 1.1 93/10/01 14:47:34 leon Exp Locker: leon $ */


#include <stdio.h>
#include <X11/Xlib.h>
#include <X11/Intrinsic.h>
#include <X11/StringDefs.h>
#include <X11/Shell.h>
#include <X11/Xaw/Toggle.h>
#include <X11/Xaw/Simple.h>
#include <X11/Xaw/Label.h>
#include "InsetShell.h"
#include "itserver.h"
#include "xpm.h"



static int NewClient(ItChannel *channel, ItHeader *header, ItData *in, 
		     ItData *out, char *ins, char **outs)

{
    Widget inset;
    Pixmap pix = 0, mask = 0;
    XpmAttributes att;
    int ErrorStatus;


    inset = XtVaAppCreateShell("inset", "Inset", insetShellWidgetClass, 
			       channel->dpy, 
			       ItNwindow, (XtArgVal)None, 
			       ItNchannel, channel,
			       ItNremoteID,  header->sender,
			       NULL);

    att.valuemask = 0;
    ErrorStatus = XpmReadFileToPixmap(channel->dpy, 
				      DefaultRootWindow(channel->dpy),
				      ins, &pix, &mask, &att);

    if(ErrorStatus == XpmSuccess) {
	Arg args[4]; 
	int n = 0;

	XtSetArg(args[n], XtNwidth, att.width); n++;
	XtSetArg(args[n], XtNheight, att.height); n++;
	XtSetValues(inset, args, n);

	XtVaCreateManagedWidget(ins, labelWidgetClass, inset, 
				XtNbitmap, pix,
				XtNwidth, att.width,
				XtNheight, att.height,
				NULL);
    }
    else {
	char name [256];
	sprintf(name, "[%s]", ins);
	XtVaCreateManagedWidget(name, toggleWidgetClass, inset, 
				NULL);
	
    }
    
}


extern void ItSetWindow(Widget, Window);

static int ClientDead(ItChannel *channel, ItHeader *header, ItData *in, 
		     ItData *out, char *ins, char **outs)

{
    ItDispatcher d;
    int i;

    d = channel->dth;
    for(i = 0; i < d.lh; i++) {
	Widget w;
	Arg args[4];
	int n, j;
	Cardinal num;
	WidgetList children;
	Window win;

	w = (d.handlers[i]).local;

	_XtUnregisterWindow(XtWindow(w), w);

/*	n = 0;
	XtSetArg(args[n], XtNwindow, None); n++;
	XtSetValues(w, args, n);*/
	ItSetWindow(w, None);



	n = 0;
	XtSetArg(args[n], XtNnumChildren, &num); n++;
	XtSetArg(args[n], XtNchildren, &children); n++;
	XtGetValues(w, args, n);
	for(j = 0; j < num; j++) {
	    Widget child = children[j];

	    n = 0;
	    _XtUnregisterWindow(XtWindow(child), child);
	    ItSetWindow(child, None);
/*
	    XtSetArg(args[n], XtNwindow, None); n++;
	    XtSetValues(child, args, n);
*/
	}
	XtDestroyWidget(w); 
    }
}


main(int argc, char **argv)
{
    ItChannel *server;
    XEvent event;
    XtAppContext app_context;
    Widget shell;
    int n = 0;


    shell = XtAppInitialize(&app_context, "Inset", NULL, 0, &argc, argv,
			    NULL, NULL, 0);
    server = ItAppServerInitialize(XtDisplay(shell), "XPM", 
				   NewClient, ClientDead);
    fprintf(stderr, "--- xpm inset server ready ---\n");
    for (;;) {
	XtAppNextEvent(app_context, &event);
	if(!XtDispatchEvent(&event)) {
	    ItServerDispatchEvent(server, &event);
	};
    };
}
