/* $Id: itclient.c,v 1.1 93/10/01 14:47:28 leon Exp Locker: leon $ */
#include <X11/Xatom.h>
#include <stdio.h>
#include "itclient.h"




static Window
ItClientOpenSubChannel(Display *dpy, Window server, char *group)
{
/* 
try to open a new communication channel.
Return Value: None if an error occured or channel ID
*/
    Window win;

    win = XCreateWindow(dpy, server, 
			0, 0, 10, 10, 0, 0, InputOutput, CopyFromParent,
			StructureNotifyMask|PropertyChangeMask, None);
    if(win == None) {
	it_error = IT_ERROR_BAD_CHANNEL;
	return None;
    };
#ifdef DebugP
    DEBUG( "ItClientOpenSubChannel: openning channel 0x%x\n", 
	    win);
#endif /* DebugP */
    XSelectInput(dpy, win, StructureNotifyMask|PropertyChangeMask);
    return win;
}


static Window
ItClientGetServerChannel(Display *dpy, Atom type)
{
    Window *channels;
    Window win;
    Atom atr;
    int afr;
    int offset = 0;
    unsigned long nr, bar;
    unsigned char *pr;
    

    XGetWindowProperty(dpy, DefaultRootWindow(dpy), type, 
		       0, 1, False, XA_WINDOW, &atr, &afr, 
		       &nr, &bar, (unsigned char **)&pr);
    channels = (Window *)pr;
    if(!channels) {
	DEBUG( 
		"ItClientGetServerChannel: cannot connect the server\n");
	return None;
    }
    win = *channels;
    if(pr) XFree(pr);
#ifdef DebugP
    DEBUG( "ItClientGetServerChannel: calling server on 0x%x\n", 
	    win);
#endif /* DebugP */

    /* We should test if the window contains a server-specific property */
    return win;

}


int ItClientStdXErrorHandler(Display *dpy, XErrorEvent *event)
{
    DEBUG( "*** No server is present ***\n");
    exit(1);
}


ItChannel *
ItAppClientInitialize(Display *dpy, char *group)
{
/* To initiliaze a client, we must create a window as private channel, 
   write the channel id to the root window property named "INSET_<group"
   and wait for a server reply.
*/
    XEvent event;
    ItChannel *channel;


    ItInitialize(dpy);
    channel = (ItChannel *)malloc(sizeof(ItChannel));
    if(!channel) {
	it_error = IT_ERROR_BAD_ALLOC;
	return NULL;
    };

    channel->dpy = dpy;
    channel->read_prop = XA_FROM_INSET;
    channel->write_prop = XA_TO_INSET;
    ItDispatcherInitialize(&(channel->dth), 32, 32);

    channel->type = ItGetAtom(dpy, INSET, group);
    if(channel->type == None) return NULL;

    channel->server = ItClientGetServerChannel(dpy, channel->type);
    if(channel->server == None) return NULL;

    /* Set up an error handler to detect if NO server is running */
    XSetErrorHandler(ItClientStdXErrorHandler);
    XSynchronize(dpy, True);
    /* StructureNotifyMask to know when server die, PropertyChangeMask to 
       know when we are connected*/
    XSelectInput(dpy, channel->server, 
		 StructureNotifyMask|PropertyChangeMask);
    XSynchronize(dpy, False);
    

    /* We should set here an X-Error handler to prevent a BadWindow error, if
       server does not exist anymore */
    channel->win = ItClientOpenSubChannel(dpy, channel->server, group);
    if(channel->win == None) return NULL;
/*    XSelectInput(dpy, res->win, StructureNotifyMask|PropertyChangeMask);*/

    /* could be replaced, if the server tracks the SubStructureNotify
       events */
    XChangeProperty(dpy, channel->server, channel->type, XA_WINDOW, 32,
		    PropModeAppend, (unsigned char *)&channel->win, 1);
    XFlush(dpy);
    /* Here we should check the property's return value */
    /* we'll be connected when the server will have replied on its channel */

    if(ItWaitForReply(*channel)) {
	ItReleaseToken(*channel);
	return channel;
    }
    else{ 
	it_error = IT_ERROR_CHANNEL_CLOSED;
	return NULL;
    };
};








