/* $Id: dispatch.c,v 1.1 93/10/01 14:47:25 leon Exp Locker: leon $ */
#include <X11/Xlib.h>
#include <stdio.h>
#include "itlib.h"





void 
ItDispatcherInitialize(ItDispatcher *d, int maxm, int maxh)
{
    d->nm = maxm;
    d->nh = maxh;
    d->lh = 0;
    d->methods = (ItMethods)malloc(sizeof(ItMethod) * maxm);
    d->handlers = (ItHandlers)malloc(sizeof(ItHandler) * maxh);
    bzero(d->methods, sizeof(ItMethod) * maxm);
    bzero(d->handlers, sizeof(ItHandler) * maxh);
}



void *
ItGetHandler(ItChannel *channel, ItObject remote)
{
    int i;
    ItDispatcher *d = &(channel->dth);
    for(i = 0; i < d->nh; i++) {
	if(d->handlers[i].remote == remote) {
	    return d->handlers[i].local;
	}
    }
    return NULL;
}



void 
ItSetHandler(ItChannel *channel, ItObject remote, ItObject local)
{
    ItDispatcher *d = &(channel->dth);
    if(d->lh < d->nh) {
	d->handlers[d->lh].remote = remote;
	d->handlers[d->lh].local = local;
	d->lh++;
    }
    else {
	DEBUG( "ItDispactherSetHandler: Could not add handler\n");
    };
}




void 
ItSetMethod(ItChannel *channel, ItFunction f, ItMethod m)
{
    ItDispatcher *d = &(channel->dth);
    if((f > 0) && (f < d->nm)) {
	d->methods[f] = m;
    }
    else {
	DEBUG( "ItDispatcherSetMethod: Could not set method\n");
    };
}



unsigned
ItDispatchEvent(ItChannel *channel, XEvent *e1)
{
    int need_reply = False;
    XAnyEvent *event = (XAnyEvent *)e1;
    Window win = event->window;

    if(win == channel->win) {
	switch(e1->type) {
	case PropertyNotify:{
	    XPropertyEvent *e;
	    ItData data;
	    ItData out;
	    char *ins, *outs = NULL;
	    ItHeader header;
	    ItObject handler;
	    char *p;
	    int res;
	    
	    e = (XPropertyEvent *)e1;
	    if((e->state == PropertyNewValue) && (e->atom == XA_TO_INSET)){
		ItRead(*channel, channel->read_prop, &header, &data, &ins);
		if(header.f | IT_NEED_REPLY) need_reply = True;
		header.f &= IT_F_MASK;
		handler = ItGetHandler(channel, header.sender);
		if((header.f > 0) && (header.f <= channel->dth.nm)) {
		    ItMethod m = channel->dth.methods[header.f];
#ifdef DebugP
		    DEBUG("ItDispatchEvent: %d on 0x%x\n", header.f, handler);
#endif /* DebugP */ 
		    if(m) {
			res = (*m)(handler,  &data, &out, ins, &outs);
		    }
		    else {
			DEBUG( 
				"ItDispatchEvent: %d has a NULL method\n", 
				header.f);
		    }
		}
		else {
		    /* this is a non-supported call */
		    (*(channel->init_proc))(channel, &header,  &data, &out, 
					  ins, &outs);
		    res = 0;
		};
		if(need_reply) {
		    ItReply(*channel, res, &out, outs);
		}
		ItReleaseToken(*channel);
	    }
	}
	    return True;
	case DestroyNotify:{
	    XDestroyWindowEvent *e = (XDestroyWindowEvent *)event;
#ifdef Debug
	    DEBUG("ItDispatchEvent: client 0x%x is DEAD\n", e->window);
#endif /* Debug */
	    if(channel->crash_proc)
		(*(channel->crash_proc))(channel, NULL, NULL, 
					 NULL, NULL, NULL);
	    ItDispatcherInitialize(&(channel->dth), 32, 32);
	    channel->win = None;
	    
/*	    exit(1);*/
	    return True;
	}
	}
    }
    return False; /* not dispatched */
}
