/* $Id: InsetShell.c,v 1.1 93/10/01 14:47:23 leon Exp Locker: leon $ */
#include <X11/IntrinsicP.h>
#include <X11/Shell.h>
#include <X11/StringDefs.h>
#include "InsetShellP.h"
#include "itlib.h"
#include "inset.h"

static XtResource resources[] = {
#define offset(field) XtOffsetOf(InsetShellRec, insetShell.field)
    /* {name, class, type, size, offset, default_type, default_addr}, */
    { XtNwindow, XtCWindow, XtRWindow,
	  sizeof(Window), offset(window), XtRWindow, None },
    { ItNchannel, ItCChannel, ItRChannel,
	  sizeof(ItChannel *), offset(channel), ItRChannel, None },
    { ItNremoteID, ItCRemoteID, ItRObject,
	  sizeof(ItObject), offset(remoteID), ItRObject, None },

#undef offset
};



void ItSetWindow(Widget widget, Window window)
{
    widget->core.window = window;
}


static void Initialize(Widget w, Widget new, ArgList args, Cardinal n)
{
    InsetShellWidget wid=(InsetShellWidget)new;

    ItSetHandler(wid->insetShell.channel, wid->insetShell.remoteID, wid);

    ItSetMethod(wid->insetShell.channel, REALIZE, 
		InsetShellRealize);
    ItSetMethod(wid->insetShell.channel, QUERY_GEOMETRY, 
		InsetShellQueryGeometry);
    ItSetMethod(wid->insetShell.channel, DESTROY, 
		InsetShellDestroy);
}




static void 
Realize(Widget w, XtValueMask *value_mask,
	XSetWindowAttributes *attributes)
{
    InsetShellWidget win = (InsetShellWidget)w;
    win->core.window = win->insetShell.window;
    win->core.width = 100;
    win->core.height = 100;

};



static ShellClassExtensionRec shellClassExtRec = {
    NULL,
    NULLQUARK,
    XtShellExtensionVersion,
    sizeof(ShellClassExtensionRec),
    XtInheritRootGeometryManager
};




static void Resize(w)
    Widget w;
{
    register ShellWidget sw = (ShellWidget)w;    
    Widget childwid;
    int i;
#ifdef Debug
    DEBUG("InsetShell::Resize\n");
#endif /* Debug */
    for(i = 0; i < sw->composite.num_children; i++) {
        if (XtIsManaged(sw->composite.children[i])) {
             childwid = sw->composite.children[i];
             XtResizeWidget(childwid, sw->core.width, sw->core.height,
                           childwid->core.border_width);
	     break;		/* can only be one managed child */
        }
    }
}

static void ChangeManaged(Widget w);


InsetShellClassRec insetShellClassRec = {
    {/* core fields */
    /* superclass		*/	(WidgetClass) &shellClassRec,
    /* class_name		*/	"InsetShell",
    /* widget_size		*/	sizeof(InsetShellRec),
    /* class_initialize		*/	NULL,
    /* class_part_initialize	*/	NULL,
    /* class_inited		*/	FALSE,
    /* initialize		*/	(XtInitProc)Initialize,
    /* initialize_hook		*/	NULL,
    /* realize			*/	Realize,
    /* actions			*/	NULL,
    /* num_actions		*/	0,
    /* resources		*/	resources,
    /* num_resources		*/	XtNumber(resources),
    /* xrm_class		*/	NULLQUARK,
    /* compress_motion		*/	TRUE,
    /* compress_exposure	*/	TRUE,
    /* compress_enterleave	*/	TRUE,
    /* visible_interest		*/	FALSE,
    /* destroy			*/	NULL,
    /* resize			*/	Resize,
    /* expose			*/	NULL,
    /* set_values		*/	NULL,
    /* set_values_hook		*/	NULL,
    /* set_values_almost	*/	XtInheritSetValuesAlmost,
    /* get_values_hook		*/	NULL,
    /* accept_focus		*/	NULL,
    /* version			*/	XtVersion,
    /* callback_private		*/	NULL,
    /* tm_table			*/	NULL,
    /* query_geometry		*/	XtInheritQueryGeometry,
    /* display_accelerator	*/	XtInheritDisplayAccelerator,
    /* extension		*/	NULL
    },
    {/* composite class fields */
     /* geometry_manager */             XtInheritGeometryManager,
     /* change_managed */               ChangeManaged,
     /* insert_child */                 XtInheritInsertChild,
     /* delete_child */                 XtInheritDeleteChild,
     /* extension */                    NULL
     },
     {/* shell class fields */
      /* extension */                   (XtPointer)&shellClassExtRec
     },
     {/* WMshell class fields */
      /* extension */                   NULL
     },
     {/* Vendorshell class fields */
      /* extension */                   NULL
     },
	
  { /* insetShell fields */
    /* empty			*/	0
  }
};

WidgetClass insetShellWidgetClass = (WidgetClass)&insetShellClassRec;


static void ChangeManaged(wid)
    Widget wid;
{
    InsetShellWidget w = (InsetShellWidget) wid;
    Widget child = NULL;
    int i;
    Window win, root;
    int xR, yR, width, height, bwR, dR;

    win = ((InsetShellWidget)wid)->insetShell.window;

    XGetGeometry(XtDisplay(wid), win, &root, &xR, &yR, &width, 
		 &height, &bwR, &dR);

    w->core.width = width;
    w->core.height = height;

    Resize(w);
}


XtGeometryResult QueryGeometry(Widget w, 
			       XtWidgetGeometry *intended,
			       XtWidgetGeometry *preferred)
{
    register ShellWidget sw = (ShellWidget)w;    
    Widget childwid;
    int i;
    for(i = 0; i < sw->composite.num_children; i++) {
        if (XtIsManaged(sw->composite.children[i])) {
             childwid = sw->composite.children[i];
	     return XtQueryGeometry(childwid, intended, preferred);
	 }
    }
}


int InsetShellQueryGeometry(void *handler,  ItData *in, 
			    ItData *out, char *ins, char **outs)
{
    Widget wid=(Widget)handler;
    XtWidgetGeometry intended, preferred;
    int res;
    char *reply;
#ifdef Debug
    DEBUG("QueryGeometry %s\n", XtName(wid));
#endif /* Debug */
    intended.request_mode = in->i1;
    intended.x = in->i2;
    intended.y = in->i3;
    intended.width = in->i4;
    intended.height = in->i5;
    intended.border_width = in->i6;
    intended.sibling = (Widget)in->i7;
    intended.stack_mode = in->i8;

    res = QueryGeometry(wid, &intended, &preferred);
#ifdef Debug
    switch (res) {
    case XtGeometryYes: DEBUG("QueryGeometry --> XtGeometryYes = %dx%d\n",
			       preferred.width, preferred.height); 
	break;
    case XtGeometryNo: DEBUG("QueryGeometry --> XtGeometryNo = %dx%d\n",
			       preferred.width, preferred.height); 
	break;
    case XtGeometryAlmost: DEBUG("QueryGeometry --> XtGeometryAlmost = %dx%d\n",
			       preferred.width, preferred.height); 
	break;
    case XtGeometryDone: DEBUG("QueryGeometry --> XtGeometryDone = %dx%d\n",
			       preferred.width, preferred.height); 
	break;
    default: DEBUG("QueryGeometry --> Unknown value\n");
    }
#endif /* Debug */

    out->i1 = preferred.request_mode;
    out->i2 = preferred.x;
    out->i3 = preferred.y;
    out->i4 = preferred.width;
    out->i5 = preferred.height;
    out->i6 = preferred.border_width;
    out->i7 = (int)preferred.sibling;
    out->i8 = preferred.stack_mode;

    return res;
};


int InsetShellRealize(void *handler,  ItData *in, ItData *out, 
		      char *ins, char **outs)
{
    Arg args[3];
    int n = 0;
    Window win;
    Widget wid=(Widget)handler;

#ifdef Debug
    DEBUG("Realize %s\n", XtName(wid));
#endif /* Debug */

    win = (Window)in->i1;

    XtSetArg(args[n], XtNwindow, win); n++;
    XtSetValues(wid, args, n);
    XtRealizeWidget(wid);
    XSelectInput(XtDisplay(wid), XtWindow(wid), XtBuildEventMask(wid));
}



int InsetShellDestroy(void *handler,  ItData *in, ItData *out, 
		      char *ins, char **outs)
{
    Arg args[3];
    int n = 0;
    Window win;
    Widget wid=(Widget)handler;

#ifdef Debug
    DEBUG("Destroy %s\n", XtName(wid));
#endif /* Debug */

    XSelectInput(XtDisplay(wid), XtWindow(wid), None);
}
