/* -*-Mode: C; -*- */

/* $Header: /usr4/Src/emu.new/term/sysdep/RCS/process_sysvr3.i,v 1.2 91/08/17 10:16:03 jkh Exp $ */

/*
 * This file is part of the PCS emu system.
 *
 * Copyright 1990 by PCS Computer Systeme, GmbH. Munich, West Germany.
 *
 *                        All Rights Reserved
 *
 * Permission to use, copy, modify, and distribute this software and its 
 * documentation for any purpose and without fee is hereby granted, 
 * provided that the above copyright notice appear in all copies and that
 * both that copyright notice and this permission notice appear in 
 * supporting documentation, and that the names of PCS or the authors not
 * be used in advertising or publicity pertaining to distribution of the
 * software without specific, written prior permission.  
 * 
 * PCS DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE, INCLUDING
 * ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS, IN NO EVENT SHALL
 * PCS, THE AUTHORS, OR THEIR HOUSEPETS BE LIABLE FOR ANY SPECIAL, INDIRECT
 * OR CONSEQUENTIAL DAMAGES OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF
 * USE, DATA OR PROFITS, WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER
 * TORTIOUS ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR PERFORMANCE
 * OF THIS SOFTWARE. SO DON'T SUE US. THANK YOU.
 *
 */

/*
 * Various process manipulation routines specific to V, The System.
 *
 * Author: Jordan K. Hubbard
 * Date: Nov 1st, 1990.
 * Description: Here are some System V specific routines for frobbing the
 *	 	state of of the main process.
 *
 *
 * $Log:	process_sysvr3.i,v $
 * Revision 1.2  91/08/17  10:16:03  jkh
 * General reorganization, changed declarations for TAGS.
 * 
 * Revision 1.1  90/11/05  03:55:20  jkh
 * Initial revision
 * 
 *
 */

/* Set various important environment variables */
Local void sysv_set_environment(w)
TermWidget w;
{
     char envstr[255];
     Widget canvas = CANVAS_W(w);
     Arg args[8];
     int i;
     Dimension lines = 24, columns = 80;
     Import void putenv();

     /*
      * I don't bother to garbage collect these values since they are not
      * going to use much space or be done repetitively.
      */ 

     /* TERM */
     sprintf(envstr, "TERM=%s", w->term.term_type);
     putenv(XtNewString(envstr));
     
     /* Find out lines and columns of canvas so we can set environment */
     i = 0;
     XtSetArg(args[i], XpNlines, &lines);		i++;
     XtSetArg(args[i], XpNcolumns, &columns);		i++;
     XtGetValues(canvas, args, i);
     
     /* LINES */
     sprintf(envstr, "LINES=%d", lines);
     putenv(XtNewString(envstr));

     /* COLUMNS */
     sprintf(envstr, "COLUMNS=%d", columns);
     putenv(XtNewString(envstr));
}
