/* -*-Mode: C; -*- */

#ifndef _PROCESS_MACH_INCLUDE
#define _PROCESS_MACH_INCLUDE

/*
 * This file is part of the PCS emu system.
 *
 * Copyright 1992 by PCS Computer Systeme, GmbH. Munich, West Germany.
 *
 *                        All Rights Reserved
 *
 * Permission to use, copy, modify, and distribute this software and its 
 * documentation for any purpose and without fee is hereby granted, 
 * provided that the above copyright notice appear in all copies and that
 * both that copyright notice and this permission notice appear in 
 * supporting documentation, and that the names of PCS or the authors not
 * be used in advertising or publicity pertaining to distribution of the
 * software without specific, written prior permission.  
 * 
 * PCS DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE, INCLUDING
 * ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS, IN NO EVENT SHALL
 * PCS, THE AUTHORS, OR THEIR HOUSEPETS BE LIABLE FOR ANY SPECIAL, INDIRECT
 * OR CONSEQUENTIAL DAMAGES OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF
 * USE, DATA OR PROFITS, WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER
 * TORTIOUS ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR PERFORMANCE
 * OF THIS SOFTWARE. SO DON'T SUE US. THANK YOU.
 *
 */

/*
 * Process frobbing routines for MACH systems.
 *
 * Author: Jordan K. Hubbard
 * Date: May 16th, 1992.
 * Description: Various routines for frobbing procs on MACH 3.0 systems.
 *
 * Revision History:
 *
 * $Log:	process_mach.i,v $
# Revision 1.1  92/05/16  06:15:13  jkh
# Initial revision
# 
 * 
 */

/* Mandatory */
#ifndef _PROCESS_INCLUDED
#define _PROCESS_INCLUDED
#endif

/* What our system wait() function expects */
#define WAIT_STATUS_TYPE union wait

/* Not defined in our wait.h */
#define WEXITSTATUS(fc) ((fc).w_T.w_Retcode)
#define WSTOPSIG(fc)	((fc).w_T.w_Termsig)

/* Otherwise, we're pretty much BSD */
#include "sysdep/process_bsd.i"

Export int
process_wait(fc)
WAIT_STATUS_TYPE *fc;
{
	return bsd_process_wait(fc);
}

Export void
process_cleanup(w)
TermWidget w;
{
     /* Just remove the utmp entry */
     tty_remove_utmp(w);
}

Export void
process_init(w)
TermWidget w;
{
     /* generic BSD does what we want */
     bsd_process_init(w);
}

#endif	/* _PROCESS_MACH_INCLUDE */
