#ifndef lint
     static char *rcsid = "$Header: /usr4/Src/emu.new/client/RCS/scroll.c,v 1.1 90/09/10 16:22:21 jkh Exp Locker: jkh $";
#endif

/*
 * This file is part of the PCS xterm+ program.
 *
 * Copyright 1990 by PCS Computer Systeme, GmbH. Munich, West Germany.
 *
 *                        All Rights Reserved
 *
 * Permission to use, copy, modify, and distribute this software and its 
 * documentation for any purpose and without fee is hereby granted, 
 * provided that the above copyright notice appear in all copies and that
 * both that copyright notice and this permission notice appear in 
 * supporting documentation, and that the names of PCS or the authors not
 * be used in advertising or publicity pertaining to distribution of the
 * software without specific, written prior permission.  
 * 
 * PCS DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE, INCLUDING
 * ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS, IN NO EVENT SHALL
 * PCS, THE AUTHORS, OR THEIR HOUSEPETS BE LIABLE FOR ANY SPECIAL, INDIRECT
 * OR CONSEQUENTIAL DAMAGES OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF
 * USE, DATA OR PROFITS, WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER
 * TORTIOUS ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR PERFORMANCE
 * OF THIS SOFTWARE. SO DON'T SUE US. THANK YOU.
 *
 */

/*
 *
 * Author: Jordan K. Hubbard
 * Date: August 31th, 1990.
 * Description: This handles all the scrolling schrott for the xterm
 *		client.
 *
 * Revision History:
 *
 * $Log:	scroll.c,v $
 * Revision 1.1  90/09/10  16:22:21  jkh
 * Initial revision
 * 
 *
 */


#include "XTerm+P.h"

#ifdef MOTIF
#include <X11/Xm/ScrollBar.h>
#else
#include <X11/Xaw/Scrollbar.h>
#endif

#ifdef	MOTIF
#else	/* ATHENA */
Export void ScrollProc(w, client_data, pos)
Widget w;
caddr_t client_data;
XtPointer pos;
{
     XtermPlusWidget xw = (XtermPlusWidget)XtParent(w);
     ComBlock *cb = (ComBlock *)XpXtermComBlock(xw);
     int sbh = XpXtermScrollbarHeight(xw);
     float percent;
     Import void dispatch();

     if ((int)client_data != 1 && (int)client_data != 2)
	  fatal("Bad client_data passed to ScrollProc.");
     else {
	  cb_reg_type(cb, 'a') = cb_reg_type(cb, 'b') = CB_INT_TYPE;
	  if ((int)client_data == 1) {		/* scrollProc */
	       percent = (float)(int)pos / (float)sbh;
	       cb_opcode(cb) = OP_SCROLL_SCREEN_RELATIVE;
	       cb_reg_data(cb, 'b') = TRUE;
	  }
	  else {				/* jumpProc */
	       percent = (*((float *)pos));
	       cb_opcode(cb) = OP_SCROLL_SCREEN_ABSOLUTE;
	       cb_reg_data(cb, 'b') = FALSE;
	  }
	  cb_reg_data(cb, 'a') = (Generic)((int)(percent * 1000.0));
	  dispatch(xw, cb);
     }
}

Export void ScrollAdjust(w, pos, size)
XtermPlusWidget w;
float pos, size;
{
     if (w->xterm.scroll)
	  XawScrollbarSetThumb(w->composite.children[w->xterm.scroll], pos,
			       size);
}

#endif

Export void ScrollbarCreate(w)
Widget w;
{
     Arg args[5];
     int nargs;
#ifdef	MOTIF
     nargs = 0;
     XtCreateManagedWidget("vScrollBar", xmScrollBarWidgetClass, w,
			   args, nargs);
#else	/* ATHENA */
     static XtCallbackRec cb[2] = {
	  { (XtCallbackProc)ScrollProc,	(XtPointer)1 },
	  { (XtCallbackProc)NULL,	(XtPointer)NULL },
     },
     cb2[2] = {
	  { (XtCallbackProc)ScrollProc,	(XtPointer)2 },
	  { (XtCallbackProc)NULL,	(XtPointer)NULL },
     };
     Widget scb;

     nargs = 0;
     XtSetArg(args[nargs], XtNscrollProc, cb);		nargs++;
     XtSetArg(args[nargs], XtNjumpProc, cb2);		nargs++;
     scb = XtCreateManagedWidget("vScrollBar", scrollbarWidgetClass, w,
				args, nargs);
     XawScrollbarSetThumb(scb, 0.0, 1.0);
#endif
}
