/* Some modules need to allocate few amounts of memory in the C heap
 * (for example, the symbols from the name list of dynamically
 * loaded .o files, or Alloca() on platforms that do not support
 * a `real' alloca() function.
 */

#include "kernel.h"

extern char *malloc(), *realloc();

char *Safe_Malloc (size) unsigned size; {
    char *ret;
    
    Disable_Interrupts;
    if ((ret = malloc (size)) == 0)
	if (Interpreter_Initialized)
	    Primitive_Error ("not enough memory to malloc ~s bytes",
		Make_Fixnum (size));
	else
	    Fatal_Error ("not enough memory to malloc %u bytes", size);
    Enable_Interrupts;
    return ret;
}

char *Safe_Realloc (ptr, size) char *ptr; unsigned size; {
    char *ret;

    Disable_Interrupts;
    if ((ret = ptr ? realloc (ptr, size) : malloc (size)) == 0)
	if (Interpreter_Initialized)
	    Primitive_Error ("not enough memory to malloc ~s bytes",
		Make_Fixnum (size));
	else
	    Fatal_Error ("not enough memory to malloc %u bytes", size);
    Enable_Interrupts;
    return ret;
}
