/*

Copyright (c),  Digital Equipment Corporation, 1994.
Redistribution and use source and binary forms are permitted
provided that the copyright notice as indicated box below and
this paragraph are duplicated all such forms and that any documentation,
advertising materials, and other materials related to such distribution
and use acknowledge that the software was developed by Digital Equipment
Corporation.  The name of Digital Equipment Corporation may not be used to
endorse or promote products derived from this software without the specific
prior written permission.

All other rights reserved.

THIS SOFTWARE IS PROVIDED ''AS IS'' AND WITHOUT ANY EXPRESS OR IMPLIED
WARRANTIES, INCLUDING, WITHOUT LIMITATION, IMPLIED WARRANTIES OF
NON-INFRINGEMENT, MERCHANTABILITY OR FITNESS FOR A PARTICULAR PURPOSE.
Digital assumes no responsibility AT ALL for the use or reliability
of this software.

+------------------------------------------------------------------------+
| USE, DUPLICATION OR DISCLOSURE BY THE U.S. GOVERNMENT IS SUBJECT TO    |
| RESTRICTIONS AS SET FORTH IN SUBPARAGRAPH (c) (1) (ii) OF              |
| DFARS 252.227-7013, OR IN FAR 52.227-14 ALT. II, AS APPLICABLE.        |
|                                                                        |
+------------------------------------------------------------------------+


    Simple Portable Preprocesor

	by Don Hamson, Digital Equipment Corporation

*/

#define MAXLINE 1024	/* line length for files */

#include <stdio.h>
#include <stdlib.h>
#include <ctype.h>
#include <errno.h>
#include <string.h>

#ifdef VMS
#define errval 0
#include <perror.h>
#else
#define errval 1
void perror (char *string );
extern char *sys_errlist[ ];
extern int sys_nerr;
#endif

typedef char LINE [MAXLINE];
typedef enum {_none, _ifdef, _ifndef, _elseif, _else, _endif} cond;
typedef struct {cond c; char *s; int len; } crec; 

/* io file processing parms */

static	LINE	line;	
static	int	eof = 0;	/* global EOF flag */
static	int	lnum = 0;	/* line number count */
static	int	llen = 0;	/* length of current line */
static  FILE	*ifp=0;		/* input file */
static	FILE	*ofp=0;		/* output file */

/* Stack for nested conditionals */

#define	STK	64		/* stack size */
static int curstk[STK];		/* stack for curout */
static int *cursp = &curstk[0];	/* ptr into curstk */
static int evrstk[STK];		/* stack for evrout */
static int *evrsp = &evrstk[0];	/* ptr into evrstk */

/* Note: stacks are separate for anded sum taken below */

/* Conditionals */

#define ctblim sizeof(ctb)/sizeof(crec)
static crec ctb[] = {
	    _none,	"",	    0,
	    _ifdef,	"#ifdef",   6,
	    _ifndef,	"#ifndef",  7,
	    _elseif,	"#elseif",  7,
	    _else,	"#else",    5,
	    _endif,	"#endif",   6	 };

/* defined symbols table */

#define SYM	64	/* max number of defines */
char    *sym[SYM];	/* table -> argv entries prefixed by "-D" */
static	int syms = 0;	/* last entry index */

/* prototypes */

cond	getcond(char **s);
int	getline();
void	push(int, int **, int *);    /* push operation */
int	pop(int **, int *);	     /* pop operation */
void	errxit(char *s);
int 	find (char *s);
  
main (int argc, char *argv[])
{
    int	    i, *ip;
    char    *name, *p;
    int	    out = 1;	    /* controls put line */
    int	    curout = 1;	    /* state of current if clause */
    int	    evrout = 0;	    /* marks if any if in this clause was true */

    if (argc < 1) 
	errxit ("Usage: spp -d<name> [-d<name>...] <input> <output>\n");

    /* Process Input Args */

    for (i=1; i<argc; i++) {

	/* Accumulate Command Line Definitions */
	if ((strncmp(argv[i],"-D",2)==0) || 
	    (strncmp(argv[i],"-d",2)==0)) {
	    if (syms <= SYM-1)
		for (p=argv[i]+2; *p!='\0'; p++) *p=toupper(*p);
		sym[syms++] = (argv[i] + 2);
	    continue;
	    }

	/* Input Output Files */
	if (!ifp)
	    if ((ifp = fopen(argv[i], "r")) == NULL) {
		perror ("spp"); 
		errxit ("spp: input file open error.\n");
		}
	    else continue;

	if (!ofp)
	    if ((ofp = fopen(argv[i], "w")) == NULL) {
		perror ("spp");
		errxit ("spp: output file open error.\n");
		}
            else continue;
        } /* end for */
        
    if (!ifp) ifp = stdin;
    if (!ofp) ofp = stdout;

    /* Filter input according to conditionals */
    while (getline() != 0) {

	if (line[0] == '#') {
	    switch (getcond(&name)) {
		case _ifdef:
		    push(evrout, &evrsp, &evrstk[STK-1]);
		    push(curout, &cursp, &curstk[STK-1]);
		    curout = find(name);
		    evrout = curout ? 1 : 0;
		    break;
		case _ifndef:
		    push(evrout, &evrsp, &evrstk[STK-1]);
		    push(curout, &cursp, &curstk[STK-1]);
		    curout = !find(name);
		    evrout = curout ? 1 : 0;
		    break;
		case _elseif:
		    curout = !evrout & find(name);
		    if (curout) evrout = 1;
		    break;
		case _else:
		    curout = !(curout || evrout);
		    if (curout) evrout = 1;
		    break;
		case _endif:
		    curout = pop(&cursp, &curstk[0]);
		    evrout = pop(&evrsp, &evrstk[0]);
		    break;
		case _none:
		    goto lineout;
		}

	    /* AND on-state with previous curout states */
	    out = 1;
	    for (ip = &curstk[0]; ip < cursp; ip++) out = out && *ip;
	    out = out && curout;
	    continue;
	    }

lineout:
	if (out) fputs(line, ofp);
	if (eof == EOF) break;
	}       
  
    fclose(ifp);
    fclose(ofp);
    }

/*=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=*/
/* getcond - return conditional and name */
cond getcond (char **t2)
{
    char    *p;
    int	    i;
    cond    cnd;

    /* Recognize first token */
    for (i=1; i<ctblim; i++)
	if (!strncmp(&line[0],ctb[i].s,ctb[i].len)) {
	    cnd = ctb[i].c;
	    goto resume;
	    }
    return _none;

resume:
    /* whitespace between tokens */
    p = &line[ctb[i].len];
    while (isspace(*p)) p++;

    /* Get 2nd token (null is ok) */
    if (isalnum(*p)) {
	*t2 = p;
	while (p <= &line[llen])
	    if (isalnum(*p) || (*p == '_')) {
		*p = toupper(*p);
		p++;
		}
	    else if (isspace(*p) || (*p == '\0')) 
		break;
	    else 
		errxit ("spp: conditional error, use: alnum and _.");

	*p = '\0';
	}
    else *t2 = 0; 

    return cnd;
    }

/* find name in symtbl table */
int find (char *s)
{
    int i;
    if (!s) errxit ("spp: symbol missing");

    for (i=0; i<syms; i++)
	if (!strcmp(sym[i],s)) return 1; /* found it */
    return 0;
    }

/* Stack Routines */
void push (int i, int **sp, int *lim)
{
    **sp = i;
    if (*sp < lim) (*sp)++;
    else errxit ("spp: stack overflow error");
    }

int pop(int **sp, int *lim)
{
    if (*sp > lim) {
	(*sp)--;
	return **sp;
	}
    else errxit ("spp: stack underflow error");
    }

/* IO Routines */

/* get a line, set llen and eof */              
int getline ()
{
    if (fgets (line, MAXLINE, ifp) != 0) { 
	lnum++;
	return llen = strlen(line);
	}
    else {
	eof = 1;
	line[0] = '\0';
	return 0;
	}
    }

void errxit (char *s)
{
    if (s != 0) printf ("%s",s);

    if (lnum>0) {
	printf (", line %d.\n", lnum);
	printf ("%s", line);
	}

    exit (errval);
    }
