$! This DCL Script does:
$! 1. Asks the user what kind of system and X11/Motif code they want to produce
$! 2. Creates the spp and c2a .exe's needed to preprocess the code.
$! 3. Converts the .PIAs to .ADAs
$! 4. Converts the .PIC2As to .ADAs
$!
$! This script must run from the [...outbound.tools] directory, and it will
$! place the results in the [...outbound.built] directory.
$!
$! This script can take a WHILE to run, there is a lot of code that
$! needs to be translated.
$! 
$! for config V5, you must link in the .c file
$!
$ Back1:
$    inquire SYS_Type "VAX/VMS [Enter V] or Alpha AXP VMS [Enter A]"
$    if SYS_Type .nes. "A" .and. SYS_Type .nes. "V" then goto Back1
$    if SYS_Type .eqs. "A"
$    then
$        Sys_Options = "-dAXP -dVMS"
$    else
$        Sys_Options = "-dVAX -dVMS"
$    endif
$ Back2:
$    inquire X_Type "X11R4/Motif 1.1 [Enter 4] or X11R5/Motif 1.2 [Enter 5]"
$    if X_Type .nes. "4" .and. X_Type .nes. "5" then goto Back2
$    if X_Type .eqs. "4"
$    then
$        X_Options = ""
$    else
$        X_Options = "-dX11R5 -dMOTIF12"
$    endif
$!
$! ST's possible combo's are V4, V5, A4, A5
$! V4 = VAX X11R4/Motif1.1
$! A4 = AXP X11R4/Motif1.1
$! V5 = VAX X11R5/Motif1.2
$! A5 = AXP X11R5/Motif1.2
$!
$    ST = SYS_Type + X_Type
$!
$! copy all the files to the build area
$!
$    create/dir [-.built]
$    set def [-.built]
$    copy [-.tools]*.c []
$    copy [-.src]*.ada []
$    copy [-.src]*.pic2a []
$    copy [-.src]*.pia []
$    copy [-.tools]*.opt []
$!
$!
$! Building C2A and SPP
$!
$    cc c2a.c
$    link c2a.obj,sys$input/opt
     sys$library:vaxcrtl.olb/lib
$    delete c2a.obj;*
$    cc spp.c
$    link spp.obj,sys$input/opt
     sys$library:vaxcrtl.olb/lib
$    delete spp.obj;*
$!
$! Make sure it can find the exe's
$!
$    new_common = f$logical("sys$common")
$    define sys$common 'new_common,[]
$    c2a = "$[]c2a.exe"
$    spp = "$[]spp.exe"
$!
$! Convert all the pia's to .ada
$!
$    num = 0
$    all_pia_names = "c_types_,x_lib,x_resource,xm,xm_convenience,xm_widget,xt"
$ do_pia:
$    name = f$element (num, ",", all_pia_names)
$    if name .eqs. "," then goto done_pia
$    num = num + 1
$    spp 'Sys_Options' 'X_Options' 'name'.pia 'name'.ada
$    goto do_pia
$ done_pia:
$!
$! Convert all the pic2a's to .a
$!
$    num = 0
$    all_pic2a_names = "wstring_,x_,x_atom_,x_lib_,x_lib_support_,x_resource_,x_string_,xm_,xm_convenience_,xm_string_,xm_widget_,xt_"
$ do_pic2a:
$    name = f$element (num, ",", all_pic2a_names)
$    num = num + 1
$    if name .eqs. "," then goto done_pic2a
$    spp 'Sys_Options' 'X_Options' 'name'.pic2a 'name'.c2a
$    c2a 'name'.c2a 'name'.c
$    cc/noopt 'name'.c
$!
$! Link the .C file
$!
$    if ST .eqs. "V4"
$    then
$        link 'name'.obj,sys$input/opt
             sys$library:vaxcrtl.olb/lib
             sys$library:decw$xlibshr.exe/share
             sys$library:decw$xtshr.exe/share
             sys$library:decw$xmlibshr.exe/share
$        goto done_link
$    endif
$    if ST .eqs. "V5"
$    then
$        link 'name'.obj,sys$input/opt
             sys$library:vaxcrtl.olb/lib
             sys$library:decw$xlibshr.exe/share
             sys$library:decw$xtlibshrr5.exe/share
             sys$library:decw$xmlibshr12.exe/share
             sys$library:decw$mrmlibshr12.exe/share
             sys$library:decw$dxmlibshr12.exe/share
$        goto done_link
$    endif
$    if ST .eqs. "A4"
$    then
$        link 'name'.obj,sys$input/opt
             sys$library:decw$xlibshr.exe/share
             sys$library:decw$xtshr.exe/share
             sys$library:decw$xmlibshr.exe/share
$        goto done_link
$    endif
$
$!
$! Must be A5
$!
$    link 'name'.obj,sys$input/opt
         sys$library:decw$xlibshr.exe/share
         sys$library:decw$xtlibshrr5.exe/share
         sys$library:decw$xmlibshr12.exe/share
         sys$library:decw$mrmlibshr12.exe/share
         sys$library:decw$dxmlibshr12.exe/share
$ done_link:
$!
$! Use the output of the .C file to create the .ADA file
$! Clean up the remaining files that are no longer needed.
$!
$    define/user sys$output 'name'.ada
$    run 'name'.exe
$    delete 'name'.exe;*
$    delete 'name'.c;*
$    delete 'name'.obj;*
$    delete 'name'.c2a;*
$    goto do_pic2a
$ done_pic2a:
$!
$! Put the old sys$common back the way it was.
$!
$    deassign sys$common
$    delete *.pic2a;*
$    delete *.pia;*
$    delete *.opt;*
$    delete *.exe;*
$    delete c2a.c;*
$    delete spp.c;*
$
$    delete c_types*.*;*
$    
$    if ST .eqs. "A4" .or. ST .eqs. "V4"
$    then 
$        delete wstring*.ada;*
$        delete x_string*.ada;*
$    endif
$!
$! The next lines can be used to:
$! 1. Create the Library
$! 2. Load all the units
$! 3. Compile all the packages
$!
$!   acs create lib [.adalib]
$!   acs set lib [.adalib]
$!   acs load *.ada
$!   acs compile *
$!

