#!/bin/csh
# This script converts all the .pia and .pic2a to .ada files.
#
# Find out the architecture
#
if (-f /bin/uname) then
    set arche = `/bin/uname -a | cut -f1 -d" "`
else
    set arche = `/bin/arch`
endif

#
#
if ($arche == "ULTRIX") then
    set MACHINE_OPTIONS = "-dULTRIX"
else
    if ($arche == "OSF1") then
        set MACHINE_OPTIONS = "-dosf -daxp"
    else
        set MACHINE_OPTIONS = ""
    endif
endif

#
# Check the existence of a Motif 1.2 include file
#
if (-f /usr/include/Xm/DragDrop.h) then
    set X_OPTIONS = "-dMOTIF12 -dX11R5"
else
    set X_OPTIONS = ""
endif

#
# Compile SPP and C2A for pre-processing 
#
cc -D$arche -O -o  c2a c2a.c
cc -O -o spp spp.c

#
# Convert .pia and .pic2a files into a pure ada .ada files.
#
foreach i (*.pia)
        set name1 = $i:t
        set name = $name1:r
        spp $MACHINE_OPTIONS $X_OPTIONS $name.pia $name.ada
end
#
foreach i (*.pic2a)
        set name1 = $i:t
        set name = $name1:r
        spp $MACHINE_OPTIONS $X_OPTIONS $i $name.c2a
        c2a $name.c2a $name.c
        if (-f /usr/include/DXm/DXmSvn.h) then
# migrate removed
            cc -lXm -lXt -lX11 -lMrm -lDXm -O0 -o $name $name.c
        else
            cc -lXm -lXt -lX11 -lMrm -O0 -o $name $name.c
        endif
        $name > $name.ada
        rm -f $name $name.c $name.c2a
end

