#!/bin/csh
#
# Find out the architecture
if (-f /bin/uname) then
    set arche = `/bin/uname -a | cut -f1 -d" "`
else
    set arche = `/bin/arch`
endif
#
# create directory and copy all the examples .ada files into it.
#
cd ..
mkdir built_examples
cd built_examples
ln -s ../examples/others/*.ada .

#set up the library to use the already built X stuff.
#
setenv ADALIB @adalib
amklib -p @../built/adalib adalib

# need to build this before building the examples
#
amake integer_text_io

# build all the examples
#
foreach i (*.ada)
        ada $i
	set name = $i:r
	amake -o $name $name -lXm -lXt -lX11 -lMrm 
end

# make xlib_rubik
#
ln -s ../examples/xlib_rubik/*.ada .

#compile and make xlib_rubik example
ada -y xlib_rubik*.ada
amake -o xlib_rubik xlib_rubik -lXm -lXt -lX11 -lMrm

# make xm_burger
#
ln -s ../examples/xm_burger/*.ada .
ln -s ../examples/xm_burger/xm_burger.uil .

#compile and make xm_burger example
uil xm_burger.uil -o xm_burger.uid
ada -y xm_burger*.ada
amake -o xm_burger xm_burger -lXm -lXt -lX11 -lMrm

# make fctm
#
ln -s ../examples/fctm/* .
if ($arche == "ULTRIX") then
    ln -s ../examples/fctm/ultrix/* .
else
    ln -s ../examples/fctm/osf/* .
endif
rm osf ultrix vms

ada -v -y fctm*.ada
amake -v fctm
if ($arche == "OSF1") then
   cc -c fctm_osf1_ethernet_io_implementation.c
   ald -S0 -o fctm fctm -lX11 -a \
       'fctm_osf1_ethernet_io_implementation.o -ldnet_stub'
   rm fctm_osf1_ethernet_io_implementation.o
else
   ald -o fctm fctm -lX11
endif
