$! This DCL Script does:
$! 1. Asks the user what kind of system and X11/Motif code they want to produce
$! 2. Sets up the proper foreign body
$! 3. Compiles everything
$!
$! for config V5, you must link in the .c file
$!
$ Back1:
$    inquire SYS_Type "VAX/VMS [Enter V] or Alpha AXP VMS [Enter A]"
$    if SYS_Type .nes. "A" .and. SYS_Type .nes. "V" then goto Back1
$    if SYS_Type .eqs. "A"
$    then
$        Sys_Options = "-dAXP -dVMS"
$    else
$        Sys_Options = "-dVAX -dVMS"
$    endif
$ Back2:
$    inquire X_Type "X11R4/Motif 1.1 [Enter 4] or X11R5/Motif 1.2 [Enter 5]"
$    if X_Type .nes. "4" .and. X_Type .nes. "5" then goto Back2
$    if X_Type .eqs. "4"
$    then
$        X_Options = ""
$    else
$        X_Options = "-dX11R5 -dMOTIF12"
$    endif
$!
$! ST's possible combo's are V4, V5, A4, A5
$! V4 = VAX X11R4/Motif1.1
$! A4 = AXP X11R4/Motif1.1
$! V5 = VAX X11R5/Motif1.2
$! A5 = AXP X11R5/Motif1.2
$!
$    ST = SYS_Type + X_Type
$!
$! Must create the lib and load everything before entering a foreign body
$!
$   acs create lib [.adalib]
$   acs set lib [.adalib]
$   acs load *.ada
$   acs compile x_foreign_bodies
$!
$! Sets up the foriegn body
$!
$    if ST .eqs. "A4" 
$    then
$        acs enter foreign/replace xopt_a4.opt x_foreign_bodies
$    endif
$    if ST .eqs. "V4" 
$    then
$        acs enter foreign/replace xopt_v4.opt x_foreign_bodies
$    endif
$    if ST .eqs. "A5" 
$    then
         acs enter foreign/replace xopt_a5.opt x_foreign_bodies
$    endif
$    if ST .eqs. "V5" 
$    then
$        cc/noopt x_lib_vax_supplement.c
$        acs enter foreign/replace xopt_v5.opt x_foreign_bodies
$    endif
$!
$! Creates the lib and Compiles everything
$!
$   acs compile *
$!

