pragma TITLE ("XT_STRING", "Resource name string constants");

-- Copyright (c),  Digital Equipment Corporation, 1992, 1993, 1994.
-- Redistribution and use in source and binary forms are permitted
-- provided that the copyright notice as indicated in box below and
-- this paragraph are duplicated in all such forms and that any documentation,
-- advertising materials, and other materials related to such distribution
-- and use acknowledge that the software was developed by Digital Equipment
-- Corporation.  The name of Digital Equipment Corporation may not be used to
-- endorse or promote products derived from this software without the specific
-- prior written permission.
--
-- All other rights reserved.
--
-- THIS SOFTWARE IS PROVIDED ''AS IS'' AND WITHOUT ANY EXPRESS OR IMPLIED
-- WARRANTIES, INCLUDING, WITHOUT LIMITATION, IMPLIED WARRANTIES OF
-- NON-INFRINGEMENT, MERCHANTABILITY OR FITNESS FOR A PARTICULAR PURPOSE.
-- Digital assumes no responsibility AT ALL for the use or reliability
-- of this software.
--
-- +------------------------------------------------------------------------+
-- | USE, DUPLICATION OR DISCLOSURE BY THE U.S. GOVERNMENT IS SUBJECT TO    |
-- | RESTRICTIONS AS SET FORTH IN SUBPARAGRAPH (c) (1) (ii) OF              |
-- | DFARS 252.227-7013, OR IN FAR 52.227-14 ALT. II, AS APPLICABLE.	    |
-- |									    |
-- +------------------------------------------------------------------------+
--
-- A great deal has been published concerning graphic bindings, 
-- including, for example: 
--
--			Implementation of the Core Graphics System GKS
--			in a Distributed Graphics Environment
--			Proc. Int. Conf. Interactive Techniques in CAD,
--			Bologna (1978), 249-254.
--
--			Constructing User Interfaces based on Logical
--			Input Devices.
--			IEEE, Computers (Nov 82), 62-68.
--
--			GKS in C.
--			Proc. Eurographics '82, 
--			North-Holland (1982) 359-370.
--
--			Computer Graphics Programming
--			G. Enderle, K. Kansy, G. Pfaff
--			Springer-Verlag
--			Berlin, Heidelberg, New York
--			1984
--
-- *******************************************************************
--
-- These string constants are used in two ways, either as
--	1) the strings themselves
--	2) pointers to these strings
--
-- To accommodate both usages, two sets of constants are provided:
--	1) the strings themselves, with names "NAME".
--	2) pointers to these strings, with names "NAME_PTR".
--
with C_TYPES;
use C_TYPES;

package XT_STRING is

    DEFAULT_FOREGROUND           : constant C_TYPES.NULL_TERMINATED.STRING := 
	( 88,116, 68,101,102, 97,117,108,116, 70,111,114,101,103,114,111,
	 117,110,100,  0);
  
            DEFAULT_FOREGROUND_PTR : constant C_TYPES.CHAR_POINTER :=
                  C_TYPES.TO_CHAR_POINTER(DEFAULT_FOREGROUND'ADDRESS);

    DEFAULT_BACKGROUND           : constant C_TYPES.NULL_TERMINATED.STRING := 
	( 88,116, 68,101,102, 97,117,108,116, 66, 97, 99,107,103,114,111,
	 117,110,100,  0);
  
            DEFAULT_BACKGROUND_PTR : constant C_TYPES.CHAR_POINTER :=
                  C_TYPES.TO_CHAR_POINTER(DEFAULT_BACKGROUND'ADDRESS);

    DEFAULT_FONT                 : constant C_TYPES.NULL_TERMINATED.STRING := 
	( 88,116, 68,101,102, 97,117,108,116, 70,111,110,116,  0);
  
            DEFAULT_FONT_PTR : constant C_TYPES.CHAR_POINTER :=
                  C_TYPES.TO_CHAR_POINTER(DEFAULT_FONT'ADDRESS);


    NICON_NAME                   : constant C_TYPES.NULL_TERMINATED.STRING := 
	(105, 99,111,110, 78, 97,109,101,  0);
      NICON_NAME_PTR : constant C_TYPES.CHAR_POINTER :=
                  C_TYPES.TO_CHAR_POINTER(NICON_NAME'ADDRESS);

    C_ICON_NAME                   : constant C_TYPES.NULL_TERMINATED.STRING := 
	( 73, 99,111,110, 78, 97,109,101,  0);
      C_ICON_NAME_PTR : constant C_TYPES.CHAR_POINTER :=
                  C_TYPES.TO_CHAR_POINTER(C_ICON_NAME'ADDRESS);

    NICON_PIXMAP                 : constant C_TYPES.NULL_TERMINATED.STRING := 
	(105, 99,111,110,112,105,120,109, 97,112,  0);
  
            NICON_PIXMAP_PTR : constant C_TYPES.CHAR_POINTER :=
                  C_TYPES.TO_CHAR_POINTER(NICON_PIXMAP'ADDRESS);

    C_ICON_PIXMAP                 : constant C_TYPES.NULL_TERMINATED.STRING := 
	( 73, 99,111,110,112,105,120,109, 97,112,  0);
  
            C_ICON_PIXMAP_PTR : constant C_TYPES.CHAR_POINTER :=
                  C_TYPES.TO_CHAR_POINTER(C_ICON_PIXMAP'ADDRESS);

    NICON_WINDOW                 : constant C_TYPES.NULL_TERMINATED.STRING := 
	(105, 99,111,110, 87,105,110,100,111,119,  0);
  
            NICON_WINDOW_PTR : constant C_TYPES.CHAR_POINTER :=
                  C_TYPES.TO_CHAR_POINTER(NICON_WINDOW'ADDRESS);

    C_ICON_WINDOW                 : constant C_TYPES.NULL_TERMINATED.STRING := 
	( 73, 99,111,110, 87,105,110,100,111,119,  0);
  
            C_ICON_WINDOW_PTR : constant C_TYPES.CHAR_POINTER :=
                  C_TYPES.TO_CHAR_POINTER(C_ICON_WINDOW'ADDRESS);

    NICON_MASK                   : constant C_TYPES.NULL_TERMINATED.STRING := 
	(105, 99,111,110, 77, 97,115,107,  0);
      NICON_MASK_PTR : constant C_TYPES.CHAR_POINTER :=
                  C_TYPES.TO_CHAR_POINTER(NICON_MASK'ADDRESS);

    C_ICON_MASK                   : constant C_TYPES.NULL_TERMINATED.STRING := 
	( 73, 99,111,110, 77, 97,115,107,  0);
      C_ICON_MASK_PTR : constant C_TYPES.CHAR_POINTER :=
                  C_TYPES.TO_CHAR_POINTER(C_ICON_MASK'ADDRESS);

    NWINDOW_GROUP                : constant C_TYPES.NULL_TERMINATED.STRING := 
	(119,105,110,100,111,119, 71,114,111,117,112,  0);
  
            NWINDOW_GROUP_PTR : constant C_TYPES.CHAR_POINTER :=
                  C_TYPES.TO_CHAR_POINTER(NWINDOW_GROUP'ADDRESS);

    C_WINDOW_GROUP                : constant C_TYPES.NULL_TERMINATED.STRING := 
	( 87,105,110,100,111,119, 71,114,111,117,112,  0);
  
            C_WINDOW_GROUP_PTR : constant C_TYPES.CHAR_POINTER :=
                  C_TYPES.TO_CHAR_POINTER(C_WINDOW_GROUP'ADDRESS);

    NVISUAL                     : constant C_TYPES.NULL_TERMINATED.STRING := 
	(118,105,115,117, 97,108,  0);
      NVISUAL_PTR : constant C_TYPES.CHAR_POINTER :=
                  C_TYPES.TO_CHAR_POINTER(NVISUAL'ADDRESS);

    C_VISUAL                     : constant C_TYPES.NULL_TERMINATED.STRING := 
	( 86,105,115,117, 97,108,  0);
      C_VISUAL_PTR : constant C_TYPES.CHAR_POINTER :=
                  C_TYPES.TO_CHAR_POINTER(C_VISUAL'ADDRESS);

    NTITLE_ENCODING              : constant C_TYPES.NULL_TERMINATED.STRING := 
	(116,105,116,108,101, 69,110, 99,111,100,105,110,103,  0);
  
            NTITLE_ENCODING_PTR : constant C_TYPES.CHAR_POINTER :=
                  C_TYPES.TO_CHAR_POINTER(NTITLE_ENCODING'ADDRESS);

    C_TITLE_ENCODING              : constant C_TYPES.NULL_TERMINATED.STRING := 
	( 84,105,116,108,101, 69,110, 99,111,100,105,110,103,  0);
  
            C_TITLE_ENCODING_PTR : constant C_TYPES.CHAR_POINTER :=
                  C_TYPES.TO_CHAR_POINTER(C_TITLE_ENCODING'ADDRESS);

    NSAVE_UNDER                  : constant C_TYPES.NULL_TERMINATED.STRING := 
	(115, 97,118,101, 85,110,100,101,114,  0);
      NSAVE_UNDER_PTR : constant C_TYPES.CHAR_POINTER :=
                  C_TYPES.TO_CHAR_POINTER(NSAVE_UNDER'ADDRESS);

    C_SAVE_UNDER                  : constant C_TYPES.NULL_TERMINATED.STRING := 
	( 83, 97,118,101, 85,110,100,101,114,  0);
      C_SAVE_UNDER_PTR : constant C_TYPES.CHAR_POINTER :=
                  C_TYPES.TO_CHAR_POINTER(C_SAVE_UNDER'ADDRESS);

    NTRANSIENT                  : constant C_TYPES.NULL_TERMINATED.STRING := 
	(116,114, 97,110,115,105,101,110,116,  0);
      NTRANSIENT_PTR : constant C_TYPES.CHAR_POINTER :=
                  C_TYPES.TO_CHAR_POINTER(NTRANSIENT'ADDRESS);

    C_TRANSIENT                  : constant C_TYPES.NULL_TERMINATED.STRING := 
	( 84,114, 97,110,115,105,101,110,116,  0);
      C_TRANSIENT_PTR : constant C_TYPES.CHAR_POINTER :=
                  C_TYPES.TO_CHAR_POINTER(C_TRANSIENT'ADDRESS);

    NOVERRIDE_REDIRECT           : constant C_TYPES.NULL_TERMINATED.STRING := 
	(111,118,101,114,114,105,100,101, 82,101,100,105,114,101, 99,116,
	   0);
  
            NOVERRIDE_REDIRECT_PTR : constant C_TYPES.CHAR_POINTER :=
                  C_TYPES.TO_CHAR_POINTER(NOVERRIDE_REDIRECT'ADDRESS);

    C_OVERRIDE_REDIRECT           : constant C_TYPES.NULL_TERMINATED.STRING := 
	( 79,118,101,114,114,105,100,101, 82,101,100,105,114,101, 99,116,
	   0);
  
            C_OVERRIDE_REDIRECT_PTR : constant C_TYPES.CHAR_POINTER :=
                  C_TYPES.TO_CHAR_POINTER(C_OVERRIDE_REDIRECT'ADDRESS);

    NTRANSIENT_FOR               : constant C_TYPES.NULL_TERMINATED.STRING := 
	(116,114, 97,110,115,105,101,110,116, 70,111,114,  0);
  
            NTRANSIENT_FOR_PTR : constant C_TYPES.CHAR_POINTER :=
                  C_TYPES.TO_CHAR_POINTER(NTRANSIENT_FOR'ADDRESS);

    C_TRANSIENT_FOR               : constant C_TYPES.NULL_TERMINATED.STRING := 
	( 84,114, 97,110,115,105,101,110,116, 70,111,114,  0);
  
            C_TRANSIENT_FOR_PTR : constant C_TYPES.CHAR_POINTER :=
                  C_TYPES.TO_CHAR_POINTER(C_TRANSIENT_FOR'ADDRESS);

    NICON_NAME_ENCODING           : constant C_TYPES.NULL_TERMINATED.STRING := 
	(105, 99,111,110, 78, 97,109,101, 69,110, 99,111,100,105,110,103,
	   0);
  
            NICON_NAME_ENCODING_PTR : constant C_TYPES.CHAR_POINTER :=
                  C_TYPES.TO_CHAR_POINTER(NICON_NAME_ENCODING'ADDRESS);

    C_ICON_NAME_ENCODING           : constant C_TYPES.NULL_TERMINATED.STRING := 
	( 73, 99,111,110, 78, 97,109,101, 69,110, 99,111,100,105,110,103,
	   0);
  
            C_ICON_NAME_ENCODING_PTR : constant C_TYPES.CHAR_POINTER :=
                  C_TYPES.TO_CHAR_POINTER(C_ICON_NAME_ENCODING'ADDRESS);

    NALLOW_SHELL_RESIZE           : constant C_TYPES.NULL_TERMINATED.STRING := 
	( 97,108,108,111,119, 83,104,101,108,108, 82,101,115,105,122,101,
	   0);
  
            NALLOW_SHELL_RESIZE_PTR : constant C_TYPES.CHAR_POINTER :=
                  C_TYPES.TO_CHAR_POINTER(NALLOW_SHELL_RESIZE'ADDRESS);

    C_ALLOW_SHELL_RESIZE           : constant C_TYPES.NULL_TERMINATED.STRING := 
	( 65,108,108,111,119, 83,104,101,108,108, 82,101,115,105,122,101,
	   0);
  
            C_ALLOW_SHELL_RESIZE_PTR : constant C_TYPES.CHAR_POINTER :=
                  C_TYPES.TO_CHAR_POINTER(C_ALLOW_SHELL_RESIZE'ADDRESS);

    NCREATE_POPUP_CHILD_PROC       : constant C_TYPES.NULL_TERMINATED.STRING := 
	( 99,114,101, 97,116,101, 80,111,112,117,112, 67,104,105,108,100,
	  80,114,111, 99,  0);

             NCREATE_POPUP_CHILD_PROC_PTR : constant C_TYPES.CHAR_POINTER :=
                  C_TYPES.TO_CHAR_POINTER(NCREATE_POPUP_CHILD_PROC'ADDRESS);

    C_CREATE_POPUP_CHILD_PROC       : constant C_TYPES.NULL_TERMINATED.STRING := 
	( 67,114,101, 97,116,101, 80,111,112,117,112, 67,104,105,108,100,
	  80,114,111, 99,  0);

             C_CREATE_POPUP_CHILD_PROC_PTR : constant C_TYPES.CHAR_POINTER :=
                  C_TYPES.TO_CHAR_POINTER(C_CREATE_POPUP_CHILD_PROC'ADDRESS);

    NTITLE                      : constant C_TYPES.NULL_TERMINATED.STRING := 
	(116,105,116,108,101,  0);
      NTITLE_PTR : constant C_TYPES.CHAR_POINTER :=
                  C_TYPES.TO_CHAR_POINTER(NTITLE'ADDRESS);

    C_TITLE                      : constant C_TYPES.NULL_TERMINATED.STRING := 
	( 84,105,116,108,101,  0);
      C_TITLE_PTR : constant C_TYPES.CHAR_POINTER :=
                  C_TYPES.TO_CHAR_POINTER(C_TITLE'ADDRESS);

    R_ATOM                       : constant C_TYPES.NULL_TERMINATED.STRING := 
	( 65,116,111,109,  0);
      R_ATOM_PTR : constant C_TYPES.CHAR_POINTER :=
                  C_TYPES.TO_CHAR_POINTER(R_ATOM'ADDRESS);

    NARGC                       : constant C_TYPES.NULL_TERMINATED.STRING := 
	( 97,114,103, 99,  0);
      NARGC_PTR : constant C_TYPES.CHAR_POINTER :=
                  C_TYPES.TO_CHAR_POINTER(NARGC'ADDRESS);

    C_ARGC                       : constant C_TYPES.NULL_TERMINATED.STRING := 
	( 65,114,103, 99,  0);
      C_ARGC_PTR : constant C_TYPES.CHAR_POINTER :=
                  C_TYPES.TO_CHAR_POINTER(C_ARGC'ADDRESS);

    NARGV                       : constant C_TYPES.NULL_TERMINATED.STRING := 
	( 97,114,103,118,  0);
      NARGV_PTR : constant C_TYPES.CHAR_POINTER :=
                  C_TYPES.TO_CHAR_POINTER(NARGV'ADDRESS);

    C_ARGV                       : constant C_TYPES.NULL_TERMINATED.STRING := 
	( 65,114,103,118,  0);
      C_ARGV_PTR : constant C_TYPES.CHAR_POINTER :=
                  C_TYPES.TO_CHAR_POINTER(C_ARGV'ADDRESS);

    NICON_X                      : constant C_TYPES.NULL_TERMINATED.STRING := 
	(105, 99,111,110, 88,  0);
      NICON_X_PTR : constant C_TYPES.CHAR_POINTER :=
                  C_TYPES.TO_CHAR_POINTER(NICON_X'ADDRESS);

    C_ICON_X                      : constant C_TYPES.NULL_TERMINATED.STRING := 
	( 73, 99,111,110, 88,  0);
      C_ICON_X_PTR : constant C_TYPES.CHAR_POINTER :=
                  C_TYPES.TO_CHAR_POINTER(C_ICON_X'ADDRESS);

    NICON_Y                      : constant C_TYPES.NULL_TERMINATED.STRING := 
	(105, 99,111,110, 89,  0);
      NICON_Y_PTR : constant C_TYPES.CHAR_POINTER :=
                  C_TYPES.TO_CHAR_POINTER(NICON_Y'ADDRESS);

    C_ICON_Y                      : constant C_TYPES.NULL_TERMINATED.STRING := 
	( 73, 99,111,110, 89,  0);
      C_ICON_Y_PTR : constant C_TYPES.CHAR_POINTER :=
                  C_TYPES.TO_CHAR_POINTER(C_ICON_Y'ADDRESS);

    NINPUT                      : constant C_TYPES.NULL_TERMINATED.STRING := 
	(105,110,112,117,116,  0);
      NINPUT_PTR : constant C_TYPES.CHAR_POINTER :=
                  C_TYPES.TO_CHAR_POINTER(NINPUT'ADDRESS);

    C_INPUT                      : constant C_TYPES.NULL_TERMINATED.STRING := 
	( 73,110,112,117,116,  0);
      C_INPUT_PTR : constant C_TYPES.CHAR_POINTER :=
                  C_TYPES.TO_CHAR_POINTER(C_INPUT'ADDRESS);

    NICONIC                     : constant C_TYPES.NULL_TERMINATED.STRING := 
	(105, 99,111,110,105, 99,  0);
      NICONIC_PTR : constant C_TYPES.CHAR_POINTER :=
                  C_TYPES.TO_CHAR_POINTER(NICONIC'ADDRESS);

    C_ICONIC                     : constant C_TYPES.NULL_TERMINATED.STRING := 
	( 73, 99,111,110,105, 99,  0);
      C_ICONIC_PTR : constant C_TYPES.CHAR_POINTER :=
                  C_TYPES.TO_CHAR_POINTER(C_ICONIC'ADDRESS);

    NINITIAL_STATE               : constant C_TYPES.NULL_TERMINATED.STRING := 
	(105,110,105,116,105, 97,108, 83,116, 97,116,101,  0);
  
            NINITIAL_STATE_PTR : constant C_TYPES.CHAR_POINTER :=
                  C_TYPES.TO_CHAR_POINTER(NINITIAL_STATE'ADDRESS);

    C_INITIAL_STATE               : constant C_TYPES.NULL_TERMINATED.STRING := 
	( 73,110,105,116,105, 97,108, 83,116, 97,116,101,  0);
  
            C_INITIAL_STATE_PTR : constant C_TYPES.CHAR_POINTER :=
                  C_TYPES.TO_CHAR_POINTER(C_INITIAL_STATE'ADDRESS);

    NGEOMETRY                   : constant C_TYPES.NULL_TERMINATED.STRING := 
	(103,101,111,109,101,116,114,121,  0);
      NGEOMETRY_PTR : constant C_TYPES.CHAR_POINTER :=
                  C_TYPES.TO_CHAR_POINTER(NGEOMETRY'ADDRESS);

    C_GEOMETRY                   : constant C_TYPES.NULL_TERMINATED.STRING := 
	( 71,101,111,109,101,116,114,121,  0);
      C_GEOMETRY_PTR : constant C_TYPES.CHAR_POINTER :=
                  C_TYPES.TO_CHAR_POINTER(C_GEOMETRY'ADDRESS);

    NBASE_WIDTH                  : constant C_TYPES.NULL_TERMINATED.STRING := 
	( 98, 97,115,101, 87,105,100,116,104,  0);
      NBASE_WIDTH_PTR : constant C_TYPES.CHAR_POINTER :=
                  C_TYPES.TO_CHAR_POINTER(NBASE_WIDTH'ADDRESS);

    C_BASE_WIDTH                  : constant C_TYPES.NULL_TERMINATED.STRING := 
	( 66, 97,115,101, 87,105,100,116,104,  0);
      C_BASE_WIDTH_PTR : constant C_TYPES.CHAR_POINTER :=
                  C_TYPES.TO_CHAR_POINTER(C_BASE_WIDTH'ADDRESS);

    NBASE_HEIGHT                 : constant C_TYPES.NULL_TERMINATED.STRING := 
	( 98, 97,115,101, 72,101,105,103,104,116,  0);
  
            NBASE_HEIGHT_PTR : constant C_TYPES.CHAR_POINTER :=
                  C_TYPES.TO_CHAR_POINTER(NBASE_HEIGHT'ADDRESS);

    C_BASE_HEIGHT                 : constant C_TYPES.NULL_TERMINATED.STRING := 
	( 66, 97,115,101, 72,101,105,103,104,116,  0);
  
            C_BASE_HEIGHT_PTR : constant C_TYPES.CHAR_POINTER :=
                  C_TYPES.TO_CHAR_POINTER(C_BASE_HEIGHT'ADDRESS);

    NWIN_GRAVITY                 : constant C_TYPES.NULL_TERMINATED.STRING := 
	(119,105,110, 71,114, 97,118,105,116,121,  0);
  
            NWIN_GRAVITY_PTR : constant C_TYPES.CHAR_POINTER :=
                  C_TYPES.TO_CHAR_POINTER(NWIN_GRAVITY'ADDRESS);

    C_WIN_GRAVITY                 : constant C_TYPES.NULL_TERMINATED.STRING := 
	( 87,105,110, 71,114, 97,118,105,116,121,  0);
  
            C_WIN_GRAVITY_PTR : constant C_TYPES.CHAR_POINTER :=
                  C_TYPES.TO_CHAR_POINTER(C_WIN_GRAVITY'ADDRESS);

    NMIN_WIDTH                   : constant C_TYPES.NULL_TERMINATED.STRING := 
	(109,105,110, 87,105,100,116,104,  0);
      NMIN_WIDTH_PTR : constant C_TYPES.CHAR_POINTER :=
                  C_TYPES.TO_CHAR_POINTER(NMIN_WIDTH'ADDRESS);

    C_MIN_WIDTH                   : constant C_TYPES.NULL_TERMINATED.STRING := 
	( 77,105,110, 87,105,100,116,104,  0);
      C_MIN_WIDTH_PTR : constant C_TYPES.CHAR_POINTER :=
                  C_TYPES.TO_CHAR_POINTER(C_MIN_WIDTH'ADDRESS);

    NMIN_HEIGHT                  : constant C_TYPES.NULL_TERMINATED.STRING := 
	(109,105,110, 72,101,105,103,104,116,  0);
      NMIN_HEIGHT_PTR : constant C_TYPES.CHAR_POINTER :=
                  C_TYPES.TO_CHAR_POINTER(NMIN_HEIGHT'ADDRESS);

    C_MIN_HEIGHT                  : constant C_TYPES.NULL_TERMINATED.STRING := 
	( 77,105,110, 72,101,105,103,104,116,  0);
      C_MIN_HEIGHT_PTR : constant C_TYPES.CHAR_POINTER :=
                  C_TYPES.TO_CHAR_POINTER(C_MIN_HEIGHT'ADDRESS);

    NMAX_WIDTH                   : constant C_TYPES.NULL_TERMINATED.STRING := 
	(109, 97,120, 87,105,100,116,104,  0);
      NMAX_WIDTH_PTR : constant C_TYPES.CHAR_POINTER :=
                  C_TYPES.TO_CHAR_POINTER(NMAX_WIDTH'ADDRESS);

    C_MAX_WIDTH                   : constant C_TYPES.NULL_TERMINATED.STRING := 
	( 77, 97,120, 87,105,100,116,104,  0);
      C_MAX_WIDTH_PTR : constant C_TYPES.CHAR_POINTER :=
                  C_TYPES.TO_CHAR_POINTER(C_MAX_WIDTH'ADDRESS);

    NMAX_HEIGHT                  : constant C_TYPES.NULL_TERMINATED.STRING := 
	(109, 97,120, 72,101,105,103,104,116,  0);
      NMAX_HEIGHT_PTR : constant C_TYPES.CHAR_POINTER :=
                  C_TYPES.TO_CHAR_POINTER(NMAX_HEIGHT'ADDRESS);

    C_MAX_HEIGHT                  : constant C_TYPES.NULL_TERMINATED.STRING := 
	( 77, 97,120, 72,101,105,103,104,116,  0);
      C_MAX_HEIGHT_PTR : constant C_TYPES.CHAR_POINTER :=
                  C_TYPES.TO_CHAR_POINTER(C_MAX_HEIGHT'ADDRESS);

    NWIDTH_INC                   : constant C_TYPES.NULL_TERMINATED.STRING := 
	(119,105,100,116,104, 73,110, 99,  0);
      NWIDTH_INC_PTR : constant C_TYPES.CHAR_POINTER :=
                  C_TYPES.TO_CHAR_POINTER(NWIDTH_INC'ADDRESS);

    C_WIDTH_INC                   : constant C_TYPES.NULL_TERMINATED.STRING := 
	( 87,105,100,116,104, 73,110, 99,  0);
      C_WIDTH_INC_PTR : constant C_TYPES.CHAR_POINTER :=
                  C_TYPES.TO_CHAR_POINTER(C_WIDTH_INC'ADDRESS);

    NHEIGHT_INC                  : constant C_TYPES.NULL_TERMINATED.STRING := 
	(104,101,105,103,104,116, 73,110, 99,  0);
      NHEIGHT_INC_PTR : constant C_TYPES.CHAR_POINTER :=
                  C_TYPES.TO_CHAR_POINTER(NHEIGHT_INC'ADDRESS);

    C_HEIGHT_INC                  : constant C_TYPES.NULL_TERMINATED.STRING := 
	( 72,101,105,103,104,116, 73,110, 99,  0);
      C_HEIGHT_INC_PTR : constant C_TYPES.CHAR_POINTER :=
                  C_TYPES.TO_CHAR_POINTER(C_HEIGHT_INC'ADDRESS);

    NMIN_ASPECT_Y                 : constant C_TYPES.NULL_TERMINATED.STRING := 
	(109,105,110, 65,115,112,101, 99,116, 89,  0);
  
            NMIN_ASPECT_Y_PTR : constant C_TYPES.CHAR_POINTER :=
                  C_TYPES.TO_CHAR_POINTER(NMIN_ASPECT_Y'ADDRESS);

    C_MIN_ASPECT_Y                 : constant C_TYPES.NULL_TERMINATED.STRING := 
	( 77,105,110, 65,115,112,101, 99,116, 89,  0);
  
            C_MIN_ASPECT_Y_PTR : constant C_TYPES.CHAR_POINTER :=
                  C_TYPES.TO_CHAR_POINTER(C_MIN_ASPECT_Y'ADDRESS);

    NMAX_ASPECT_Y                 : constant C_TYPES.NULL_TERMINATED.STRING := 
	(109, 97,120, 65,115,112,101, 99,116, 89,  0);
  
            NMAX_ASPECT_Y_PTR : constant C_TYPES.CHAR_POINTER :=
                  C_TYPES.TO_CHAR_POINTER(NMAX_ASPECT_Y'ADDRESS);

    C_MAX_ASPECT_Y                 : constant C_TYPES.NULL_TERMINATED.STRING := 
	( 77, 97,120, 65,115,112,101, 99,116, 89,  0);
  
            C_MAX_ASPECT_Y_PTR : constant C_TYPES.CHAR_POINTER :=
                  C_TYPES.TO_CHAR_POINTER(C_MAX_ASPECT_Y'ADDRESS);

    NMIN_ASPECT_X                 : constant C_TYPES.NULL_TERMINATED.STRING := 
	(109,105,110, 65,115,112,101, 99,116, 88,  0);
  
            NMIN_ASPECT_X_PTR : constant C_TYPES.CHAR_POINTER :=
                  C_TYPES.TO_CHAR_POINTER(NMIN_ASPECT_X'ADDRESS);

    C_MIN_ASPECT_X                 : constant C_TYPES.NULL_TERMINATED.STRING := 
	( 77,105,110, 65,115,112,101, 99,116, 88,  0);
  
            C_MIN_ASPECT_X_PTR : constant C_TYPES.CHAR_POINTER :=
                  C_TYPES.TO_CHAR_POINTER(C_MIN_ASPECT_X'ADDRESS);

    NMAX_ASPECT_X                 : constant C_TYPES.NULL_TERMINATED.STRING := 
	(109, 97,120, 65,115,112,101, 99,116, 88,  0);
  
            NMAX_ASPECT_X_PTR : constant C_TYPES.CHAR_POINTER :=
                  C_TYPES.TO_CHAR_POINTER(NMAX_ASPECT_X'ADDRESS);

    C_MAX_ASPECT_X                 : constant C_TYPES.NULL_TERMINATED.STRING := 
	( 77, 97,120, 65,115,112,101, 99,116, 88,  0);
  
            C_MAX_ASPECT_X_PTR : constant C_TYPES.CHAR_POINTER :=
                  C_TYPES.TO_CHAR_POINTER(C_MAX_ASPECT_X'ADDRESS);

    NWM_TIMEOUT                  : constant C_TYPES.NULL_TERMINATED.STRING := 
	(119,109, 84,105,109,101,111,117,116,  0);
      NWM_TIMEOUT_PTR : constant C_TYPES.CHAR_POINTER :=
                  C_TYPES.TO_CHAR_POINTER(NWM_TIMEOUT'ADDRESS);

    C_WM_TIMEOUT                  : constant C_TYPES.NULL_TERMINATED.STRING := 
	( 87,109, 84,105,109,101,111,117,116,  0);
      C_WM_TIMEOUT_PTR : constant C_TYPES.CHAR_POINTER :=
                  C_TYPES.TO_CHAR_POINTER(C_WM_TIMEOUT'ADDRESS);

    NWAIT_FOR_WM                  : constant C_TYPES.NULL_TERMINATED.STRING := 
	(119, 97,105,116,102,111,114,119,109,  0);
      NWAIT_FOR_WM_PTR : constant C_TYPES.CHAR_POINTER :=
                  C_TYPES.TO_CHAR_POINTER(NWAIT_FOR_WM'ADDRESS);

    C_WAIT_FOR_WM                  : constant C_TYPES.NULL_TERMINATED.STRING := 
	( 87, 97,105,116,102,111,114,119,109,  0);
      C_WAIT_FOR_WM_PTR : constant C_TYPES.CHAR_POINTER :=
                  C_TYPES.TO_CHAR_POINTER(C_WAIT_FOR_WM'ADDRESS);


    NACCELERATORS               : constant C_TYPES.NULL_TERMINATED.STRING := 
	( 97, 99, 99,101,108,101,114, 97,116,111,114,115,  0);
  
            NACCELERATORS_PTR : constant C_TYPES.CHAR_POINTER :=
                  C_TYPES.TO_CHAR_POINTER(NACCELERATORS'ADDRESS);

    NALLOW_HORIZ                 : constant C_TYPES.NULL_TERMINATED.STRING := 
	( 97,108,108,111,119, 72,111,114,105,122,  0);
  
            NALLOW_HORIZ_PTR : constant C_TYPES.CHAR_POINTER :=
                  C_TYPES.TO_CHAR_POINTER(NALLOW_HORIZ'ADDRESS);

    NALLOW_VERT                  : constant C_TYPES.NULL_TERMINATED.STRING := 
	( 97,108,108,111,119, 86,101,114,116,  0);
      NALLOW_VERT_PTR : constant C_TYPES.CHAR_POINTER :=
                  C_TYPES.TO_CHAR_POINTER(NALLOW_VERT'ADDRESS);

    NANCESTOR_SENSITIVE          : constant C_TYPES.NULL_TERMINATED.STRING := 
	( 97,110, 99,101,115,116,111,114, 83,101,110,115,105,116,105,118,
	 101,  0);
  
            NANCESTOR_SENSITIVE_PTR : constant C_TYPES.CHAR_POINTER :=
                  C_TYPES.TO_CHAR_POINTER(NANCESTOR_SENSITIVE'ADDRESS);

    NBACKGROUND                 : constant C_TYPES.NULL_TERMINATED.STRING := 
	( 98, 97, 99,107,103,114,111,117,110,100,  0);
  
            NBACKGROUND_PTR : constant C_TYPES.CHAR_POINTER :=
                  C_TYPES.TO_CHAR_POINTER(NBACKGROUND'ADDRESS);

    NBACKGROUND_PIXMAP           : constant C_TYPES.NULL_TERMINATED.STRING := 
	( 98, 97, 99,107,103,114,111,117,110,100,112,105,120,109, 97,112,
	   0);
  
            NBACKGROUND_PIXMAP_PTR : constant C_TYPES.CHAR_POINTER :=
                  C_TYPES.TO_CHAR_POINTER(NBACKGROUND_PIXMAP'ADDRESS);

    NBITMAP                     : constant C_TYPES.NULL_TERMINATED.STRING := 
	( 98,105,116,109, 97,112,  0);
      NBITMAP_PTR : constant C_TYPES.CHAR_POINTER :=
                  C_TYPES.TO_CHAR_POINTER(NBITMAP'ADDRESS);

    NBORDER_COLOR                : constant C_TYPES.NULL_TERMINATED.STRING := 
	( 98,111,114,100,101,114, 67,111,108,111,114,  0);
  
            NBORDER_COLOR_PTR : constant C_TYPES.CHAR_POINTER :=
                  C_TYPES.TO_CHAR_POINTER(NBORDER_COLOR'ADDRESS);

    NBORDER                     : constant C_TYPES.NULL_TERMINATED.STRING := 
	( 98,111,114,100,101,114, 67,111,108,111,114,  0);
  
            NBORDER_PTR : constant C_TYPES.CHAR_POINTER :=
                  C_TYPES.TO_CHAR_POINTER(NBORDER'ADDRESS);

    NBORDER_PIXMAP               : constant C_TYPES.NULL_TERMINATED.STRING := 
	( 98,111,114,100,101,114,112,105,120,109, 97,112,  0);
  
            NBORDER_PIXMAP_PTR : constant C_TYPES.CHAR_POINTER :=
                  C_TYPES.TO_CHAR_POINTER(NBORDER_PIXMAP'ADDRESS);

    NBORDER_WIDTH                : constant C_TYPES.NULL_TERMINATED.STRING := 
	( 98,111,114,100,101,114, 87,105,100,116,104,  0);
  
            NBORDER_WIDTH_PTR : constant C_TYPES.CHAR_POINTER :=
                  C_TYPES.TO_CHAR_POINTER(NBORDER_WIDTH'ADDRESS);

    NCALLBACK                   : constant C_TYPES.NULL_TERMINATED.STRING := 
	( 99, 97,108,108, 98, 97, 99,107,  0);
      NCALLBACK_PTR : constant C_TYPES.CHAR_POINTER :=
                  C_TYPES.TO_CHAR_POINTER(NCALLBACK'ADDRESS);

    NCHILDREN                   : constant C_TYPES.NULL_TERMINATED.STRING := 
	( 99,104,105,108,100,114,101,110,  0);
      NCHILDREN_PTR : constant C_TYPES.CHAR_POINTER :=
                  C_TYPES.TO_CHAR_POINTER(NCHILDREN'ADDRESS);

    NCOLORMAP                   : constant C_TYPES.NULL_TERMINATED.STRING := 
	( 99,111,108,111,114,109, 97,112,  0);
      NCOLORMAP_PTR : constant C_TYPES.CHAR_POINTER :=
                  C_TYPES.TO_CHAR_POINTER(NCOLORMAP'ADDRESS);

    NDEPTH                      : constant C_TYPES.NULL_TERMINATED.STRING := 
	(100,101,112,116,104,  0);
      NDEPTH_PTR : constant C_TYPES.CHAR_POINTER :=
                  C_TYPES.TO_CHAR_POINTER(NDEPTH'ADDRESS);

    NEDIT_TYPE                   : constant C_TYPES.NULL_TERMINATED.STRING := 
	(101,100,105,116, 84,121,112,101,  0);
      NEDIT_TYPE_PTR : constant C_TYPES.CHAR_POINTER :=
                  C_TYPES.TO_CHAR_POINTER(NEDIT_TYPE'ADDRESS);

    NFILE                       : constant C_TYPES.NULL_TERMINATED.STRING := 
	(102,105,108,101,  0);
      NFILE_PTR : constant C_TYPES.CHAR_POINTER :=
                  C_TYPES.TO_CHAR_POINTER(NFILE'ADDRESS);

    NFONT                       : constant C_TYPES.NULL_TERMINATED.STRING := 
	(102,111,110,116,  0);
      NFONT_PTR : constant C_TYPES.CHAR_POINTER :=
                  C_TYPES.TO_CHAR_POINTER(NFONT'ADDRESS);

    NFORCE_BARS                  : constant C_TYPES.NULL_TERMINATED.STRING := 
	(102,111,114, 99,101, 66, 97,114,115,  0);
      NFORCE_BARS_PTR : constant C_TYPES.CHAR_POINTER :=
                  C_TYPES.TO_CHAR_POINTER(NFORCE_BARS'ADDRESS);

    NFOREGROUND                 : constant C_TYPES.NULL_TERMINATED.STRING := 
	(102,111,114,101,103,114,111,117,110,100,  0);
  
            NFOREGROUND_PTR : constant C_TYPES.CHAR_POINTER :=
                  C_TYPES.TO_CHAR_POINTER(NFOREGROUND'ADDRESS);

    NFUNCTION                   : constant C_TYPES.NULL_TERMINATED.STRING := 
	(102,117,110, 99,116,105,111,110,  0);
      NFUNCTION_PTR : constant C_TYPES.CHAR_POINTER :=
                  C_TYPES.TO_CHAR_POINTER(NFUNCTION'ADDRESS);

    NHEIGHT                     : constant C_TYPES.NULL_TERMINATED.STRING := 
	(104,101,105,103,104,116,  0);
      NHEIGHT_PTR : constant C_TYPES.CHAR_POINTER :=
                  C_TYPES.TO_CHAR_POINTER(NHEIGHT'ADDRESS);

    NHIGHLIGHT                  : constant C_TYPES.NULL_TERMINATED.STRING := 
	(104,105,103,104,108,105,103,104,116,  0);
      NHIGHLIGHT_PTR : constant C_TYPES.CHAR_POINTER :=
                  C_TYPES.TO_CHAR_POINTER(NHIGHLIGHT'ADDRESS);

    NH_SPACE                     : constant C_TYPES.NULL_TERMINATED.STRING := 
	(104, 83,112, 97, 99,101,  0);
      NH_SPACE_PTR : constant C_TYPES.CHAR_POINTER :=
                  C_TYPES.TO_CHAR_POINTER(NH_SPACE'ADDRESS);

    NINDEX                      : constant C_TYPES.NULL_TERMINATED.STRING := 
	(105,110,100,101,120,  0);
      NINDEX_PTR : constant C_TYPES.CHAR_POINTER :=
                  C_TYPES.TO_CHAR_POINTER(NINDEX'ADDRESS);

    NINITIAL_RESOURCES_PERSISTENT : constant C_TYPES.NULL_TERMINATED.STRING := 
        
	(105,110,105,116,105, 97,108, 82,101,115,111,117,114, 99,101,115,
	  80,101,114,115,105,115,116,101,110,116,  0);
      NINITIAL_RESOURCES_PERSISTENT_PTR : constant C_TYPES.CHAR_POINTER :=
                  C_TYPES.TO_CHAR_POINTER(NINITIAL_RESOURCES_PERSISTENT'ADDRESS);

    NINNER_HEIGHT                : constant C_TYPES.NULL_TERMINATED.STRING := 
	(105,110,110,101,114, 72,101,105,103,104,116,  0);
  
            NINNER_HEIGHT_PTR : constant C_TYPES.CHAR_POINTER :=
                  C_TYPES.TO_CHAR_POINTER(NINNER_HEIGHT'ADDRESS);

    NINNER_WIDTH                 : constant C_TYPES.NULL_TERMINATED.STRING := 
	(105,110,110,101,114, 87,105,100,116,104,  0);
  
            NINNER_WIDTH_PTR : constant C_TYPES.CHAR_POINTER :=
                  C_TYPES.TO_CHAR_POINTER(NINNER_WIDTH'ADDRESS);

    NINNER_WINDOW                : constant C_TYPES.NULL_TERMINATED.STRING := 
	(105,110,110,101,114, 87,105,110,100,111,119,  0);
  
            NINNER_WINDOW_PTR : constant C_TYPES.CHAR_POINTER :=
                  C_TYPES.TO_CHAR_POINTER(NINNER_WINDOW'ADDRESS);

    NINSERT_POSITION             : constant C_TYPES.NULL_TERMINATED.STRING := 
	(105,110,115,101,114,116, 80,111,115,105,116,105,111,110,  0);
  
            NINSERT_POSITION_PTR : constant C_TYPES.CHAR_POINTER :=
                  C_TYPES.TO_CHAR_POINTER(NINSERT_POSITION'ADDRESS);

    NINTERNAL_HEIGHT             : constant C_TYPES.NULL_TERMINATED.STRING := 
	(105,110,116,101,114,110, 97,108, 72,101,105,103,104,116,  0);
  
            NINTERNAL_HEIGHT_PTR : constant C_TYPES.CHAR_POINTER :=
                  C_TYPES.TO_CHAR_POINTER(NINTERNAL_HEIGHT'ADDRESS);

    NINTERNAL_WIDTH              : constant C_TYPES.NULL_TERMINATED.STRING := 
	(105,110,116,101,114,110, 97,108, 87,105,100,116,104,  0);
  
            NINTERNAL_WIDTH_PTR : constant C_TYPES.CHAR_POINTER :=
                  C_TYPES.TO_CHAR_POINTER(NINTERNAL_WIDTH'ADDRESS);

    NJUMP_PROC                   : constant C_TYPES.NULL_TERMINATED.STRING := 
	(106,117,109,112, 80,114,111, 99,  0);
      NJUMP_PROC_PTR : constant C_TYPES.CHAR_POINTER :=
                  C_TYPES.TO_CHAR_POINTER(NJUMP_PROC'ADDRESS);

    NJUSTIFY                    : constant C_TYPES.NULL_TERMINATED.STRING := 
	(106,117,115,116,105,102,121,  0);
      NJUSTIFY_PTR : constant C_TYPES.CHAR_POINTER :=
                  C_TYPES.TO_CHAR_POINTER(NJUSTIFY'ADDRESS);

    NKNOB_HEIGHT                 : constant C_TYPES.NULL_TERMINATED.STRING := 
	(107,110,111, 98, 72,101,105,103,104,116,  0);
  
            NKNOB_HEIGHT_PTR : constant C_TYPES.CHAR_POINTER :=
                  C_TYPES.TO_CHAR_POINTER(NKNOB_HEIGHT'ADDRESS);

    NKNOB_INDENT                 : constant C_TYPES.NULL_TERMINATED.STRING := 
	(107,110,111, 98, 73,110,100,101,110,116,  0);
  
            NKNOB_INDENT_PTR : constant C_TYPES.CHAR_POINTER :=
                  C_TYPES.TO_CHAR_POINTER(NKNOB_INDENT'ADDRESS);

    NKNOB_PIXEL                  : constant C_TYPES.NULL_TERMINATED.STRING := 
	(107,110,111, 98, 80,105,120,101,108,  0);
      NKNOB_PIXEL_PTR : constant C_TYPES.CHAR_POINTER :=
                  C_TYPES.TO_CHAR_POINTER(NKNOB_PIXEL'ADDRESS);

    NKNOB_WIDTH                  : constant C_TYPES.NULL_TERMINATED.STRING := 
	(107,110,111, 98, 87,105,100,116,104,  0);
      NKNOB_WIDTH_PTR : constant C_TYPES.CHAR_POINTER :=
                  C_TYPES.TO_CHAR_POINTER(NKNOB_WIDTH'ADDRESS);

    NLABEL                      : constant C_TYPES.NULL_TERMINATED.STRING := 
	(108, 97, 98,101,108,  0);
      NLABEL_PTR : constant C_TYPES.CHAR_POINTER :=
                  C_TYPES.TO_CHAR_POINTER(NLABEL'ADDRESS);

    NLENGTH                     : constant C_TYPES.NULL_TERMINATED.STRING := 
	(108,101,110,103,116,104,  0);
      NLENGTH_PTR : constant C_TYPES.CHAR_POINTER :=
                  C_TYPES.TO_CHAR_POINTER(NLENGTH'ADDRESS);

    NLOWER_RIGHT                 : constant C_TYPES.NULL_TERMINATED.STRING := 
	(108,111,119,101,114, 82,105,103,104,116,  0);
  
            NLOWER_RIGHT_PTR : constant C_TYPES.CHAR_POINTER :=
                  C_TYPES.TO_CHAR_POINTER(NLOWER_RIGHT'ADDRESS);

    NMAPPED_WHEN_MANAGED          : constant C_TYPES.NULL_TERMINATED.STRING := 
	(109, 97,112,112,101,100, 87,104,101,110, 77, 97,110, 97,103,101,
	 100,  0);
  
            NMAPPED_WHEN_MANAGED_PTR : constant C_TYPES.CHAR_POINTER :=
                  C_TYPES.TO_CHAR_POINTER(NMAPPED_WHEN_MANAGED'ADDRESS);

    NMENU_ENTRY                  : constant C_TYPES.NULL_TERMINATED.STRING := 
	(109,101,110,117, 69,110,116,114,121,  0);
      NMENU_ENTRY_PTR : constant C_TYPES.CHAR_POINTER :=
                  C_TYPES.TO_CHAR_POINTER(NMENU_ENTRY'ADDRESS);

    NNAME                       : constant C_TYPES.NULL_TERMINATED.STRING := 
	(110, 97,109,101,  0);
      NNAME_PTR : constant C_TYPES.CHAR_POINTER :=
                  C_TYPES.TO_CHAR_POINTER(NNAME'ADDRESS);

    NNOTIFY                     : constant C_TYPES.NULL_TERMINATED.STRING := 
	(110,111,116,105,102,121,  0);
      NNOTIFY_PTR : constant C_TYPES.CHAR_POINTER :=
                  C_TYPES.TO_CHAR_POINTER(NNOTIFY'ADDRESS);

    NNUM_CHILDREN                : constant C_TYPES.NULL_TERMINATED.STRING := 
	(110,117,109, 67,104,105,108,100,114,101,110,  0);
  
            NNUM_CHILDREN_PTR : constant C_TYPES.CHAR_POINTER :=
                  C_TYPES.TO_CHAR_POINTER(NNUM_CHILDREN'ADDRESS);

    NORIENTATION                : constant C_TYPES.NULL_TERMINATED.STRING := 
	(111,114,105,101,110,116, 97,116,105,111,110,  0);
  
            NORIENTATION_PTR : constant C_TYPES.CHAR_POINTER :=
                  C_TYPES.TO_CHAR_POINTER(NORIENTATION'ADDRESS);

    NPARAMETER                  : constant C_TYPES.NULL_TERMINATED.STRING := 
	(112, 97,114, 97,109,101,116,101,114,  0);
      NPARAMETER_PTR : constant C_TYPES.CHAR_POINTER :=
                  C_TYPES.TO_CHAR_POINTER(NPARAMETER'ADDRESS);

    NPIXMAP                     : constant C_TYPES.NULL_TERMINATED.STRING := 
	(112,105,120,109, 97,112,  0);
      NPIXMAP_PTR : constant C_TYPES.CHAR_POINTER :=
                  C_TYPES.TO_CHAR_POINTER(NPIXMAP'ADDRESS);

    NRESIZE                     : constant C_TYPES.NULL_TERMINATED.STRING := 
	(114,101,115,105,122,101,  0);
      NRESIZE_PTR : constant C_TYPES.CHAR_POINTER :=
                  C_TYPES.TO_CHAR_POINTER(NRESIZE'ADDRESS);

    NREVERSE_VIDEO               : constant C_TYPES.NULL_TERMINATED.STRING := 
	(114,101,118,101,114,115,101, 86,105,100,101,111,  0);
  
            NREVERSE_VIDEO_PTR : constant C_TYPES.CHAR_POINTER :=
                  C_TYPES.TO_CHAR_POINTER(NREVERSE_VIDEO'ADDRESS);

    NSCREEN                     : constant C_TYPES.NULL_TERMINATED.STRING := 
	(115, 99,114,101,101,110,  0);
      NSCREEN_PTR : constant C_TYPES.CHAR_POINTER :=
                  C_TYPES.TO_CHAR_POINTER(NSCREEN'ADDRESS);

    NSCROLL_PROC                 : constant C_TYPES.NULL_TERMINATED.STRING := 
	(115, 99,114,111,108,108, 80,114,111, 99,  0);
  
            NSCROLL_PROC_PTR : constant C_TYPES.CHAR_POINTER :=
                  C_TYPES.TO_CHAR_POINTER(NSCROLL_PROC'ADDRESS);

    NSCROLL_D_CURSOR              : constant C_TYPES.NULL_TERMINATED.STRING := 
	(115, 99,114,111,108,108, 68, 67,117,114,115,111,114,  0);
  
            NSCROLL_D_CURSOR_PTR : constant C_TYPES.CHAR_POINTER :=
                  C_TYPES.TO_CHAR_POINTER(NSCROLL_D_CURSOR'ADDRESS);

    NSCROLL_H_CURSOR              : constant C_TYPES.NULL_TERMINATED.STRING := 
	(115, 99,114,111,108,108, 72, 67,117,114,115,111,114,  0);
  
            NSCROLL_H_CURSOR_PTR : constant C_TYPES.CHAR_POINTER :=
                  C_TYPES.TO_CHAR_POINTER(NSCROLL_H_CURSOR'ADDRESS);

    NSCROLL_L_CURSOR              : constant C_TYPES.NULL_TERMINATED.STRING := 
	(115, 99,114,111,108,108, 76, 67,117,114,115,111,114,  0);
  
            NSCROLL_L_CURSOR_PTR : constant C_TYPES.CHAR_POINTER :=
                  C_TYPES.TO_CHAR_POINTER(NSCROLL_L_CURSOR'ADDRESS);

    NSCROLL_R_CURSOR              : constant C_TYPES.NULL_TERMINATED.STRING := 
	(115, 99,114,111,108,108, 82, 67,117,114,115,111,114,  0);
  
            NSCROLL_R_CURSOR_PTR : constant C_TYPES.CHAR_POINTER :=
                  C_TYPES.TO_CHAR_POINTER(NSCROLL_R_CURSOR'ADDRESS);

    NSCROLL_U_CURSOR              : constant C_TYPES.NULL_TERMINATED.STRING := 
	(115, 99,114,111,108,108, 85, 67,117,114,115,111,114,  0);
  
            NSCROLL_U_CURSOR_PTR : constant C_TYPES.CHAR_POINTER :=
                  C_TYPES.TO_CHAR_POINTER(NSCROLL_U_CURSOR'ADDRESS);

    NSCROLL_V_CURSOR              : constant C_TYPES.NULL_TERMINATED.STRING := 
	(115, 99,114,111,108,108, 86, 67,117,114,115,111,114,  0);
  
            NSCROLL_V_CURSOR_PTR : constant C_TYPES.CHAR_POINTER :=
                  C_TYPES.TO_CHAR_POINTER(NSCROLL_V_CURSOR'ADDRESS);

    NSELECTION                  : constant C_TYPES.NULL_TERMINATED.STRING := 
	(115,101,108,101, 99,116,105,111,110,  0);
      NSELECTION_PTR : constant C_TYPES.CHAR_POINTER :=
                  C_TYPES.TO_CHAR_POINTER(NSELECTION'ADDRESS);

    NSELECTION_ARRAY             : constant C_TYPES.NULL_TERMINATED.STRING := 
	(115,101,108,101, 99,116,105,111,110, 65,114,114, 97,121,  0);
  
            NSELECTION_ARRAY_PTR : constant C_TYPES.CHAR_POINTER :=
                  C_TYPES.TO_CHAR_POINTER(NSELECTION_ARRAY'ADDRESS);

    NSENSITIVE                  : constant C_TYPES.NULL_TERMINATED.STRING := 
	(115,101,110,115,105,116,105,118,101,  0);
      NSENSITIVE_PTR : constant C_TYPES.CHAR_POINTER :=
                  C_TYPES.TO_CHAR_POINTER(NSENSITIVE'ADDRESS);

    NSHOWN                      : constant C_TYPES.NULL_TERMINATED.STRING := 
	(115,104,111,119,110,  0);
      NSHOWN_PTR : constant C_TYPES.CHAR_POINTER :=
                  C_TYPES.TO_CHAR_POINTER(NSHOWN'ADDRESS);

    NSPACE                      : constant C_TYPES.NULL_TERMINATED.STRING := 
	(115,112, 97, 99,101,  0);
      NSPACE_PTR : constant C_TYPES.CHAR_POINTER :=
                  C_TYPES.TO_CHAR_POINTER(NSPACE'ADDRESS);

    NSTRING                     : constant C_TYPES.NULL_TERMINATED.STRING := 
	( 83,116,114,105,110,103,  0);
      NSTRING_PTR : constant C_TYPES.CHAR_POINTER :=
                  C_TYPES.TO_CHAR_POINTER(NSTRING'ADDRESS);

    NTEXT_OPTIONS                : constant C_TYPES.NULL_TERMINATED.STRING := 
	(116,101,120,116, 79,112,116,105,111,110,115,  0);
  
            NTEXT_OPTIONS_PTR : constant C_TYPES.CHAR_POINTER :=
                  C_TYPES.TO_CHAR_POINTER(NTEXT_OPTIONS'ADDRESS);

    NTEXT_SINK                   : constant C_TYPES.NULL_TERMINATED.STRING := 
	(116,101,120,116, 83,105,110,107,  0);
      NTEXT_SINK_PTR : constant C_TYPES.CHAR_POINTER :=
                  C_TYPES.TO_CHAR_POINTER(NTEXT_SINK'ADDRESS);

    NTEXT_SOURCE                 : constant C_TYPES.NULL_TERMINATED.STRING := 
	(116,101,120,116, 83,111,117,114, 99,101,  0);
  
            NTEXT_SOURCE_PTR : constant C_TYPES.CHAR_POINTER :=
                  C_TYPES.TO_CHAR_POINTER(NTEXT_SOURCE'ADDRESS);

    NTHICKNESS                  : constant C_TYPES.NULL_TERMINATED.STRING := 
	(116,104,105, 99,107,110,101,115,115,  0);
      NTHICKNESS_PTR : constant C_TYPES.CHAR_POINTER :=
                  C_TYPES.TO_CHAR_POINTER(NTHICKNESS'ADDRESS);

    NTHUMB                      : constant C_TYPES.NULL_TERMINATED.STRING := 
	(116,104,117,109, 98,  0);
      NTHUMB_PTR : constant C_TYPES.CHAR_POINTER :=
                  C_TYPES.TO_CHAR_POINTER(NTHUMB'ADDRESS);

    NTHUMB_PROC                  : constant C_TYPES.NULL_TERMINATED.STRING := 
	(116,104,117,109, 98, 80,114,111, 99,  0);
      NTHUMB_PROC_PTR : constant C_TYPES.CHAR_POINTER :=
                  C_TYPES.TO_CHAR_POINTER(NTHUMB_PROC'ADDRESS);

    NTOP                        : constant C_TYPES.NULL_TERMINATED.STRING := 
	(116,111,112,  0);
      NTOP_PTR : constant C_TYPES.CHAR_POINTER :=
                  C_TYPES.TO_CHAR_POINTER(NTOP'ADDRESS);

    NTRANSLATIONS               : constant C_TYPES.NULL_TERMINATED.STRING := 
	(116,114, 97,110,115,108, 97,116,105,111,110,115,  0);
  
            NTRANSLATIONS_PTR : constant C_TYPES.CHAR_POINTER :=
                  C_TYPES.TO_CHAR_POINTER(NTRANSLATIONS'ADDRESS);

    NUPDATE                     : constant C_TYPES.NULL_TERMINATED.STRING := 
	(117,112,100, 97,116,101,  0);
      NUPDATE_PTR : constant C_TYPES.CHAR_POINTER :=
                  C_TYPES.TO_CHAR_POINTER(NUPDATE'ADDRESS);

    NUSE_BOTTOM                  : constant C_TYPES.NULL_TERMINATED.STRING := 
	(117,115,101, 66,111,116,116,111,109,  0);
      NUSE_BOTTOM_PTR : constant C_TYPES.CHAR_POINTER :=
                  C_TYPES.TO_CHAR_POINTER(NUSE_BOTTOM'ADDRESS);

    NUSE_RIGHT                   : constant C_TYPES.NULL_TERMINATED.STRING := 
	(117,115,101, 82,105,103,104,116,  0);
      NUSE_RIGHT_PTR : constant C_TYPES.CHAR_POINTER :=
                  C_TYPES.TO_CHAR_POINTER(NUSE_RIGHT'ADDRESS);

    NVALUE                      : constant C_TYPES.NULL_TERMINATED.STRING := 
	(118, 97,108,117,101,  0);
      NVALUE_PTR : constant C_TYPES.CHAR_POINTER :=
                  C_TYPES.TO_CHAR_POINTER(NVALUE'ADDRESS);

    NV_SPACE                     : constant C_TYPES.NULL_TERMINATED.STRING := 
	(118, 83,112, 97, 99,101,  0);
      NV_SPACE_PTR : constant C_TYPES.CHAR_POINTER :=
                  C_TYPES.TO_CHAR_POINTER(NV_SPACE'ADDRESS);

    NWIDTH                      : constant C_TYPES.NULL_TERMINATED.STRING := 
	(119,105,100,116,104,  0);
      NWIDTH_PTR : constant C_TYPES.CHAR_POINTER :=
                  C_TYPES.TO_CHAR_POINTER(NWIDTH'ADDRESS);

    NWINDOW                     : constant C_TYPES.NULL_TERMINATED.STRING := 
	(119,105,110,100,111,119,  0);
      NWINDOW_PTR : constant C_TYPES.CHAR_POINTER :=
                  C_TYPES.TO_CHAR_POINTER(NWINDOW'ADDRESS);

    NX                          : constant C_TYPES.NULL_TERMINATED.STRING := 
	(120,  0);
      NX_PTR : constant C_TYPES.CHAR_POINTER :=
                  C_TYPES.TO_CHAR_POINTER(NX'ADDRESS);

    NY                          : constant C_TYPES.NULL_TERMINATED.STRING := 
	(121,  0);
      NY_PTR : constant C_TYPES.CHAR_POINTER :=
                  C_TYPES.TO_CHAR_POINTER(NY'ADDRESS);

    C_ACCELERATORS               : constant C_TYPES.NULL_TERMINATED.STRING := 
	( 65, 99, 99,101,108,101,114, 97,116,111,114,115,  0);
  
            C_ACCELERATORS_PTR : constant C_TYPES.CHAR_POINTER :=
                  C_TYPES.TO_CHAR_POINTER(C_ACCELERATORS'ADDRESS);

    C_BACKGROUND                 : constant C_TYPES.NULL_TERMINATED.STRING := 
	( 66, 97, 99,107,103,114,111,117,110,100,  0);
  
            C_BACKGROUND_PTR : constant C_TYPES.CHAR_POINTER :=
                  C_TYPES.TO_CHAR_POINTER(C_BACKGROUND'ADDRESS);

    C_BITMAP                     : constant C_TYPES.NULL_TERMINATED.STRING := 
	( 66,105,116,109, 97,112,  0);
      C_BITMAP_PTR : constant C_TYPES.CHAR_POINTER :=
                  C_TYPES.TO_CHAR_POINTER(C_BITMAP'ADDRESS);

    C_BOOLEAN                    : constant C_TYPES.NULL_TERMINATED.STRING := 
	( 66,111,111,108,101, 97,110,  0);
      C_BOOLEAN_PTR : constant C_TYPES.CHAR_POINTER :=
                  C_TYPES.TO_CHAR_POINTER(C_BOOLEAN'ADDRESS);

    C_BORDER_COLOR                : constant C_TYPES.NULL_TERMINATED.STRING := 
	( 66,111,114,100,101,114, 67,111,108,111,114,  0);
  
            C_BORDER_COLOR_PTR : constant C_TYPES.CHAR_POINTER :=
                  C_TYPES.TO_CHAR_POINTER(C_BORDER_COLOR'ADDRESS);

    C_BORDER_WIDTH                : constant C_TYPES.NULL_TERMINATED.STRING := 
	( 66,111,114,100,101,114, 87,105,100,116,104,  0);
  
            C_BORDER_WIDTH_PTR : constant C_TYPES.CHAR_POINTER :=
                  C_TYPES.TO_CHAR_POINTER(C_BORDER_WIDTH'ADDRESS);

    C_CALLBACK                   : constant C_TYPES.NULL_TERMINATED.STRING := 
	( 67, 97,108,108, 98, 97, 99,107,  0);
      C_CALLBACK_PTR : constant C_TYPES.CHAR_POINTER :=
                  C_TYPES.TO_CHAR_POINTER(C_CALLBACK'ADDRESS);

    C_COLORMAP                   : constant C_TYPES.NULL_TERMINATED.STRING := 
	( 67,111,108,111,114,109, 97,112,  0);
      C_COLORMAP_PTR : constant C_TYPES.CHAR_POINTER :=
                  C_TYPES.TO_CHAR_POINTER(C_COLORMAP'ADDRESS);

    C_COLOR                      : constant C_TYPES.NULL_TERMINATED.STRING := 
	( 67,111,108,111,114,  0);
      C_COLOR_PTR : constant C_TYPES.CHAR_POINTER :=
                  C_TYPES.TO_CHAR_POINTER(C_COLOR'ADDRESS);

    C_CURSOR                     : constant C_TYPES.NULL_TERMINATED.STRING := 
	( 67,117,114,115,111,114,  0);
      C_CURSOR_PTR : constant C_TYPES.CHAR_POINTER :=
                  C_TYPES.TO_CHAR_POINTER(C_CURSOR'ADDRESS);

    C_DEPTH                      : constant C_TYPES.NULL_TERMINATED.STRING := 
	( 68,101,112,116,104,  0);
      C_DEPTH_PTR : constant C_TYPES.CHAR_POINTER :=
                  C_TYPES.TO_CHAR_POINTER(C_DEPTH'ADDRESS);

    C_EDIT_TYPE                   : constant C_TYPES.NULL_TERMINATED.STRING := 
	( 69,100,105,116, 84,121,112,101,  0);
      C_EDIT_TYPE_PTR : constant C_TYPES.CHAR_POINTER :=
                  C_TYPES.TO_CHAR_POINTER(C_EDIT_TYPE'ADDRESS);

    C_EVENT_BINDINGS              : constant C_TYPES.NULL_TERMINATED.STRING := 
	( 69,118,101,110,116, 66,105,110,100,105,110,103,115,  0);
  
            C_EVENT_BINDINGS_PTR : constant C_TYPES.CHAR_POINTER :=
                  C_TYPES.TO_CHAR_POINTER(C_EVENT_BINDINGS'ADDRESS);

    C_FILE                       : constant C_TYPES.NULL_TERMINATED.STRING := 
	( 70,105,108,101,  0);
      C_FILE_PTR : constant C_TYPES.CHAR_POINTER :=
                  C_TYPES.TO_CHAR_POINTER(C_FILE'ADDRESS);

    C_FONT                       : constant C_TYPES.NULL_TERMINATED.STRING := 
	( 70,111,110,116,  0);
      C_FONT_PTR : constant C_TYPES.CHAR_POINTER :=
                  C_TYPES.TO_CHAR_POINTER(C_FONT'ADDRESS);

    C_FOREGROUND                 : constant C_TYPES.NULL_TERMINATED.STRING := 
	( 70,111,114,101,103,114,111,117,110,100,  0);
  
            C_FOREGROUND_PTR : constant C_TYPES.CHAR_POINTER :=
                  C_TYPES.TO_CHAR_POINTER(C_FOREGROUND'ADDRESS);

    C_FRACTION                   : constant C_TYPES.NULL_TERMINATED.STRING := 
	( 70,114, 97, 99,116,105,111,110,  0);
      C_FRACTION_PTR : constant C_TYPES.CHAR_POINTER :=
                  C_TYPES.TO_CHAR_POINTER(C_FRACTION'ADDRESS);

    C_FUNCTION                   : constant C_TYPES.NULL_TERMINATED.STRING := 
	( 70,117,110, 99,116,105,111,110,  0);
      C_FUNCTION_PTR : constant C_TYPES.CHAR_POINTER :=
                  C_TYPES.TO_CHAR_POINTER(C_FUNCTION'ADDRESS);

    C_HEIGHT                     : constant C_TYPES.NULL_TERMINATED.STRING := 
	( 72,101,105,103,104,116,  0);
      C_HEIGHT_PTR : constant C_TYPES.CHAR_POINTER :=
                  C_TYPES.TO_CHAR_POINTER(C_HEIGHT'ADDRESS);

    C_H_SPACE                     : constant C_TYPES.NULL_TERMINATED.STRING := 
	( 72, 83,112, 97, 99,101,  0);
      C_H_SPACE_PTR : constant C_TYPES.CHAR_POINTER :=
                  C_TYPES.TO_CHAR_POINTER(C_H_SPACE'ADDRESS);

    C_INDEX                      : constant C_TYPES.NULL_TERMINATED.STRING := 
	( 73,110,100,101,120,  0);
      C_INDEX_PTR : constant C_TYPES.CHAR_POINTER :=
                  C_TYPES.TO_CHAR_POINTER(C_INDEX'ADDRESS);

    C_INITIAL_RESOURCES_PERSISTENT : constant C_TYPES.NULL_TERMINATED.STRING := 
        
	( 73,110,105,116,105, 97,108, 82,101,115,111,117,114, 99,101,115,
	  80,101,114,115,105,115,116,101,110,116,  0);
      C_INITIAL_RESOURCES_PERSISTENT_PTR : constant C_TYPES.CHAR_POINTER :=
                  C_TYPES.TO_CHAR_POINTER(C_INITIAL_RESOURCES_PERSISTENT'ADDRESS);

    C_INSERT_POSITION             : constant C_TYPES.NULL_TERMINATED.STRING := 
	( 73,110,115,101,114,116, 80,111,115,105,116,105,111,110,  0);
  
            C_INSERT_POSITION_PTR : constant C_TYPES.CHAR_POINTER :=
                  C_TYPES.TO_CHAR_POINTER(C_INSERT_POSITION'ADDRESS);

    C_INTERVAL                   : constant C_TYPES.NULL_TERMINATED.STRING := 
	( 73,110,116,101,114,118, 97,108,  0);
      C_INTERVAL_PTR : constant C_TYPES.CHAR_POINTER :=
                  C_TYPES.TO_CHAR_POINTER(C_INTERVAL'ADDRESS);

    C_JUSTIFY                    : constant C_TYPES.NULL_TERMINATED.STRING := 
	( 74,117,115,116,105,102,121,  0);
      C_JUSTIFY_PTR : constant C_TYPES.CHAR_POINTER :=
                  C_TYPES.TO_CHAR_POINTER(C_JUSTIFY'ADDRESS);

    C_KNOB_INDENT                 : constant C_TYPES.NULL_TERMINATED.STRING := 
	( 75,110,111, 98, 73,110,100,101,110,116,  0);
  
            C_KNOB_INDENT_PTR : constant C_TYPES.CHAR_POINTER :=
                  C_TYPES.TO_CHAR_POINTER(C_KNOB_INDENT'ADDRESS);

    C_KNOB_PIXEL                  : constant C_TYPES.NULL_TERMINATED.STRING := 
	( 75,110,111, 98, 80,105,120,101,108,  0);
      C_KNOB_PIXEL_PTR : constant C_TYPES.CHAR_POINTER :=
                  C_TYPES.TO_CHAR_POINTER(C_KNOB_PIXEL'ADDRESS);

    C_LABEL                      : constant C_TYPES.NULL_TERMINATED.STRING := 
	( 76, 97, 98,101,108,  0);
      C_LABEL_PTR : constant C_TYPES.CHAR_POINTER :=
                  C_TYPES.TO_CHAR_POINTER(C_LABEL'ADDRESS);

    C_LENGTH                     : constant C_TYPES.NULL_TERMINATED.STRING := 
	( 76,101,110,103,116,104,  0);
      C_LENGTH_PTR : constant C_TYPES.CHAR_POINTER :=
                  C_TYPES.TO_CHAR_POINTER(C_LENGTH'ADDRESS);

    C_MAPPED_WHEN_MANAGED          : constant C_TYPES.NULL_TERMINATED.STRING := 
	( 77, 97,112,112,101,100, 87,104,101,110, 77, 97,110, 97,103,101,
	 100,  0);
  
            C_MAPPED_WHEN_MANAGED_PTR : constant C_TYPES.CHAR_POINTER :=
                  C_TYPES.TO_CHAR_POINTER(C_MAPPED_WHEN_MANAGED'ADDRESS);

    C_MARGIN                     : constant C_TYPES.NULL_TERMINATED.STRING := 
	( 77, 97,114,103,105,110,  0);
      C_MARGIN_PTR : constant C_TYPES.CHAR_POINTER :=
                  C_TYPES.TO_CHAR_POINTER(C_MARGIN'ADDRESS);

    C_MENU_ENTRY                  : constant C_TYPES.NULL_TERMINATED.STRING := 
	( 77,101,110,117, 69,110,116,114,121,  0);
      C_MENU_ENTRY_PTR : constant C_TYPES.CHAR_POINTER :=
                  C_TYPES.TO_CHAR_POINTER(C_MENU_ENTRY'ADDRESS);

    C_NOTIFY                     : constant C_TYPES.NULL_TERMINATED.STRING := 
	( 78,111,116,105,102,121,  0);
      C_NOTIFY_PTR : constant C_TYPES.CHAR_POINTER :=
                  C_TYPES.TO_CHAR_POINTER(C_NOTIFY'ADDRESS);

    C_ORIENTATION                : constant C_TYPES.NULL_TERMINATED.STRING := 
	( 79,114,105,101,110,116, 97,116,105,111,110,  0);
  
            C_ORIENTATION_PTR : constant C_TYPES.CHAR_POINTER :=
                  C_TYPES.TO_CHAR_POINTER(C_ORIENTATION'ADDRESS);

    C_PARAMETER                  : constant C_TYPES.NULL_TERMINATED.STRING := 
	( 80, 97,114, 97,109,101,116,101,114,  0);
      C_PARAMETER_PTR : constant C_TYPES.CHAR_POINTER :=
                  C_TYPES.TO_CHAR_POINTER(C_PARAMETER'ADDRESS);

    C_PIXMAP                     : constant C_TYPES.NULL_TERMINATED.STRING := 
	(112,105,120,109, 97,112,  0);
      C_PIXMAP_PTR : constant C_TYPES.CHAR_POINTER :=
                  C_TYPES.TO_CHAR_POINTER(C_PIXMAP'ADDRESS);

    C_POSITION                   : constant C_TYPES.NULL_TERMINATED.STRING := 
	( 80,111,115,105,116,105,111,110,  0);
      C_POSITION_PTR : constant C_TYPES.CHAR_POINTER :=
                  C_TYPES.TO_CHAR_POINTER(C_POSITION'ADDRESS);

    C_READ_ONLY                   : constant C_TYPES.NULL_TERMINATED.STRING := 
	( 82,101, 97,100, 79,110,108,121,  0);
      C_READ_ONLY_PTR : constant C_TYPES.CHAR_POINTER :=
                  C_TYPES.TO_CHAR_POINTER(C_READ_ONLY'ADDRESS);

    C_RESIZE                     : constant C_TYPES.NULL_TERMINATED.STRING := 
	( 82,101,115,105,122,101,  0);
      C_RESIZE_PTR : constant C_TYPES.CHAR_POINTER :=
                  C_TYPES.TO_CHAR_POINTER(C_RESIZE'ADDRESS);

    C_REVERSE_VIDEO               : constant C_TYPES.NULL_TERMINATED.STRING := 
	( 82,101,118,101,114,115,101, 86,105,100,101,111,  0);
  
            C_REVERSE_VIDEO_PTR : constant C_TYPES.CHAR_POINTER :=
                  C_TYPES.TO_CHAR_POINTER(C_REVERSE_VIDEO'ADDRESS);

    C_SCREEN                     : constant C_TYPES.NULL_TERMINATED.STRING := 
	( 83, 99,114,101,101,110,  0);
      C_SCREEN_PTR : constant C_TYPES.CHAR_POINTER :=
                  C_TYPES.TO_CHAR_POINTER(C_SCREEN'ADDRESS);

    C_SCROLL_PROC                 : constant C_TYPES.NULL_TERMINATED.STRING := 
	( 83, 99,114,111,108,108, 80,114,111, 99,  0);
  
            C_SCROLL_PROC_PTR : constant C_TYPES.CHAR_POINTER :=
                  C_TYPES.TO_CHAR_POINTER(C_SCROLL_PROC'ADDRESS);

    C_SCROLL_D_CURSOR              : constant C_TYPES.NULL_TERMINATED.STRING := 
	( 83, 99,114,111,108,108, 68, 67,117,114,115,111,114,  0);
  
            C_SCROLL_D_CURSOR_PTR : constant C_TYPES.CHAR_POINTER :=
                  C_TYPES.TO_CHAR_POINTER(C_SCROLL_D_CURSOR'ADDRESS);

    C_SCROLL_H_CURSOR              : constant C_TYPES.NULL_TERMINATED.STRING := 
	( 83, 99,114,111,108,108, 72, 67,117,114,115,111,114,  0);
  
            C_SCROLL_H_CURSOR_PTR : constant C_TYPES.CHAR_POINTER :=
                  C_TYPES.TO_CHAR_POINTER(C_SCROLL_H_CURSOR'ADDRESS);

    C_SCROLL_L_CURSOR              : constant C_TYPES.NULL_TERMINATED.STRING := 
	( 83, 99,114,111,108,108, 76, 67,117,114,115,111,114,  0);
  
            C_SCROLL_L_CURSOR_PTR : constant C_TYPES.CHAR_POINTER :=
                  C_TYPES.TO_CHAR_POINTER(C_SCROLL_L_CURSOR'ADDRESS);

    C_SCROLL_R_CURSOR              : constant C_TYPES.NULL_TERMINATED.STRING := 
	( 83, 99,114,111,108,108, 82, 67,117,114,115,111,114,  0);
  
            C_SCROLL_R_CURSOR_PTR : constant C_TYPES.CHAR_POINTER :=
                  C_TYPES.TO_CHAR_POINTER(C_SCROLL_R_CURSOR'ADDRESS);

    C_SCROLL_U_CURSOR              : constant C_TYPES.NULL_TERMINATED.STRING := 
	( 83, 99,114,111,108,108, 85, 67,117,114,115,111,114,  0);
  
            C_SCROLL_U_CURSOR_PTR : constant C_TYPES.CHAR_POINTER :=
                  C_TYPES.TO_CHAR_POINTER(C_SCROLL_U_CURSOR'ADDRESS);

    C_SCROLL_V_CURSOR              : constant C_TYPES.NULL_TERMINATED.STRING := 
	( 83, 99,114,111,108,108, 86, 67,117,114,115,111,114,  0);
  
            C_SCROLL_V_CURSOR_PTR : constant C_TYPES.CHAR_POINTER :=
                  C_TYPES.TO_CHAR_POINTER(C_SCROLL_V_CURSOR'ADDRESS);

    C_SELECTION                  : constant C_TYPES.NULL_TERMINATED.STRING := 
	( 83,101,108,101, 99,116,105,111,110,  0);
      C_SELECTION_PTR : constant C_TYPES.CHAR_POINTER :=
                  C_TYPES.TO_CHAR_POINTER(C_SELECTION'ADDRESS);

    C_SENSITIVE                  : constant C_TYPES.NULL_TERMINATED.STRING := 
	( 83,101,110,115,105,116,105,118,101,  0);
      C_SENSITIVE_PTR : constant C_TYPES.CHAR_POINTER :=
                  C_TYPES.TO_CHAR_POINTER(C_SENSITIVE'ADDRESS);

    C_SELECTION_ARRAY             : constant C_TYPES.NULL_TERMINATED.STRING := 
	( 83,101,108,101, 99,116,105,111,110, 65,114,114, 97,121,  0);
  
            C_SELECTION_ARRAY_PTR : constant C_TYPES.CHAR_POINTER :=
                  C_TYPES.TO_CHAR_POINTER(C_SELECTION_ARRAY'ADDRESS);

    C_SPACE                      : constant C_TYPES.NULL_TERMINATED.STRING := 
	( 83,112, 97, 99,101,  0);
      C_SPACE_PTR : constant C_TYPES.CHAR_POINTER :=
                  C_TYPES.TO_CHAR_POINTER(C_SPACE'ADDRESS);

    C_STRING                     : constant C_TYPES.NULL_TERMINATED.STRING := 
	( 83,116,114,105,110,103,  0);
      C_STRING_PTR : constant C_TYPES.CHAR_POINTER :=
                  C_TYPES.TO_CHAR_POINTER(C_STRING'ADDRESS);

    C_TEXT_OPTIONS                : constant C_TYPES.NULL_TERMINATED.STRING := 
	(116,101,120,116, 79,112,116,105,111,110,115,  0);
  
            C_TEXT_OPTIONS_PTR : constant C_TYPES.CHAR_POINTER :=
                  C_TYPES.TO_CHAR_POINTER(C_TEXT_OPTIONS'ADDRESS);

    C_TEXT_POSITION               : constant C_TYPES.NULL_TERMINATED.STRING := 
	(116,101,120,116, 80,111,115,105,116,105,111,110,  0);
  
            C_TEXT_POSITION_PTR : constant C_TYPES.CHAR_POINTER :=
                  C_TYPES.TO_CHAR_POINTER(C_TEXT_POSITION'ADDRESS);

    C_TEXT_SINK                   : constant C_TYPES.NULL_TERMINATED.STRING := 
	(116,101,120,116, 83,105,110,107,  0);
      C_TEXT_SINK_PTR : constant C_TYPES.CHAR_POINTER :=
                  C_TYPES.TO_CHAR_POINTER(C_TEXT_SINK'ADDRESS);

    C_TEXT_SOURCE                 : constant C_TYPES.NULL_TERMINATED.STRING := 
	(116,101,120,116, 83,111,117,114, 99,101,  0);
  
            C_TEXT_SOURCE_PTR : constant C_TYPES.CHAR_POINTER :=
                  C_TYPES.TO_CHAR_POINTER(C_TEXT_SOURCE'ADDRESS);

    C_THICKNESS                  : constant C_TYPES.NULL_TERMINATED.STRING := 
	( 84,104,105, 99,107,110,101,115,115,  0);
      C_THICKNESS_PTR : constant C_TYPES.CHAR_POINTER :=
                  C_TYPES.TO_CHAR_POINTER(C_THICKNESS'ADDRESS);

    C_THUMB                      : constant C_TYPES.NULL_TERMINATED.STRING := 
	( 84,104,117,109, 98,  0);
      C_THUMB_PTR : constant C_TYPES.CHAR_POINTER :=
                  C_TYPES.TO_CHAR_POINTER(C_THUMB'ADDRESS);

    C_TRANSLATIONS               : constant C_TYPES.NULL_TERMINATED.STRING := 
	( 84,114, 97,110,115,108, 97,116,105,111,110,115,  0);
  
            C_TRANSLATIONS_PTR : constant C_TYPES.CHAR_POINTER :=
                  C_TYPES.TO_CHAR_POINTER(C_TRANSLATIONS'ADDRESS);

    C_VALUE                      : constant C_TYPES.NULL_TERMINATED.STRING := 
	( 86, 97,108,117,101,  0);
      C_VALUE_PTR : constant C_TYPES.CHAR_POINTER :=
                  C_TYPES.TO_CHAR_POINTER(C_VALUE'ADDRESS);

    C_V_SPACE                     : constant C_TYPES.NULL_TERMINATED.STRING := 
	( 86, 83,112, 97, 99,101,  0);
      C_V_SPACE_PTR : constant C_TYPES.CHAR_POINTER :=
                  C_TYPES.TO_CHAR_POINTER(C_V_SPACE'ADDRESS);

    C_WIDTH                      : constant C_TYPES.NULL_TERMINATED.STRING := 
	( 87,105,100,116,104,  0);
      C_WIDTH_PTR : constant C_TYPES.CHAR_POINTER :=
                  C_TYPES.TO_CHAR_POINTER(C_WIDTH'ADDRESS);

    C_WINDOW                     : constant C_TYPES.NULL_TERMINATED.STRING := 
	( 87,105,110,100,111,119,  0);
      C_WINDOW_PTR : constant C_TYPES.CHAR_POINTER :=
                  C_TYPES.TO_CHAR_POINTER(C_WINDOW'ADDRESS);

    C_X                          : constant C_TYPES.NULL_TERMINATED.STRING := 
	( 88,  0);
      C_X_PTR : constant C_TYPES.CHAR_POINTER :=
                  C_TYPES.TO_CHAR_POINTER(C_X'ADDRESS);

    C_Y                          : constant C_TYPES.NULL_TERMINATED.STRING := 
	( 89,  0);
      C_Y_PTR : constant C_TYPES.CHAR_POINTER :=
                  C_TYPES.TO_CHAR_POINTER(C_Y'ADDRESS);

    R_ACCELERATOR_TABLE           : constant C_TYPES.NULL_TERMINATED.STRING := 
	( 65, 99, 99,101,108,101,114, 97,116,111,114, 84, 97, 98,108,101,
	   0);
  
            R_ACCELERATOR_TABLE_PTR : constant C_TYPES.CHAR_POINTER :=
                  C_TYPES.TO_CHAR_POINTER(R_ACCELERATOR_TABLE'ADDRESS);

    R_BITMAP                     : constant C_TYPES.NULL_TERMINATED.STRING := 
	( 66,105,116,109, 97,112,  0);
      R_BITMAP_PTR : constant C_TYPES.CHAR_POINTER :=
                  C_TYPES.TO_CHAR_POINTER(R_BITMAP'ADDRESS);

    R_BOOL                       : constant C_TYPES.NULL_TERMINATED.STRING := 
	( 66,111,111,108,  0);
      R_BOOL_PTR : constant C_TYPES.CHAR_POINTER :=
                  C_TYPES.TO_CHAR_POINTER(R_BOOL'ADDRESS);

    R_BOOLEAN                    : constant C_TYPES.NULL_TERMINATED.STRING := 
	( 66,111,111,108,101, 97,110,  0);
      R_BOOLEAN_PTR : constant C_TYPES.CHAR_POINTER :=
                  C_TYPES.TO_CHAR_POINTER(R_BOOLEAN'ADDRESS);

    R_CALLBACK                   : constant C_TYPES.NULL_TERMINATED.STRING := 
	( 67, 97,108,108, 98, 97, 99,107,  0);
      R_CALLBACK_PTR : constant C_TYPES.CHAR_POINTER :=
                  C_TYPES.TO_CHAR_POINTER(R_CALLBACK'ADDRESS);

    R_CALL_PROC                   : constant C_TYPES.NULL_TERMINATED.STRING := 
	( 67, 97,108,108, 80,114,111, 99,  0);
      R_CALL_PROC_PTR : constant C_TYPES.CHAR_POINTER :=
                  C_TYPES.TO_CHAR_POINTER(R_CALL_PROC'ADDRESS);

    R_CARDINAL                   : constant C_TYPES.NULL_TERMINATED.STRING := 
	( 67, 97,114,100,105,110, 97,108,  0);
      R_CARDINAL_PTR : constant C_TYPES.CHAR_POINTER :=
                  C_TYPES.TO_CHAR_POINTER(R_CARDINAL'ADDRESS);

    R_COLOR                      : constant C_TYPES.NULL_TERMINATED.STRING := 
	( 67,111,108,111,114,  0);
      R_COLOR_PTR : constant C_TYPES.CHAR_POINTER :=
                  C_TYPES.TO_CHAR_POINTER(R_COLOR'ADDRESS);

    R_COLORMAP                   : constant C_TYPES.NULL_TERMINATED.STRING := 
	( 67,111,108,111,114,109, 97,112,  0);
      R_COLORMAP_PTR : constant C_TYPES.CHAR_POINTER :=
                  C_TYPES.TO_CHAR_POINTER(R_COLORMAP'ADDRESS);

    R_CURSOR                     : constant C_TYPES.NULL_TERMINATED.STRING := 
	( 67,117,114,115,111,114,  0);
      R_CURSOR_PTR : constant C_TYPES.CHAR_POINTER :=
                  C_TYPES.TO_CHAR_POINTER(R_CURSOR'ADDRESS);

    R_DIMENSION                  : constant C_TYPES.NULL_TERMINATED.STRING := 
	( 68,105,109,101,110,115,105,111,110,  0);
      R_DIMENSION_PTR : constant C_TYPES.CHAR_POINTER :=
                  C_TYPES.TO_CHAR_POINTER(R_DIMENSION'ADDRESS);

    R_DISPLAY                    : constant C_TYPES.NULL_TERMINATED.STRING := 
	( 68,105,115,112,108, 97,121,  0);
      R_DISPLAY_PTR : constant C_TYPES.CHAR_POINTER :=
                  C_TYPES.TO_CHAR_POINTER(R_DISPLAY'ADDRESS);

    R_EDIT_MODE                   : constant C_TYPES.NULL_TERMINATED.STRING := 
	( 69,100,105,116, 77,111,100,101,  0);
      R_EDIT_MODE_PTR : constant C_TYPES.CHAR_POINTER :=
                  C_TYPES.TO_CHAR_POINTER(R_EDIT_MODE'ADDRESS);

    R_ENUM                       : constant C_TYPES.NULL_TERMINATED.STRING := 
	( 69,110,117,109,  0);
      R_ENUM_PTR : constant C_TYPES.CHAR_POINTER :=
                  C_TYPES.TO_CHAR_POINTER(R_ENUM'ADDRESS);

    R_FILE                       : constant C_TYPES.NULL_TERMINATED.STRING := 
	( 70,105,108,101,  0);
      R_FILE_PTR : constant C_TYPES.CHAR_POINTER :=
                  C_TYPES.TO_CHAR_POINTER(R_FILE'ADDRESS);

    R_FLOAT                      : constant C_TYPES.NULL_TERMINATED.STRING := 
	( 70,108,111, 97,116,  0);
      R_FLOAT_PTR : constant C_TYPES.CHAR_POINTER :=
                  C_TYPES.TO_CHAR_POINTER(R_FLOAT'ADDRESS);

    R_FONT                       : constant C_TYPES.NULL_TERMINATED.STRING := 
	( 70,111,110,116,  0);
      R_FONT_PTR : constant C_TYPES.CHAR_POINTER :=
                  C_TYPES.TO_CHAR_POINTER(R_FONT'ADDRESS);

    R_FONT_STRUCT                 : constant C_TYPES.NULL_TERMINATED.STRING := 
	( 70,111,110,116, 83,116,114,117, 99,116,  0);
  
            R_FONT_STRUCT_PTR : constant C_TYPES.CHAR_POINTER :=
                  C_TYPES.TO_CHAR_POINTER(R_FONT_STRUCT'ADDRESS);

    R_FUNCTION                   : constant C_TYPES.NULL_TERMINATED.STRING := 
	( 70,117,110, 99,116,105,111,110,  0);
      R_FUNCTION_PTR : constant C_TYPES.CHAR_POINTER :=
                  C_TYPES.TO_CHAR_POINTER(R_FUNCTION'ADDRESS);

    R_GEOMETRY                   : constant C_TYPES.NULL_TERMINATED.STRING := 
	( 71,101,111,109,101,116,114,121,  0);
      R_GEOMETRY_PTR : constant C_TYPES.CHAR_POINTER :=
                  C_TYPES.TO_CHAR_POINTER(R_GEOMETRY'ADDRESS);

    R_IMMEDIATE                  : constant C_TYPES.NULL_TERMINATED.STRING := 
	( 73,109,109,101,100,105, 97,116,101,  0);
      R_IMMEDIATE_PTR : constant C_TYPES.CHAR_POINTER :=
                  C_TYPES.TO_CHAR_POINTER(R_IMMEDIATE'ADDRESS);

    R_INITIAL_STATE               : constant C_TYPES.NULL_TERMINATED.STRING := 
	( 73,110,105,116,105, 97,108, 83,116, 97,116,101,  0);
  
            R_INITIAL_STATE_PTR : constant C_TYPES.CHAR_POINTER :=
                  C_TYPES.TO_CHAR_POINTER(R_INITIAL_STATE'ADDRESS);

    R_INT                        : constant C_TYPES.NULL_TERMINATED.STRING := 
	( 73,110,116,  0);
      R_INT_PTR : constant C_TYPES.CHAR_POINTER :=
                  C_TYPES.TO_CHAR_POINTER(R_INT'ADDRESS);

    R_JUSTIFY                    : constant C_TYPES.NULL_TERMINATED.STRING := 
	( 74,117,115,116,105,102,121,  0);
      R_JUSTIFY_PTR : constant C_TYPES.CHAR_POINTER :=
                  C_TYPES.TO_CHAR_POINTER(R_JUSTIFY'ADDRESS);

    R_LONG_BOOLEAN                : constant C_TYPES.NULL_TERMINATED.STRING := 
	( 66,111,111,108,  0);
      R_LONG_BOOLEAN_PTR : constant C_TYPES.CHAR_POINTER :=
                  C_TYPES.TO_CHAR_POINTER(R_LONG_BOOLEAN'ADDRESS);

    R_ORIENTATION                : constant C_TYPES.NULL_TERMINATED.STRING := 
	( 79,114,105,101,110,116, 97,116,105,111,110,  0);
  
            R_ORIENTATION_PTR : constant C_TYPES.CHAR_POINTER :=
                  C_TYPES.TO_CHAR_POINTER(R_ORIENTATION'ADDRESS);

    R_PIXEL                      : constant C_TYPES.NULL_TERMINATED.STRING := 
	( 80,105,120,101,108,  0);
      R_PIXEL_PTR : constant C_TYPES.CHAR_POINTER :=
                  C_TYPES.TO_CHAR_POINTER(R_PIXEL'ADDRESS);

    R_PIXMAP                     : constant C_TYPES.NULL_TERMINATED.STRING := 
	(112,105,120,109, 97,112,  0);
      R_PIXMAP_PTR : constant C_TYPES.CHAR_POINTER :=
                  C_TYPES.TO_CHAR_POINTER(R_PIXMAP'ADDRESS);

    R_POINTER                    : constant C_TYPES.NULL_TERMINATED.STRING := 
	( 80,111,105,110,116,101,114,  0);
      R_POINTER_PTR : constant C_TYPES.CHAR_POINTER :=
                  C_TYPES.TO_CHAR_POINTER(R_POINTER'ADDRESS);

    R_POSITION                   : constant C_TYPES.NULL_TERMINATED.STRING := 
	( 80,111,115,105,116,105,111,110,  0);
      R_POSITION_PTR : constant C_TYPES.CHAR_POINTER :=
                  C_TYPES.TO_CHAR_POINTER(R_POSITION'ADDRESS);

    R_SCREEN                     : constant C_TYPES.NULL_TERMINATED.STRING := 
	( 83, 99,114,101,101,110,  0);
      R_SCREEN_PTR : constant C_TYPES.CHAR_POINTER :=
                  C_TYPES.TO_CHAR_POINTER(R_SCREEN'ADDRESS);

    R_SHORT                      : constant C_TYPES.NULL_TERMINATED.STRING := 
	( 83,104,111,114,116,  0);
      R_SHORT_PTR : constant C_TYPES.CHAR_POINTER :=
                  C_TYPES.TO_CHAR_POINTER(R_SHORT'ADDRESS);

    R_STRING                     : constant C_TYPES.NULL_TERMINATED.STRING := 
	( 83,116,114,105,110,103,  0);
      R_STRING_PTR : constant C_TYPES.CHAR_POINTER :=
                  C_TYPES.TO_CHAR_POINTER(R_STRING'ADDRESS);

    R_STRING_ARRAY                : constant C_TYPES.NULL_TERMINATED.STRING := 
	( 83,116,114,105,110,103, 65,114,114, 97,121,  0);
  
            R_STRING_ARRAY_PTR : constant C_TYPES.CHAR_POINTER :=
                  C_TYPES.TO_CHAR_POINTER(R_STRING_ARRAY'ADDRESS);

    R_STRING_TABLE                : constant C_TYPES.NULL_TERMINATED.STRING := 
	( 83,116,114,105,110,103, 84, 97, 98,108,101,  0);
  
            R_STRING_TABLE_PTR : constant C_TYPES.CHAR_POINTER :=
                  C_TYPES.TO_CHAR_POINTER(R_STRING_TABLE'ADDRESS);

    R_UNSIGNED_CHAR               : constant C_TYPES.NULL_TERMINATED.STRING := 
	( 85,110,115,105,103,110,101,100, 67,104, 97,114,  0);
  
            R_UNSIGNED_CHAR_PTR : constant C_TYPES.CHAR_POINTER :=
                  C_TYPES.TO_CHAR_POINTER(R_UNSIGNED_CHAR'ADDRESS);

    R_TRANSLATION_TABLE           : constant C_TYPES.NULL_TERMINATED.STRING := 
	( 84,114, 97,110,115,108, 97,116,105,111,110, 84, 97, 98,108,101,
	   0);
  
            R_TRANSLATION_TABLE_PTR : constant C_TYPES.CHAR_POINTER :=
                  C_TYPES.TO_CHAR_POINTER(R_TRANSLATION_TABLE'ADDRESS);

    R_VISUAL                     : constant C_TYPES.NULL_TERMINATED.STRING := 
	( 86,105,115,117, 97,108,  0);
      R_VISUAL_PTR : constant C_TYPES.CHAR_POINTER :=
                  C_TYPES.TO_CHAR_POINTER(R_VISUAL'ADDRESS);

    R_WIDGET                     : constant C_TYPES.NULL_TERMINATED.STRING := 
	( 87,105,100,103,101,116,  0);
      R_WIDGET_PTR : constant C_TYPES.CHAR_POINTER :=
                  C_TYPES.TO_CHAR_POINTER(R_WIDGET'ADDRESS);

    R_WIDGET_CLASS                : constant C_TYPES.NULL_TERMINATED.STRING := 
	( 87,105,100,103,101,116, 67,108, 97,115,115,  0);
  
            R_WIDGET_CLASS_PTR : constant C_TYPES.CHAR_POINTER :=
                  C_TYPES.TO_CHAR_POINTER(R_WIDGET_CLASS'ADDRESS);

    R_WIDGET_LIST                 : constant C_TYPES.NULL_TERMINATED.STRING := 
	( 87,105,100,103,101,116, 76,105,115,116,  0);
  
            R_WIDGET_LIST_PTR : constant C_TYPES.CHAR_POINTER :=
                  C_TYPES.TO_CHAR_POINTER(R_WIDGET_LIST'ADDRESS);

    R_WINDOW                     : constant C_TYPES.NULL_TERMINATED.STRING := 
	( 87,105,110,100,111,119,  0);
      R_WINDOW_PTR : constant C_TYPES.CHAR_POINTER :=
                  C_TYPES.TO_CHAR_POINTER(R_WINDOW'ADDRESS);

    EOFF                        : constant C_TYPES.NULL_TERMINATED.STRING := 
	(111,102,102,  0);
      EOFF_PTR : constant C_TYPES.CHAR_POINTER :=
                  C_TYPES.TO_CHAR_POINTER(EOFF'ADDRESS);

    EFALSE                      : constant C_TYPES.NULL_TERMINATED.STRING := 
	(102, 97,108,115,101,  0);
      EFALSE_PTR : constant C_TYPES.CHAR_POINTER :=
                  C_TYPES.TO_CHAR_POINTER(EFALSE'ADDRESS);

    ENO                         : constant C_TYPES.NULL_TERMINATED.STRING := 
	(110,111,  0);
      ENO_PTR : constant C_TYPES.CHAR_POINTER :=
                  C_TYPES.TO_CHAR_POINTER(ENO'ADDRESS);

    EON                         : constant C_TYPES.NULL_TERMINATED.STRING := 
	(111,110,  0);
      EON_PTR : constant C_TYPES.CHAR_POINTER :=
                  C_TYPES.TO_CHAR_POINTER(EON'ADDRESS);

    ETRUE                       : constant C_TYPES.NULL_TERMINATED.STRING := 
	(116,114,117,101,  0);
      ETRUE_PTR : constant C_TYPES.CHAR_POINTER :=
                  C_TYPES.TO_CHAR_POINTER(ETRUE'ADDRESS);

    EYES                        : constant C_TYPES.NULL_TERMINATED.STRING := 
	(121,101,115,  0);
      EYES_PTR : constant C_TYPES.CHAR_POINTER :=
                  C_TYPES.TO_CHAR_POINTER(EYES'ADDRESS);

    EVERTICAL                   : constant C_TYPES.NULL_TERMINATED.STRING := 
	(118,101,114,116,105, 99, 97,108,  0);
      EVERTICAL_PTR : constant C_TYPES.CHAR_POINTER :=
                  C_TYPES.TO_CHAR_POINTER(EVERTICAL'ADDRESS);

    EHORIZONTAL                 : constant C_TYPES.NULL_TERMINATED.STRING := 
	(104,111,114,105,122,111,110,116, 97,108,  0);
  
            EHORIZONTAL_PTR : constant C_TYPES.CHAR_POINTER :=
                  C_TYPES.TO_CHAR_POINTER(EHORIZONTAL'ADDRESS);

    ETEXT_READ                   : constant C_TYPES.NULL_TERMINATED.STRING := 
	(114,101, 97,100,  0);
      ETEXT_READ_PTR : constant C_TYPES.CHAR_POINTER :=
                  C_TYPES.TO_CHAR_POINTER(ETEXT_READ'ADDRESS);

    ETEXT_APPEND                 : constant C_TYPES.NULL_TERMINATED.STRING := 
	( 97,112,112,101,110,100,  0);
      ETEXT_APPEND_PTR : constant C_TYPES.CHAR_POINTER :=
                  C_TYPES.TO_CHAR_POINTER(ETEXT_APPEND'ADDRESS);

    ETEXT_EDIT                   : constant C_TYPES.NULL_TERMINATED.STRING := 
	(101,100,105,116,  0);
      ETEXT_EDIT_PTR : constant C_TYPES.CHAR_POINTER :=
                  C_TYPES.TO_CHAR_POINTER(ETEXT_EDIT'ADDRESS);

    EXTDEFAULTBACKGROUND        : constant C_TYPES.NULL_TERMINATED.STRING := 
	( 88,116,100,101,102, 97,117,108,116, 98, 97, 99,107,103,114,111,
	 117,110,100,  0);
  
            EXTDEFAULTBACKGROUND_PTR : constant C_TYPES.CHAR_POINTER :=
                  C_TYPES.TO_CHAR_POINTER(EXTDEFAULTBACKGROUND'ADDRESS);

    EXTDEFAULTFOREGROUND        : constant C_TYPES.NULL_TERMINATED.STRING := 
	( 88,116,100,101,102, 97,117,108,116,102,111,114,101,103,114,111,
	 117,110,100,  0);
  
            EXTDEFAULTFOREGROUND_PTR : constant C_TYPES.CHAR_POINTER :=
                  C_TYPES.TO_CHAR_POINTER(EXTDEFAULTFOREGROUND'ADDRESS);

    EXTDEFAULTFONT              : constant C_TYPES.NULL_TERMINATED.STRING := 
	( 88,116,100,101,102, 97,117,108,116,102,111,110,116,  0);
  
            EXTDEFAULTFONT_PTR : constant C_TYPES.CHAR_POINTER :=
                  C_TYPES.TO_CHAR_POINTER(EXTDEFAULTFONT'ADDRESS);

    NICONIFY_PIXMAP              : constant C_TYPES.NULL_TERMINATED.STRING := 
	(105, 99,111,110,105,102,121,112,105,120,109, 97,112,  0);
  
            NICONIFY_PIXMAP_PTR : constant C_TYPES.CHAR_POINTER :=
                  C_TYPES.TO_CHAR_POINTER(NICONIFY_PIXMAP'ADDRESS);

    C_ICONIFY_PIXMAP              : constant C_TYPES.NULL_TERMINATED.STRING := 
	( 73, 99,111,110,105,102,121,112,105,120,109, 97,112,  0);
  
            C_ICONIFY_PIXMAP_PTR : constant C_TYPES.CHAR_POINTER :=
                  C_TYPES.TO_CHAR_POINTER(C_ICONIFY_PIXMAP'ADDRESS);

    NICON_BOX_X                   : constant C_TYPES.NULL_TERMINATED.STRING := 
	(105, 99,111,110, 66,111,120, 88,  0);
      NICON_BOX_X_PTR : constant C_TYPES.CHAR_POINTER :=
                  C_TYPES.TO_CHAR_POINTER(NICON_BOX_X'ADDRESS);

    C_ICON_BOX_X                   : constant C_TYPES.NULL_TERMINATED.STRING := 
	( 73, 99,111,110, 66,111,120, 88,  0);
      C_ICON_BOX_X_PTR : constant C_TYPES.CHAR_POINTER :=
                  C_TYPES.TO_CHAR_POINTER(C_ICON_BOX_X'ADDRESS);

    NICON_BOX_Y                   : constant C_TYPES.NULL_TERMINATED.STRING := 
	(105, 99,111,110, 66,111,120, 89,  0);
      NICON_BOX_Y_PTR : constant C_TYPES.CHAR_POINTER :=
                  C_TYPES.TO_CHAR_POINTER(NICON_BOX_Y'ADDRESS);

    C_ICON_BOX_Y                   : constant C_TYPES.NULL_TERMINATED.STRING := 
	( 73, 99,111,110, 66,111,120, 89,  0);
      C_ICON_BOX_Y_PTR : constant C_TYPES.CHAR_POINTER :=
                  C_TYPES.TO_CHAR_POINTER(C_ICON_BOX_Y'ADDRESS);

    NTILED                      : constant C_TYPES.NULL_TERMINATED.STRING := 
	(116,105,108,101,100,  0);
      NTILED_PTR : constant C_TYPES.CHAR_POINTER :=
                  C_TYPES.TO_CHAR_POINTER(NTILED'ADDRESS);

    C_TILED                      : constant C_TYPES.NULL_TERMINATED.STRING := 
	( 84,105,108,101,100,  0);
      C_TILED_PTR : constant C_TYPES.CHAR_POINTER :=
                  C_TYPES.TO_CHAR_POINTER(C_TILED'ADDRESS);

    NSTICKY                     : constant C_TYPES.NULL_TERMINATED.STRING := 
	(115,116,105, 99,107,121,  0);
      NSTICKY_PTR : constant C_TYPES.CHAR_POINTER :=
                  C_TYPES.TO_CHAR_POINTER(NSTICKY'ADDRESS);

    C_STICKY                     : constant C_TYPES.NULL_TERMINATED.STRING := 
	( 83,116,105, 99,107,121,  0);
      C_STICKY_PTR : constant C_TYPES.CHAR_POINTER :=
                  C_TYPES.TO_CHAR_POINTER(C_STICKY'ADDRESS);

    NNO_ICONIFY                  : constant C_TYPES.NULL_TERMINATED.STRING := 
	(110,111, 73, 99,111,110,105,102,121,  0);
      NNO_ICONIFY_PTR : constant C_TYPES.CHAR_POINTER :=
                  C_TYPES.TO_CHAR_POINTER(NNO_ICONIFY'ADDRESS);

    C_NO_ICONIFY                  : constant C_TYPES.NULL_TERMINATED.STRING := 
	( 78,111, 73, 99,111,110,105,102,121,  0);
      C_NO_ICONIFY_PTR : constant C_TYPES.CHAR_POINTER :=
                  C_TYPES.TO_CHAR_POINTER(C_NO_ICONIFY'ADDRESS);

    NNO_LOWER                    : constant C_TYPES.NULL_TERMINATED.STRING := 
	(110,111, 76,111,119,101,114,  0);
      NNO_LOWER_PTR : constant C_TYPES.CHAR_POINTER :=
                  C_TYPES.TO_CHAR_POINTER(NNO_LOWER'ADDRESS);

    C_NO_LOWER                    : constant C_TYPES.NULL_TERMINATED.STRING := 
	( 78,111, 76,111,119,101,114,  0);
      C_NO_LOWER_PTR : constant C_TYPES.CHAR_POINTER :=
                  C_TYPES.TO_CHAR_POINTER(C_NO_LOWER'ADDRESS);

    NNO_RESIZE                   : constant C_TYPES.NULL_TERMINATED.STRING := 
	(110,111, 82,101,115,105,122,101,  0);
      NNO_RESIZE_PTR : constant C_TYPES.CHAR_POINTER :=
                  C_TYPES.TO_CHAR_POINTER(NNO_RESIZE'ADDRESS);

    C_NO_RESIZE                   : constant C_TYPES.NULL_TERMINATED.STRING := 
	( 78,111, 82,101,115,105,122,101,  0);
      C_NO_RESIZE_PTR : constant C_TYPES.CHAR_POINTER :=
                  C_TYPES.TO_CHAR_POINTER(C_NO_RESIZE'ADDRESS);

    NICON_BOX                    : constant C_TYPES.NULL_TERMINATED.STRING := 
	(105, 99,111,110, 66,111,120,  0);
      NICON_BOX_PTR : constant C_TYPES.CHAR_POINTER :=
                  C_TYPES.TO_CHAR_POINTER(NICON_BOX'ADDRESS);

    C_ICON_BOX                    : constant C_TYPES.NULL_TERMINATED.STRING := 
	( 73, 99,111,110, 66,111,120,  0);
      C_ICON_BOX_PTR : constant C_TYPES.CHAR_POINTER :=
                  C_TYPES.TO_CHAR_POINTER(C_ICON_BOX'ADDRESS);

    NCOPYRIGHT                  : constant C_TYPES.NULL_TERMINATED.STRING := 
	( 99,111,112,121,114,105,103,104,116,  0);
      NCOPYRIGHT_PTR : constant C_TYPES.CHAR_POINTER :=
                  C_TYPES.TO_CHAR_POINTER(NCOPYRIGHT'ADDRESS);

    C_COPYRIGHT                  : constant C_TYPES.NULL_TERMINATED.STRING := 
	( 67,111,112,121,114,105,103,104,116,  0);
      C_COPYRIGHT_PTR : constant C_TYPES.CHAR_POINTER :=
                  C_TYPES.TO_CHAR_POINTER(C_COPYRIGHT'ADDRESS);

    NCOPYRIGHT_NOTICE            : constant C_TYPES.NULL_TERMINATED.STRING := 
	( 99,111,112,121,114,105,103,104,116, 78,111,116,105, 99,101,  0);
  
            NCOPYRIGHT_NOTICE_PTR : constant C_TYPES.CHAR_POINTER :=
                  C_TYPES.TO_CHAR_POINTER(NCOPYRIGHT_NOTICE'ADDRESS);

    C_COPYRIGHT_NOTICE            : constant C_TYPES.NULL_TERMINATED.STRING := 
	( 67,111,112,121,114,105,103,104,116, 78,111,116,105, 99,101,  0);
  
            C_COPYRIGHT_NOTICE_PTR : constant C_TYPES.CHAR_POINTER :=
                  C_TYPES.TO_CHAR_POINTER(C_COPYRIGHT_NOTICE'ADDRESS);

    NCOPYRIGHT_MESSAGE           : constant C_TYPES.NULL_TERMINATED.STRING := 
	( 99,111,112,121,114,105,103,104,116, 77,101,115,115, 97,103,101,
	   0);
  
            NCOPYRIGHT_MESSAGE_PTR : constant C_TYPES.CHAR_POINTER :=
                  C_TYPES.TO_CHAR_POINTER(NCOPYRIGHT_MESSAGE'ADDRESS);

    C_COPYRIGHT_MESSAGE           : constant C_TYPES.NULL_TERMINATED.STRING := 
	( 67,111,112,121,114,105,103,104,116, 77,101,115,115, 97,103,101,
	   0);
  
            C_COPYRIGHT_MESSAGE_PTR : constant C_TYPES.CHAR_POINTER :=
                  C_TYPES.TO_CHAR_POINTER(C_COPYRIGHT_MESSAGE'ADDRESS);

    NCOPYRIGHT_FONT              : constant C_TYPES.NULL_TERMINATED.STRING := 
	( 99,111,112,121,114,105,103,104,116, 70,111,110,116,  0);
  
            NCOPYRIGHT_FONT_PTR : constant C_TYPES.CHAR_POINTER :=
                  C_TYPES.TO_CHAR_POINTER(NCOPYRIGHT_FONT'ADDRESS);

    NCOPYRIGHT_FOREGROUND        : constant C_TYPES.NULL_TERMINATED.STRING := 
	( 99,111,112,121,114,105,103,104,116, 70,111,114,101,103,114,111,
	 117,110,100,  0);
  
            NCOPYRIGHT_FOREGROUND_PTR : constant C_TYPES.CHAR_POINTER :=
                  C_TYPES.TO_CHAR_POINTER(NCOPYRIGHT_FOREGROUND'ADDRESS);

    NCOPYRIGHT_BACKGROUND        : constant C_TYPES.NULL_TERMINATED.STRING := 
	( 99,111,112,121,114,105,103,104,116, 66, 97, 99,107,103,114,111,
	 117,110,100,  0);
  
            NCOPYRIGHT_BACKGROUND_PTR : constant C_TYPES.CHAR_POINTER :=
                  C_TYPES.TO_CHAR_POINTER(NCOPYRIGHT_BACKGROUND'ADDRESS);

    NCOPYRIGHT_BORDER_COLOR       : constant C_TYPES.NULL_TERMINATED.STRING := 
	( 99,111,112,121,114,105,103,104,116, 66,111,114,100,101,114, 67,
	 111,108,111,114,  0);

             NCOPYRIGHT_BORDER_COLOR_PTR : constant C_TYPES.CHAR_POINTER :=
                  C_TYPES.TO_CHAR_POINTER(NCOPYRIGHT_BORDER_COLOR'ADDRESS);

    NCOPYRIGHT_BORDER_WIDTH       : constant C_TYPES.NULL_TERMINATED.STRING := 
	( 99,111,112,121,114,105,103,104,116, 66,111,114,100,101,114, 87,
	 105,100,116,104,  0);

             NCOPYRIGHT_BORDER_WIDTH_PTR : constant C_TYPES.CHAR_POINTER :=
                  C_TYPES.TO_CHAR_POINTER(NCOPYRIGHT_BORDER_WIDTH'ADDRESS);

    C_COPYRIGHT_BORDER_WIDTH       : constant C_TYPES.NULL_TERMINATED.STRING := 
	( 67,111,112,121,114,105,103,104,116, 66,111,114,100,101,114, 87,
	 105,100,116,104,  0);

             C_COPYRIGHT_BORDER_WIDTH_PTR : constant C_TYPES.CHAR_POINTER :=
                  C_TYPES.TO_CHAR_POINTER(C_COPYRIGHT_BORDER_WIDTH'ADDRESS);

    NCOPYRIGHT_MIN_TIME           : constant C_TYPES.NULL_TERMINATED.STRING := 
	( 99,111,112,121,114,105,103,104,116, 77,105,110, 84,105,109,101,
	   0);
  
            NCOPYRIGHT_MIN_TIME_PTR : constant C_TYPES.CHAR_POINTER :=
                  C_TYPES.TO_CHAR_POINTER(NCOPYRIGHT_MIN_TIME'ADDRESS);

    C_COPYRIGHT_MIN_TIME           : constant C_TYPES.NULL_TERMINATED.STRING := 
	( 99,111,112,121,114,105,103,104,116, 77,105,110, 84,105,109,101,
	   0);
  
            C_COPYRIGHT_MIN_TIME_PTR : constant C_TYPES.CHAR_POINTER :=
                  C_TYPES.TO_CHAR_POINTER(C_COPYRIGHT_MIN_TIME'ADDRESS);

    NCOPYRIGHT_MAX_TIME           : constant C_TYPES.NULL_TERMINATED.STRING := 
	( 99,111,112,121,114,105,103,104,116, 77, 97, 88,116,105,109,101,
	   0);
  
            NCOPYRIGHT_MAX_TIME_PTR : constant C_TYPES.CHAR_POINTER :=
                  C_TYPES.TO_CHAR_POINTER(NCOPYRIGHT_MAX_TIME'ADDRESS);

    C_COPYRIGHT_MAX_TIME           : constant C_TYPES.NULL_TERMINATED.STRING := 
	( 99,111,112,121,114,105,103,104,116, 77, 97, 88,116,105,109,101,
	   0);
  
            C_COPYRIGHT_MAX_TIME_PTR : constant C_TYPES.CHAR_POINTER :=
                  C_TYPES.TO_CHAR_POINTER(C_COPYRIGHT_MAX_TIME'ADDRESS);

    NDEC_WM_VALUE_MASK             : constant C_TYPES.NULL_TERMINATED.STRING := 
	(100,101, 99, 87,109, 86, 97,108,117,101, 77, 97,115,107,  0);
  
            NDEC_WM_VALUE_MASK_PTR : constant C_TYPES.CHAR_POINTER :=
                  C_TYPES.TO_CHAR_POINTER(NDEC_WM_VALUE_MASK'ADDRESS);

    C_DEC_WM_VALUE_MASK             : constant C_TYPES.NULL_TERMINATED.STRING := 
	( 68,101, 99, 87,109, 86, 97,108,117,101, 77, 97,115,107,  0);
  
            C_DEC_WM_VALUE_MASK_PTR : constant C_TYPES.CHAR_POINTER :=
                  C_TYPES.TO_CHAR_POINTER(C_DEC_WM_VALUE_MASK'ADDRESS);

    NTITLE_FONT                  : constant C_TYPES.NULL_TERMINATED.STRING := 
	(116,105,116,108,101, 70,111,110,116,  0);
      NTITLE_FONT_PTR : constant C_TYPES.CHAR_POINTER :=
                  C_TYPES.TO_CHAR_POINTER(NTITLE_FONT'ADDRESS);

    C_TITLE_FONT                  : constant C_TYPES.NULL_TERMINATED.STRING := 
	( 84,105,116,108,101, 70,111,110,116,  0);
      C_TITLE_FONT_PTR : constant C_TYPES.CHAR_POINTER :=
                  C_TYPES.TO_CHAR_POINTER(C_TITLE_FONT'ADDRESS);

    NICON_FONT                   : constant C_TYPES.NULL_TERMINATED.STRING := 
	(105, 99,111,110, 70,111,110,116,  0);
      NICON_FONT_PTR : constant C_TYPES.CHAR_POINTER :=
                  C_TYPES.TO_CHAR_POINTER(NICON_FONT'ADDRESS);

    C_ICON_FONT                   : constant C_TYPES.NULL_TERMINATED.STRING := 
	( 73, 99,111,110, 70,111,110,116,  0);
      C_ICON_FONT_PTR : constant C_TYPES.CHAR_POINTER :=
                  C_TYPES.TO_CHAR_POINTER(C_ICON_FONT'ADDRESS);

    NTITLE_HEIGHT                : constant C_TYPES.NULL_TERMINATED.STRING := 
	(116,105,116,108,101, 72,101,105,103,104,116,  0);
  
            NTITLE_HEIGHT_PTR : constant C_TYPES.CHAR_POINTER :=
                  C_TYPES.TO_CHAR_POINTER(NTITLE_HEIGHT'ADDRESS);

    C_TITLE_HEIGHT                : constant C_TYPES.NULL_TERMINATED.STRING := 
	( 84,105,116,108,101, 72,101,105,103,104,116,  0);
  
            C_TITLE_HEIGHT_PTR : constant C_TYPES.CHAR_POINTER :=
                  C_TYPES.TO_CHAR_POINTER(C_TITLE_HEIGHT'ADDRESS);

    NNON_TITLE_WIDTH              : constant C_TYPES.NULL_TERMINATED.STRING := 
	(110,111,110, 84,105,116,108,101, 87,105,100,116,104,  0);
  
            NNON_TITLE_WIDTH_PTR : constant C_TYPES.CHAR_POINTER :=
                  C_TYPES.TO_CHAR_POINTER(NNON_TITLE_WIDTH'ADDRESS);

    C_NON_TITLE_WIDTH              : constant C_TYPES.NULL_TERMINATED.STRING := 
	( 78,111,110, 84,105,116,108,101, 87,105,100,116,104,  0);
  
            C_NON_TITLE_WIDTH_PTR : constant C_TYPES.CHAR_POINTER :=
                  C_TYPES.TO_CHAR_POINTER(C_NON_TITLE_WIDTH'ADDRESS);

    NICON_NAME_WIDTH              : constant C_TYPES.NULL_TERMINATED.STRING := 
	(105, 99,111,110, 78, 97,109,101, 87,105,100,116,104,  0);
  
            NICON_NAME_WIDTH_PTR : constant C_TYPES.CHAR_POINTER :=
                  C_TYPES.TO_CHAR_POINTER(NICON_NAME_WIDTH'ADDRESS);

    C_ICON_NAME_WIDTH              : constant C_TYPES.NULL_TERMINATED.STRING := 
	( 73, 99,111,110, 78, 97,109,101, 87,105,100,116,104,  0);
  
            C_ICON_NAME_WIDTH_PTR : constant C_TYPES.CHAR_POINTER :=
                  C_TYPES.TO_CHAR_POINTER(C_ICON_NAME_WIDTH'ADDRESS);

    NICONIFY_WIDTH               : constant C_TYPES.NULL_TERMINATED.STRING := 
	(105, 99,111,110,105,102,121, 87,105,100,116,104,  0);
  
            NICONIFY_WIDTH_PTR : constant C_TYPES.CHAR_POINTER :=
                  C_TYPES.TO_CHAR_POINTER(NICONIFY_WIDTH'ADDRESS);

    C_ICONIFY_WIDTH               : constant C_TYPES.NULL_TERMINATED.STRING := 
	( 73, 99,111,110,105,102,121, 87,105,100,116,104,  0);
  
            C_ICONIFY_WIDTH_PTR : constant C_TYPES.CHAR_POINTER :=
                  C_TYPES.TO_CHAR_POINTER(C_ICONIFY_WIDTH'ADDRESS);

    NICONIFY_HEIGHT              : constant C_TYPES.NULL_TERMINATED.STRING := 
	(105, 99,111,110,105,102,121, 72,101,105,103,104,116,  0);
  
            NICONIFY_HEIGHT_PTR : constant C_TYPES.CHAR_POINTER :=
                  C_TYPES.TO_CHAR_POINTER(NICONIFY_HEIGHT'ADDRESS);

    C_ICONIFY_HEIGHT              : constant C_TYPES.NULL_TERMINATED.STRING := 
	( 73, 99,111,110,105,102,121, 72,101,105,103,104,116,  0);
  
            C_ICONIFY_HEIGHT_PTR : constant C_TYPES.CHAR_POINTER :=
                  C_TYPES.TO_CHAR_POINTER(C_ICONIFY_HEIGHT'ADDRESS);

    NICON_STATE                  : constant C_TYPES.NULL_TERMINATED.STRING := 
	(105, 99,111,110, 83,116, 97,116,101,  0);
      NICON_STATE_PTR : constant C_TYPES.CHAR_POINTER :=
                  C_TYPES.TO_CHAR_POINTER(NICON_STATE'ADDRESS);

    C_ICON_STATE                  : constant C_TYPES.NULL_TERMINATED.STRING := 
	( 73, 99,111,110, 83,116, 97,116,101,  0);
      C_ICON_STATE_PTR : constant C_TYPES.CHAR_POINTER :=
                  C_TYPES.TO_CHAR_POINTER(C_ICON_STATE'ADDRESS);


    XTNKEYBOARDFOCUSPOLICY        : constant C_TYPES.NULL_TERMINATED.STRING := 
	(107,101,121, 98,111, 97,114,100, 70,111, 99,117,115, 80,111,108,
	 105, 99,121,  0);
  
            XTNKEYBOARDFOCUSPOLICY_PTR : constant C_TYPES.CHAR_POINTER :=
                  C_TYPES.TO_CHAR_POINTER(XTNKEYBOARDFOCUSPOLICY'ADDRESS);

    XTCKEYBOARDFOCUSPOLICY        : constant C_TYPES.NULL_TERMINATED.STRING := 
	( 75,101,121, 98,111, 97,114,100, 70,111, 99,117,115, 80,111,108,
	 105, 99,121,  0);
  
            XTCKEYBOARDFOCUSPOLICY_PTR : constant C_TYPES.CHAR_POINTER :=
                  C_TYPES.TO_CHAR_POINTER(XTCKEYBOARDFOCUSPOLICY'ADDRESS);

    XTRKEYBOARDFOCUSPOLICY        : constant C_TYPES.NULL_TERMINATED.STRING := 
	( 75,101,121, 98,111, 97,114,100, 70,111, 99,117,115, 80,111,108,
	 105, 99,121,  0);
  
            XTRKEYBOARDFOCUSPOLICY_PTR : constant C_TYPES.CHAR_POINTER :=
                  C_TYPES.TO_CHAR_POINTER(XTRKEYBOARDFOCUSPOLICY'ADDRESS);

    XTNSHELLUNITTYPE              : constant C_TYPES.NULL_TERMINATED.STRING := 
	(115,104,101,108,108, 85,110,105,116, 84,121,112,101,  0);
  
            XTNSHELLUNITTYPE_PTR : constant C_TYPES.CHAR_POINTER :=
                  C_TYPES.TO_CHAR_POINTER(XTNSHELLUNITTYPE'ADDRESS);

    XTCSHELLUNITTYPE              : constant C_TYPES.NULL_TERMINATED.STRING := 
	( 83,104,101,108,108, 85,110,105,116, 84,121,112,101,  0);
  
            XTCSHELLUNITTYPE_PTR : constant C_TYPES.CHAR_POINTER :=
                  C_TYPES.TO_CHAR_POINTER(XTCSHELLUNITTYPE'ADDRESS);

    XTRSHELLUNITTYPE              : constant C_TYPES.NULL_TERMINATED.STRING := 
	( 83,104,101,108,108, 85,110,105,116, 84,121,112,101,  0);
  
            XTRSHELLUNITTYPE_PTR : constant C_TYPES.CHAR_POINTER :=
                  C_TYPES.TO_CHAR_POINTER(XTRSHELLUNITTYPE'ADDRESS);


    NDESTROY_CALLBACK            : constant C_TYPES.NULL_TERMINATED.STRING := 
	(100,101,115,116,114,111,121, 67, 97,108,108, 98, 97, 99,107,  0);
  
            NDESTROY_CALLBACK_PTR : constant C_TYPES.CHAR_POINTER :=
                  C_TYPES.TO_CHAR_POINTER(NDESTROY_CALLBACK'ADDRESS);

    NPOPUP_CALLBACK              : constant C_TYPES.NULL_TERMINATED.STRING := 
	(112,111,112,117,112, 67, 97,108,108, 98, 97, 99,107,  0);
  
            NPOPUP_CALLBACK_PTR : constant C_TYPES.CHAR_POINTER :=
                  C_TYPES.TO_CHAR_POINTER(NPOPUP_CALLBACK'ADDRESS);

    NPOPDOWN_CALLBACK            : constant C_TYPES.NULL_TERMINATED.STRING := 
	(112,111,112,100,111,119,110, 67, 97,108,108, 98, 97, 99,107,  0);
  
            NPOPDOWN_CALLBACK_PTR : constant C_TYPES.CHAR_POINTER :=
                  C_TYPES.TO_CHAR_POINTER(NPOPDOWN_CALLBACK'ADDRESS);

    NUNREALIZE_CALLBACK          : constant C_TYPES.NULL_TERMINATED.STRING := 
	(110,114,101, 97,108,105,122,101, 67, 97,108,108, 98, 97, 99,107,
	   0);
  
            NUNREALIZE_CALLBACK_PTR : constant C_TYPES.CHAR_POINTER :=
                  C_TYPES.TO_CHAR_POINTER(NUNREALIZE_CALLBACK'ADDRESS);


  
end XT_STRING;
