-- Copyright (c),  Digital Equipment Corporation, 1992, 1993, 1994.
-- Redistribution and use in source and binary forms are permitted
-- provided that the copyright notice as indicated in box below and
-- this paragraph are duplicated in all such forms and that any documentation,
-- advertising materials, and other materials related to such distribution
-- and use acknowledge that the software was developed by Digital Equipment
-- Corporation.  The name of Digital Equipment Corporation may not be used to
-- endorse or promote products derived from this software without the specific
-- prior written permission.
--
-- All other rights reserved.
--
-- THIS SOFTWARE IS PROVIDED ''AS IS'' AND WITHOUT ANY EXPRESS OR IMPLIED
-- WARRANTIES, INCLUDING, WITHOUT LIMITATION, IMPLIED WARRANTIES OF
-- NON-INFRINGEMENT, MERCHANTABILITY OR FITNESS FOR A PARTICULAR PURPOSE.
-- Digital assumes no responsibility AT ALL for the use or reliability
-- of this software.
--
-- +------------------------------------------------------------------------+
-- | USE, DUPLICATION OR DISCLOSURE BY THE U.S. GOVERNMENT IS SUBJECT TO    |
-- | RESTRICTIONS AS SET FORTH IN SUBPARAGRAPH (c) (1) (ii) OF              |
-- | DFARS 252.227-7013, OR IN FAR 52.227-14 ALT. II, AS APPLICABLE.        |
-- |                                                                        |
-- +------------------------------------------------------------------------+
--
-- A great deal has been published concerning graphic bindings,
-- including, for example:
--
--                      Implementation of the Core Graphics System GKS
--                      in a Distributed Graphics Environment
--                      Proc. Int. Conf. Interactive Techniques in CAD,
--                      Bologna (1978), 249-254.
--
--                      Constructing User Interfaces based on Logical
--                      Input Devices.
--                      IEEE, Computers (Nov 82), 62-68.
--
--                      GKS in C.
--                      Proc. Eurographics '82,
--                      North-Holland (1982) 359-370.
--
--                      Computer Graphics Programming
--                      G. Enderle, K. Kansy, G. Pfaff
--                      Springer-Verlag
--                      Berlin, Heidelberg, New York
--                      1984
--

with X_FOREIGN_BODIES;

package body X_ATOM is

    subtype LEN_RANGE is NATURAL range 0..19;
    type STR(LEN : LEN_RANGE := 0) is
	record
	    TXT : STANDARD.STRING(1..LEN);
	end record;

    TO_STRING_TABLE : constant array(0..68) of STR := (

	0 => ( 4, "NONE"),

	1 => ( 7, "PRIMARY"),
	2 => ( 9, "SECONDARY"),
	3 => ( 3, "ARC"),
	4 => ( 4, "ATOM"),
	5 => ( 6, "BITMAP"),
	6 => ( 8, "CARDINAL"),
	7 => ( 8, "COLORMAP"),
	8 => ( 6, "CURSOR"),
	9 =>  (11, "CUT_BUFFER0"),
	10 => (11, "CUT_BUFFER1"),
	11 => (11, "CUT_BUFFER2"),
	12 => (11, "CUT_BUFFER3"),
	13 => (11, "CUT_BUFFER4"),
	14 => (11, "CUT_BUFFER5"),
	15 => (11, "CUT_BUFFER6"),
	16 => (11, "CUT_BUFFER7"),
	17 => ( 8, "DRAWABLE"),
	18 => ( 4, "FONT"),
	19 => ( 7, "INTEGER"),
	20 => ( 6, "PIXMAP"),
	21 => ( 5, "POINT"),
	22 => ( 9, "RECTANGLE"),
	23 => (16, "RESOURCE_MANAGER"),
	24 => (13, "RGB_COLOR_MAP"),
	25 => (12, "RGB_BEST_MAP"),
	26 => (12, "RGB_BLUE_MAP"),
	27 => (15, "RGB_DEFAULT_MAP"),
	28 => (12, "RGB_GRAY_MAP"),
	29 => (13, "RGB_GREEN_MAP"),
	30 => (11, "RGB_RED_MAP"),
	31 => ( 6, "STRING"),
	32 => ( 8, "VISUALID"),
	33 => ( 6, "WINDOW"),
	34 => (10, "WM_COMMAND"),
	35 => ( 8, "WM_HINTS"),
	36 => (17, "WM_CLIENT_MACHINE"),
	37 => (12, "WM_ICON_NAME"),
	38 => (12, "WM_ICON_SIZE"),
	39 => ( 7, "WM_NAME"),
	40 => (15, "WM_NORMAL_HINTS"),
	41 => (13, "WM_SIZE_HINTS"),
	42 => (13, "WM_ZOOM_HINTS"),
	43 => ( 9, "MIN_SPACE"),
	44 => (10, "NORM_SPACE"),
	45 => ( 9, "MAX_SPACE"),
	46 => ( 9, "END_SPACE"),
	47 => (13, "SUPERSCRIPT_X"),
	48 => (13, "SUPERSCRIPT_Y"),
	49 => (11, "SUBSCRIPT_X"),
	50 => (11, "SUBSCRIPT_Y"),
	51 => (18, "UNDERLINE_POSITION"),
	52 => (19, "UNDERLINE_THICKNESS"),
	53 => (16, "STRIKEOUT_ASCENT"),
	54 => (17, "STRIKEOUT_DESCENT"),
	55 => (12, "ITALIC_ANGLE"),
	56 => ( 8, "X_HEIGHT"),
	57 => (10, "QUAD_WIDTH"),
	58 => ( 6, "WEIGHT"),
	59 => (10, "POINT_SIZE"),
	60 => (10, "RESOLUTION"),
	61 => ( 9, "COPYRIGHT"),
	62 => ( 6, "NOTICE"),
	63 => ( 9, "FONT_NAME"),
	64 => (11, "FAMILY_NAME"),
	65 => ( 9, "FULL_NAME"),
	66 => (10, "CAP_HEIGHT"),
	67 => ( 8, "WM_CLASS"),
	68 => (16, "WM_TRANSIENT_FOR"));


    function NONE		return ATOM_TYPE is begin return 0; end;

    function PRIMARY		return ATOM_TYPE is begin return 1; end;
    function SECONDARY		return ATOM_TYPE is begin return 2; end;
    function ARC		return ATOM_TYPE is begin return 3; end;
    function ATOM		return ATOM_TYPE is begin return 4; end;
    function BITMAP		return ATOM_TYPE is begin return 5; end;
    function CARDINAL		return ATOM_TYPE is begin return 6; end;
    function COLORMAP		return ATOM_TYPE is begin return 7; end;
    function CURSOR		return ATOM_TYPE is begin return 8; end;
    function CUT_BUFFER0	return ATOM_TYPE is begin return 9; end;
    function CUT_BUFFER1	return ATOM_TYPE is begin return 10; end;
    function CUT_BUFFER2	return ATOM_TYPE is begin return 11; end;
    function CUT_BUFFER3	return ATOM_TYPE is begin return 12; end;
    function CUT_BUFFER4	return ATOM_TYPE is begin return 13; end;
    function CUT_BUFFER5	return ATOM_TYPE is begin return 14; end;
    function CUT_BUFFER6	return ATOM_TYPE is begin return 15; end;
    function CUT_BUFFER7	return ATOM_TYPE is begin return 16; end;
    function DRAWABLE		return ATOM_TYPE is begin return 17; end;
    function FONT		return ATOM_TYPE is begin return 18; end;
    function INTEGER		return ATOM_TYPE is begin return 19; end;
    function PIXMAP		return ATOM_TYPE is begin return 20; end;
    function POINT		return ATOM_TYPE is begin return 21; end;
    function RECTANGLE		return ATOM_TYPE is begin return 22; end;
    function RESOURCE_MANAGER	return ATOM_TYPE is begin return 23; end;
    function RGB_COLOR_MAP	return ATOM_TYPE is begin return 24; end;
    function RGB_BEST_MAP	return ATOM_TYPE is begin return 25; end;
    function RGB_BLUE_MAP	return ATOM_TYPE is begin return 26; end;
    function RGB_DEFAULT_MAP	return ATOM_TYPE is begin return 27; end;
    function RGB_GRAY_MAP	return ATOM_TYPE is begin return 28; end;
    function RGB_GREEN_MAP	return ATOM_TYPE is begin return 29; end;
    function RGB_RED_MAP	return ATOM_TYPE is begin return 30; end;
    function STRING		return ATOM_TYPE is begin return 31; end;
    function VISUALID		return ATOM_TYPE is begin return 32; end;
    function WINDOW		return ATOM_TYPE is begin return 33; end;
    function WM_COMMAND 	return ATOM_TYPE is begin return 34; end;
    function WM_HINTS		return ATOM_TYPE is begin return 35; end;
    function WM_CLIENT_MACHINE	return ATOM_TYPE is begin return 36; end;
    function WM_ICON_NAME	return ATOM_TYPE is begin return 37; end;
    function WM_ICON_SIZE	return ATOM_TYPE is begin return 38; end;
    function WM_NAME		return ATOM_TYPE is begin return 39; end;
    function WM_NORMAL_HINTS	return ATOM_TYPE is begin return 40; end;
    function WM_SIZE_HINTS	return ATOM_TYPE is begin return 41; end;
    function WM_ZOOM_HINTS	return ATOM_TYPE is begin return 42; end;
    function MIN_SPACE		return ATOM_TYPE is begin return 43; end;
    function NORM_SPACE 	return ATOM_TYPE is begin return 44; end;
    function MAX_SPACE		return ATOM_TYPE is begin return 45; end;
    function END_SPACE		return ATOM_TYPE is begin return 46; end;
    function SUPERSCRIPT_X	return ATOM_TYPE is begin return 47; end;
    function SUPERSCRIPT_Y	return ATOM_TYPE is begin return 48; end;
    function SUBSCRIPT_X	return ATOM_TYPE is begin return 49; end;
    function SUBSCRIPT_Y	return ATOM_TYPE is begin return 50; end;
    function UNDERLINE_POSITION return ATOM_TYPE is begin return 51; end;
    function UNDERLINE_THICKNESS return ATOM_TYPE is begin return 52; end;
    function STRIKEOUT_ASCENT	return ATOM_TYPE is begin return 53; end;
    function STRIKEOUT_DESCENT	return ATOM_TYPE is begin return 54; end;
    function ITALIC_ANGLE	return ATOM_TYPE is begin return 55; end;
    function X_HEIGHT		return ATOM_TYPE is begin return 56; end;
    function QUAD_WIDTH 	return ATOM_TYPE is begin return 57; end;
    function WEIGHT		return ATOM_TYPE is begin return 58; end;
    function POINT_SIZE 	return ATOM_TYPE is begin return 59; end;
    function RESOLUTION 	return ATOM_TYPE is begin return 60; end;
    function COPYRIGHT		return ATOM_TYPE is begin return 61; end;
    function NOTICE		return ATOM_TYPE is begin return 62; end;
    function FONT_NAME		return ATOM_TYPE is begin return 63; end;
    function FAMILY_NAME	return ATOM_TYPE is begin return 64; end;
    function FULL_NAME		return ATOM_TYPE is begin return 65; end;
    function CAP_HEIGHT 	return ATOM_TYPE is begin return 66; end;
    function WM_CLASS		return ATOM_TYPE is begin return 67; end;
    function WM_TRANSIENT_FOR	return ATOM_TYPE is begin return 68; end;

    function LAST_PREDEFINED	return ATOM_TYPE is begin return 68; end;

    function TO_INTEGER 	(ATOM : ATOM_TYPE)  return STANDARD.INTEGER is
    begin
	return STANDARD.INTEGER(ATOM);
    end;

    function TO_ATOM		(I : STANDARD.INTEGER)	    return ATOM_TYPE is
    begin
	return ATOM_TYPE(I);
    end;

    function TO_PREDEFINED_ATOM (S : STANDARD.STRING)	    return ATOM_TYPE is
    begin
	for I in TO_STRING_TABLE'range loop
	    if TO_STRING_TABLE(I).TXT = S then
		return TO_ATOM(I);
	    end if;
	end loop;
	raise CONSTRAINT_ERROR;
    end;

    function TO_STRING		(ATOM : ATOM_TYPE)  return STANDARD.STRING is
	I : STANDARD.INTEGER := TO_INTEGER(ATOM); 
    begin
	if I in TO_STRING_TABLE'range then
	    return TO_STRING_TABLE(I).TXT;
	else
	    return STANDARD.INTEGER'image(I);
	end if;
    end;

end;
