-- Copyright (c),  Digital Equipment Corporation, 1992, 1994.
-- Redistribution and use in source and binary forms are permitted
-- provided that the copyright notice as indicated in box below and
-- this paragraph are duplicated in all such forms and that any documentation,
-- advertising materials, and other materials related to such distribution
-- and use acknowledge that the software was developed by Digital Equipment
-- Corporation.  The name of Digital Equipment Corporation may not be used to
-- endorse or promote products derived from this software without the specific
-- prior written permission.
--
-- All other rights reserved.
--
-- THIS SOFTWARE IS PROVIDED ''AS IS'' AND WITHOUT ANY EXPRESS OR IMPLIED
-- WARRANTIES, INCLUDING, WITHOUT LIMITATION, IMPLIED WARRANTIES OF
-- NON-INFRINGEMENT, MERCHANTABILITY OR FITNESS FOR A PARTICULAR PURPOSE.
-- Digital assumes no responsibility AT ALL for the use or reliability
-- of this software.
--
-- +------------------------------------------------------------------------+
-- | USE, DUPLICATION OR DISCLOSURE BY THE U.S. GOVERNMENT IS SUBJECT TO    |
-- | RESTRICTIONS AS SET FORTH IN SUBPARAGRAPH (c) (1) (ii) OF              |
-- | DFARS 252.227-7013, OR IN FAR 52.227-14 ALT. II, AS APPLICABLE.        |
-- |                                                                        |
-- +------------------------------------------------------------------------+
--

package body C_TYPES is
    use SYSTEM;

    function IS_NULL(
	ADDRESS : SYSTEM.ADDRESS)
	return BOOLEAN is

    begin
	return ADDRESS = NULL_ADDRESS;
    end IS_NULL;

    function IS_NULL(
	ADDRESS : CHAR_POINTER)
	return BOOLEAN is

    begin
	return ADDRESS = NULL_CHAR_POINTER;
    end IS_NULL;

    package body NULL_TERMINATED is

        function TO_STRING(S : STANDARD.STRING) return NULL_TERMINATED.STRING is
	    X : NULL_TERMINATED.STRING(S'range);
	        for X use at S'address;
        begin
	    for I in X'range loop
	        if X(I) = 0 then
		    raise CONSTRAINT_ERROR;
	        end if;
	    end loop;
            return NULL_TERMINATED."&"(X, 0);
        end;

        function TO_STRING(S : NULL_TERMINATED.STRING) return STANDARD.STRING is
	    X : STANDARD.STRING(1..LENGTH(S));
	        for X use at S'address;
        begin
	    return X;
        end;

        function TO_STRING(CP : CHAR_POINTER) return NULL_TERMINATED.STRING is
	    X : NULL_TERMINATED.STRING(1..LENGTH(CP)+1);
	        for X use at SYSTEM.ADDRESS(CP);
        begin
	    return X;
        end;

        function TO_STRING(CP : CHAR_POINTER) return STANDARD.STRING is
	    X : STANDARD.STRING(1..LENGTH(CP));
	        for X use at SYSTEM.ADDRESS(CP);
        begin
	    return X;
        end;

        function LENGTH(S : NULL_TERMINATED.STRING) return NATURAL is
        begin
	    for I in S'range loop
	        if S(I) = 0 then
		    return I-S'first;  -- not +1 since 0 not counted
	        end if;
	    end loop;
	    raise CONSTRAINT_ERROR;
        end;

        function LENGTH(CP : CHAR_POINTER) return NATURAL is
	    S : NULL_TERMINATED.UNCHECKED_STRING;
	        for S use at SYSTEM.ADDRESS(CP);
        begin
	    for I in S'range loop
	        if S(I) = 0 then
		    return I-S'first;  -- not +1 since 0 not counted
	        end if;
	    end loop;
	    raise CONSTRAINT_ERROR;
        end;

	function TO_ADDRESS_OR_NULL_POINTER(S : NULL_TERMINATED.STRING) 
	    return SYSTEM.ADDRESS is
	begin
	    if S'LENGTH <= 1 then
		return SYSTEM.NO_ADDR;
	    else
		return S'ADDRESS;
	    end if;
	end;

    end NULL_TERMINATED;
end C_TYPES;
