-- Routine to format and update the drink quantity widget
--
with C_TYPES, XT, XM, XM_CONVENIENCE, XM_STRING;
separate (XM_BURGER_PKG)
procedure UPDATE_DRINK is

    CSTRING : XM.STRING_TYPE;

begin
    -- Create compound string of the drink quantity value.  The Ada
    -- 'IMAGE attribute includes a leading space or sign, and no
    -- trailing space, so we need to add one.
    --
    CSTRING := XM_CONVENIENCE.STRING.CREATE_L_TO_R(
	TEXT     => C_TYPES.NULL_TERMINATED.TO_STRING(
			INTEGER'image( QUANTITIES(DRINKS) ) & " " ),
	CHAR_SET => CHAR_SET );

    SET_CSTRING(
	WIDGET_ARRAY(DRINK_QUANTITY),
	XM_STRING.NLABEL_STRING,
	CSTRING );

end UPDATE_DRINK;
