-- Simplified SET_VALUE routine to use only when changing a single
-- attribute.  If we need to change more than one, all new values
-- should be put into one arglist and we should make one XtSetValues
-- call (which is more efficient).  We have three versions, one for integers,
-- one for compound strings, one for widgets.
--
with C_TYPES, XT;
separate (XM_BURGER_PKG)
procedure SET_INTEGER (
    WIDGET	: in XT.WIDGET_TYPE;
    RESOURCE	: in C_TYPES.NULL_TERMINATED.STRING;
    VALUE	: in INTEGER ) is

    ARG_LIST	: XT.ARG_LIST_TYPE(0..0);

begin
    ARG_LIST := (0 => (
	NAME  => C_TYPES.TO_CHAR_POINTER(RESOURCE'address),
	VALUE => XT.TO_ARG_VALUE_TYPE(VALUE) ));

    XT.SET_VALUES(
	OBJECT => WIDGET,
	ARGS   => ARG_LIST );

end SET_INTEGER;
