-- Callback routine to reset the user interface and the application
-- to a known state.
--
with C_TYPES, XM_CONVENIENCE, XM_STRING;
separate (XM_BURGER_PKG)
procedure RESET_VALUES is
begin
    -- Reset the toggle buttons and our boolean array.  
    --
    for WHICH in BURGER_TOGGLES_TYPE'first .. BURGER_TOGGLES_TYPE'last loop
	SET_BOOLEAN(WHICH, false);
    end loop;

    -- The radio box requires one button to be set, so choose "medium".
    --
    SET_BOOLEAN(BURGER_MEDIUM, true);
    
    -- Reset the burger quantity scale widget and global value
    --
    SET_INTEGER(WIDGET_ARRAY(BURGER_QUANTITY), XM_STRING.NVALUE, 0);
    QUANTITIES(BURGERS) := 0;

    -- Reset the fries quantity text widget.  We do not have a global
    -- for this.  We read the widget whenever we need to know the
    -- quantity.
    --
    XM_CONVENIENCE.TEXT.SET_STRING(
	WIDGET_ARRAY(FRIES_QUANTITY),
	C_TYPES.NULL_TERMINATED.TO_STRING("0") );

    -- Reset the drinks quantity text widget and global value.
    --
    SET_CSTRING(
	WIDGET_ARRAY(DRINK_QUANTITY),
	XM_STRING.NLABEL_STRING, 
	LATIN_ZERO );

    QUANTITIES(DRINKS) := 0;
end RESET_VALUES;
