-- This routine is called just as a pulldown menu is about to be pulled
-- down.  It fetches the menu if it is currently empty, and does other
-- special processing as required.
-- 
with C_TYPES, XT, XM, XM_WIDGET;
separate (XM_BURGER_PKG)
procedure PULL_PROC (		    -- Pulldown menu routine
    WIDGET  : in XT.WIDGET_TYPE;
    TAG	    : in WIDGET_NAMES_TYPE;
    REASON  : in XM_WIDGET.REASON_TYPE)
is
    use XM.MRM;

    FETCH_STATUS    : XM.MRM.RETURN_TYPE;
    CLASS	    : XM.MRM.TYPE_TYPE;

begin
    case TAG is
	when FILE_PDME =>
            if XT.IS_NULL(WIDGET_ARRAY(FILE_MENU)) then
	    	XM.MRM.FETCH_WIDGET(
		    FETCH_STATUS,
		    MRM_HIERARCHY,
		    C_TYPES.NULL_TERMINATED.TO_STRING("file_menu"),
		    WIDGET_ARRAY(MENU_BAR),
		    WIDGET_ARRAY(FILE_MENU),
		    CLASS );

		if FETCH_STATUS /= XM.MRM.SUCCESS then
		    S_ERROR("Can't fetch file pulldown menu widget");
		end if;

		SET_WIDGET(
		    WIDGET_ARRAY(FILE_PDME),
		    XM_STRING.NSUB_MENU_ID,
		    WIDGET_ARRAY(FILE_MENU) );
	    end if;

	when EDIT_PDME =>
            if XT.IS_NULL(WIDGET_ARRAY(EDIT_MENU)) then
		XM.MRM.FETCH_WIDGET(
		    FETCH_STATUS,
		    MRM_HIERARCHY,
		    C_TYPES.NULL_TERMINATED.TO_STRING("edit_menu"),
		    WIDGET_ARRAY(MENU_BAR),
		    WIDGET_ARRAY(EDIT_MENU),
		    CLASS );

		if FETCH_STATUS /= XM.MRM.SUCCESS then
		    S_ERROR("Can't fetch edit pulldown menu widget");
		end if;

		SET_WIDGET(
		    WIDGET_ARRAY(EDIT_PDME),
		    XM_STRING.NSUB_MENU_ID,
		    WIDGET_ARRAY(EDIT_MENU) );
	    end if;

	when ORDER_PDME =>
            if XT.IS_NULL(WIDGET_ARRAY(ORDER_MENU)) then
		XM.MRM.FETCH_WIDGET(
		    FETCH_STATUS,
		    MRM_HIERARCHY,
		    C_TYPES.NULL_TERMINATED.TO_STRING("order_menu"),
		    WIDGET_ARRAY(MENU_BAR),
		    WIDGET_ARRAY(ORDER_MENU),
		    CLASS );

		if FETCH_STATUS /= XM.MRM.SUCCESS then
		    S_ERROR("Can't fetch order pulldown menu widget");
		end if;

		SET_WIDGET(
		    WIDGET_ARRAY(ORDER_PDME),
		    XM_STRING.NSUB_MENU_ID,
		    WIDGET_ARRAY(ORDER_MENU));
	    end if;

	    -- Fetch the order box if necessary
	    --
            if XT.IS_NULL(WIDGET_ARRAY(ORDER_BOX)) then
		XM.MRM.FETCH_WIDGET(
		    FETCH_STATUS,
		    MRM_HIERARCHY,
		    C_TYPES.NULL_TERMINATED.TO_STRING("control_box"),
		    TOP_LEVEL,
		    WIDGET_ARRAY(ORDER_BOX),
		    CLASS);

		if FETCH_STATUS /= XM.MRM.SUCCESS then
		    S_ERROR("Can't fetch order box widget");
		end if;
	    end if;

	    -- Figure out what the label of the push button in
	    -- the pulldown menu should be.
	    --
	    if XT.IS_MANAGED(WIDGET_ARRAY(ORDER_BOX)) then
		SET_CSTRING(
		    WIDGET_ARRAY(CREATE_ORDER),
		    XM_STRING.NLABEL_STRING,
		    LATIN_DISMISS);

	    else
		SET_CSTRING(
		    WIDGET_ARRAY(CREATE_ORDER),
		    XM_STRING.NLABEL_STRING,
		    LATIN_CREATE);
	    end if;

	when OTHERS =>
	    null;
    end case;
end PULL_PROC;
