with C_TYPES, XT, XM, XM_WIDGET, XM_STRING;
package XM_BURGER_PKG is

    -- Define an enumerated type for all the possible widgets.  The
    -- values for each enumeration must match the definitions given
    -- in the MOTIFBURGER.UIL module.
    --
    type WIDGET_NAMES_TYPE is (
	CREATE_ORDER,
	ORDER_PDME,
	FILE_PDME,
	EDIT_PDME,
	NYI,
	APPLY,
	DISMISS,
	NOAPPLY,
	CANCEL_ORDER,
	SUBMIT_ORDER,
	ORDER_BOX,
	BURGER_RARE,
	BURGER_MEDIUM,
	BURGER_WELL,
	BURGER_KETCHUP,
	BURGER_MUSTARD,
	BURGER_ONION,
	BURGER_MAYO,
	BURGER_PICKLE,
	BURGER_QUANTITY,
	FRIES_TINY,
	FRIES_SMALL,
	FRIES_MEDIUM,
	FRIES_LARGE,
	FRIES_HUGE,
	FRIES_QUANTITY,
	DRINK_LIST,
	DRINK_ADD,
	DRINK_SUB,
	DRINK_QUANTITY,
	TOTAL_ORDER,
	BURGER_LABEL,
	FRIES_LABEL,
	DRINK_LABEL,
	MENU_BAR,
	FILE_MENU, 
	EDIT_MENU,
	ORDER_MENU);

    for WIDGET_NAMES_TYPE use (
	CREATE_ORDER	=> 1,
	ORDER_PDME	=> 2,
	FILE_PDME	=> 3,
	EDIT_PDME	=> 4,
	NYI		=> 5,
	APPLY		=> 6,
	DISMISS		=> 7,
	NOAPPLY		=> 8,
	CANCEL_ORDER	=> 9,
	SUBMIT_ORDER	=> 10,
	ORDER_BOX	=> 11,
	BURGER_RARE	=> 12,
	BURGER_MEDIUM	=> 13,
	BURGER_WELL	=> 14,
	BURGER_KETCHUP	=> 15,
	BURGER_MUSTARD	=> 16,
	BURGER_ONION	=> 17,
	BURGER_MAYO	=> 18,
	BURGER_PICKLE	=> 19,
	BURGER_QUANTITY => 20,
	FRIES_TINY	=> 21,
	FRIES_SMALL	=> 22,
	FRIES_MEDIUM	=> 23,
	FRIES_LARGE	=> 24,
	FRIES_HUGE	=> 25,
	FRIES_QUANTITY	=> 26,
	DRINK_LIST	=> 27,
	DRINK_ADD	=> 28,
	DRINK_SUB	=> 29,
	DRINK_QUANTITY	=> 30,
	TOTAL_ORDER	=> 31,
	BURGER_LABEL	=> 32,
	FRIES_LABEL	=> 33,
	DRINK_LABEL	=> 34,
	MENU_BAR	=> 35,
	FILE_MENU	=> 36,
	EDIT_MENU	=> 37,
	ORDER_MENU	=> 38 );

    type ACCESS_WIDGET_NAMES_TYPE is access WIDGET_NAMES_TYPE;

    -- Define a subrange of the widget names that is all the toggles
    -- we need to keep track of
    --
    subtype BURGER_TOGGLES_TYPE is
	WIDGET_NAMES_TYPE range BURGER_RARE .. BURGER_PICKLE;

    -- Define the types of names we will need to keep around.
    --
    type FOOD_NAMES_TYPE is (BURGERS, FRIES, DRINKS);


    --
    -- Variables used in the application.
    --

    -- Root widget ID of our application
    --
    TOP_LEVEL		: XT.WIDGET_TYPE;

    -- Root widget ID of our main MRM fetch
    --
    MAIN_WINDOW_WIDGET	: XT.WIDGET_TYPE := XT.NULL_WIDGET;

    -- Hierarchy ID
    --
    MRM_HIERARCHY : XM.MRM.HIERARCHY_TYPE := XM.MRM.NULL_HIERARCHY;

    -- Place to keep all other widget IDs
    --
    WIDGET_ARRAY  : array(WIDGET_NAMES_TYPE) of XT.WIDGET_TYPE :=
		    (others => XT.NULL_WIDGET);

    -- Our TRUTH about the state of user interface toggles.
    --
    TOGGLE_ARRAY  : array(BURGER_TOGGLES_TYPE) of BOOLEAN := (OTHERS => false);

    CURRENT_DRINK : XM.STRING_TYPE;		-- Last selected drink name
    CURRENT_FRIES : XM.STRING_TYPE;		-- Last selected fries size

    -- Miscellaneous names gotten from various widgets.
    --
    NAMES: array(FOOD_NAMES_TYPE) of XM.STRING_TYPE;

    -- Current quantities of food items.
    -- Note that QUANTITIES(FRIES) is not actually used.
    --
    QUANTITIES: array(FOOD_NAMES_TYPE) of INTEGER := (OTHERS => 0);

    -- Compound strings for later use
    --
    LATIN_CREATE, LATIN_DISMISS, LATIN_SPACE, LATIN_ZERO : XM.STRING_TYPE;

    EXIT_APPLICATION : exception;		-- Raised when application
						-- is to be terminated

    CHAR_SET : XM.STRING_CHAR_SET_TYPE := 
	XM.STRING_CHAR_SET_TYPE(XM_STRING.STRING_DEFAULT_CHARSET_PTR);

    -- Routine declarations
    --
    procedure S_ERROR (				-- Prints error message and
	MESSAGE: in STRING );			-- exits application

    procedure GET_CSTRING (		    -- Gets a compound string attribute
	WIDGET	    : in  XT.WIDGET_TYPE;
	RESOURCE    : in  C_TYPES.NULL_TERMINATED.STRING;
	VALUE	    : out XM.STRING_TYPE );

    procedure SET_INTEGER (		    -- Sets an integer attribute
	WIDGET	    : in XT.WIDGET_TYPE;
	RESOURCE    : in C_TYPES.NULL_TERMINATED.STRING;
	VALUE	    : in INTEGER );
    
    procedure SET_CSTRING (		    -- Sets a compound string attribute
	WIDGET	    : in XT.WIDGET_TYPE;
	RESOURCE    : in C_TYPES.NULL_TERMINATED.STRING;
	VALUE	    : in XM.STRING_TYPE );
    
    procedure SET_WIDGET (		    -- Sets a widget attribute
	WIDGET	    : in XT.WIDGET_TYPE;
	RESOURCE    : in C_TYPES.NULL_TERMINATED.STRING;
	VALUE	    : in XT.WIDGET_TYPE );
    
    procedure SET_BOOLEAN (		    -- Keeps boolean array consistent
	WHICH	: in WIDGET_NAMES_TYPE;
	STATE	: in BOOLEAN );

    procedure UPDATE_DRINK;		    -- Format and update drink
					    -- quantity widget

    -- Callback routines.  For the widget callback routines which
    -- must be registered with the MRM, also define a case-sensitive,
    -- null-terminated string for the routine name that matches that
    -- found in the UIL.
    -- 
    procedure RESET_VALUES;		    -- Reset user interface
	pragma EXPORT_PROCEDURE(RESET_VALUES);

    procedure CLEAR_ORDER;		    -- Clear order display
        pragma EXPORT_PROCEDURE(CLEAR_ORDER);

    procedure ACTIVATE_PROC (		    -- Push button routine
	WIDGET	: in XT.WIDGET_TYPE;
	TAG	: in WIDGET_NAMES_TYPE;
	REASON	: in XM_WIDGET.REASON_TYPE );

        pragma EXPORT_PROCEDURE(ACTIVATE_PROC);

    ACTIVATE_PROC_NAME : constant C_TYPES.NULL_TERMINATED.STRING :=
        C_TYPES.NULL_TERMINATED.TO_STRING("activate_proc");

    procedure TOGGLE_PROC (		    -- Toggle button routine
	WIDGET	: in XT.WIDGET_TYPE;
	TAG	: in ACCESS_WIDGET_NAMES_TYPE;
	TOGGLE	: in XM_WIDGET.ACCESS_TOGGLE_BUTTON_CALLBACK_TYPE );

	pragma EXPORT_PROCEDURE(TOGGLE_PROC,
	    MECHANISM => (VALUE, VALUE, VALUE) );

    TOGGLE_PROC_NAME : constant C_TYPES.NULL_TERMINATED.STRING :=
	C_TYPES.NULL_TERMINATED.TO_STRING("toggle_proc");

    procedure LIST_PROC (		    -- Drink selection list box routine
	WIDGET	: in XT.WIDGET_TYPE;
	TAG	: in ACCESS_WIDGET_NAMES_TYPE;
	LIST	: in XM_WIDGET.ACCESS_LIST_CALLBACK_TYPE );

        pragma EXPORT_PROCEDURE(LIST_PROC,
	    MECHANISM => (VALUE, VALUE, VALUE) );

    LIST_PROC_NAME: constant C_TYPES.NULL_TERMINATED.STRING :=
        C_TYPES.NULL_TERMINATED.TO_STRING("list_proc");

    procedure SCALE_PROC (		    -- Burger quantity scale routine
	WIDGET	: in XT.WIDGET_TYPE;
	TAG	: in ACCESS_WIDGET_NAMES_TYPE;
	SCALE	: in XM_WIDGET.ACCESS_SCALE_CALLBACK_TYPE );

	pragma EXPORT_PROCEDURE(SCALE_PROC,
	    MECHANISM => (VALUE, VALUE, VALUE) );

    SCALE_PROC_NAME : constant C_TYPES.NULL_TERMINATED.STRING :=
	C_TYPES.NULL_TERMINATED.TO_STRING("scale_proc");

    procedure SHOW_HIDE_PROC (		    -- Control order box routine
	WIDGET	: in XT.WIDGET_TYPE;
	TAG	: in WIDGET_NAMES_TYPE;
	REASON	: in XM_WIDGET.REASON_TYPE );

	pragma EXPORT_PROCEDURE(SHOW_HIDE_PROC);

    SHOW_HIDE_PROC_NAME: constant C_TYPES.NULL_TERMINATED.STRING :=
	C_TYPES.NULL_TERMINATED.TO_STRING("show_hide_proc");

    procedure CREATE_PROC (		    -- Widget create routine
	WIDGET	: in XT.WIDGET_TYPE;
	TAG	: in WIDGET_NAMES_TYPE;
	REASON	: in XM_WIDGET.REASON_TYPE );

	pragma EXPORT_PROCEDURE(CREATE_PROC);

    CREATE_PROC_NAME : constant C_TYPES.NULL_TERMINATED.STRING :=
	C_TYPES.NULL_TERMINATED.TO_STRING("create_proc");

    procedure QUIT_PROC (		    -- Quit button routine
	WIDGET	: in XT.WIDGET_TYPE;
	TAG	: in WIDGET_NAMES_TYPE;
	REASON	: in XM_WIDGET.REASON_TYPE );

	pragma EXPORT_PROCEDURE(QUIT_PROC);

    QUIT_PROC_NAME: constant C_TYPES.NULL_TERMINATED.STRING :=
	C_TYPES.NULL_TERMINATED.TO_STRING("quit_proc");

    procedure PULL_PROC (		    -- Pulldown menu routine
	WIDGET	: in XT.WIDGET_TYPE;
	TAG	: in WIDGET_NAMES_TYPE;
	REASON	: in XM_WIDGET.REASON_TYPE );

	pragma EXPORT_PROCEDURE(PULL_PROC);

    PULL_PROC_NAME : constant C_TYPES.NULL_TERMINATED.STRING :=
	C_TYPES.NULL_TERMINATED.TO_STRING("pull_proc");
	
end XM_BURGER_PKG;
