with C_TYPES, XT, XM, XM_CONVENIENCE;
package body XM_BURGER_PKG is

-- Routines, declared separate for clarity.
--
    procedure S_ERROR (
	MESSAGE: in STRING ) is separate;

    procedure GET_CSTRING (
	WIDGET	    : in  XT.WIDGET_TYPE;
	RESOURCE    : in  C_TYPES.NULL_TERMINATED.STRING;
	VALUE	    : out XM.STRING_TYPE ) is separate;

    procedure SET_INTEGER (
	WIDGET	    : in XT.WIDGET_TYPE;
	RESOURCE    : in C_TYPES.NULL_TERMINATED.STRING;
	VALUE	    : in INTEGER ) is separate;
    
    procedure SET_CSTRING (
	WIDGET	    : in XT.WIDGET_TYPE;
	RESOURCE    : in C_TYPES.NULL_TERMINATED.STRING;
	VALUE	    : in XM.STRING_TYPE ) is separate;
    
    procedure SET_WIDGET (
	WIDGET	    : in XT.WIDGET_TYPE;
	RESOURCE    : in C_TYPES.NULL_TERMINATED.STRING;
	VALUE	    : in XT.WIDGET_TYPE ) is separate;
    
    procedure SET_BOOLEAN (
	WHICH	: in WIDGET_NAMES_TYPE;
	STATE	: in BOOLEAN ) is separate;

    procedure UPDATE_DRINK is separate;

    procedure RESET_VALUES is separate;

    procedure CLEAR_ORDER is separate;

    procedure ACTIVATE_PROC (
	WIDGET	: in XT.WIDGET_TYPE;
	TAG	: in WIDGET_NAMES_TYPE;
	REASON	: in XM_WIDGET.REASON_TYPE) is separate;

    procedure TOGGLE_PROC (
	WIDGET	: in XT.WIDGET_TYPE;
	TAG	: in ACCESS_WIDGET_NAMES_TYPE;
	TOGGLE	: in XM_WIDGET.ACCESS_TOGGLE_BUTTON_CALLBACK_TYPE) is separate;

    procedure LIST_PROC (
	WIDGET  : in XT.WIDGET_TYPE;
	TAG	: in ACCESS_WIDGET_NAMES_TYPE;
	LIST	: in XM_WIDGET.ACCESS_LIST_CALLBACK_TYPE) is separate;

    procedure SCALE_PROC (
	WIDGET  : in XT.WIDGET_TYPE;
	TAG	: in ACCESS_WIDGET_NAMES_TYPE;
	SCALE	: in XM_WIDGET.ACCESS_SCALE_CALLBACK_TYPE) is separate;

    procedure SHOW_HIDE_PROC (
	WIDGET	: in XT.WIDGET_TYPE;
	TAG	: in WIDGET_NAMES_TYPE;
	REASON	: in XM_WIDGET.REASON_TYPE) is separate;

    procedure CREATE_PROC (
	WIDGET  : in XT.WIDGET_TYPE;
	TAG	: in WIDGET_NAMES_TYPE;
	REASON	: in XM_WIDGET.REASON_TYPE) is separate;

    procedure QUIT_PROC (
	WIDGET  : in XT.WIDGET_TYPE;
	TAG	: in WIDGET_NAMES_TYPE;
	REASON	: in XM_WIDGET.REASON_TYPE) is separate;

    procedure PULL_PROC (
	WIDGET	: in XT.WIDGET_TYPE;
	TAG	: in WIDGET_NAMES_TYPE;
	REASON	: in XM_WIDGET.REASON_TYPE) is separate;

begin

    -- Initialize our global state to correspond to the UIL.  This code
    -- makes some assumptions about the contents of the UIL.  To
    -- correct this, the following values should be read from the
    -- hierarchy file or from the widgets upon creation:
    --
    --     Text of "Create order box..." and "Dismiss order box..." labels
    --     Initial settings of toggles
    --     Initial settings of fries size and drink selection
    --
    -- In addition, to properly implement "Reset", the initial quantities
    -- of burgers, fries and drinks should be read from the interface and
    -- stored for later use.

    -- Set the medium "hamburger doneness" toggle button so that the
    -- radio box has one toggle button ON at startup.
    --
    TOGGLE_ARRAY(BURGER_MEDIUM) := true;

    -- Intitialize current values of various items to match their
    -- initial values in the MOTIFBURGER UIL module.  Note that this
    -- makes an assumption about the contents of the UIL source.
    --

    begin
	CURRENT_DRINK := XM_CONVENIENCE.STRING.CREATE_L_TO_R(
	    TEXT     => C_TYPES.NULL_TERMINATED.TO_STRING("Apple Juice"),
	    CHAR_SET => CHAR_SET );

	CURRENT_FRIES := XM_CONVENIENCE.STRING.CREATE_L_TO_R(
	    TEXT     => C_TYPES.NULL_TERMINATED.TO_STRING("Medium"),
	    CHAR_SET => CHAR_SET );

	-- Set up the compound strings that we need
	-- 
	LATIN_CREATE := XM_CONVENIENCE.STRING.CREATE_L_TO_R(
	    TEXT     => C_TYPES.NULL_TERMINATED.TO_STRING("Create order box..."),
	    CHAR_SET => CHAR_SET );

	LATIN_DISMISS := XM_CONVENIENCE.STRING.CREATE_L_TO_R(
	    TEXT     => C_TYPES.NULL_TERMINATED.TO_STRING(
			    "Dismiss order box..."),
	    CHAR_SET => CHAR_SET );

	LATIN_SPACE := XM_CONVENIENCE.STRING.CREATE_L_TO_R(
	    TEXT     => C_TYPES.NULL_TERMINATED.TO_STRING(" "),
	    CHAR_SET => CHAR_SET );

	LATIN_ZERO := XM_CONVENIENCE.STRING.CREATE_L_TO_R(
	    TEXT     => C_TYPES.NULL_TERMINATED.TO_STRING(" 0 "),
	    CHAR_SET => CHAR_SET );
    end;

end XM_BURGER_PKG;
