-- Routine called by the drink selection list box whenever the user
-- selects a drink.  Keep the current drink up to date by copying the
-- compound string from the callback structure.
-- 
with XT, XM_WIDGET, XM_CONVENIENCE;
separate (XM_BURGER_PKG)
procedure LIST_PROC (
    WIDGET  : in XT.WIDGET_TYPE;
    TAG	    : in ACCESS_WIDGET_NAMES_TYPE;
    LIST    : in XM_WIDGET.ACCESS_LIST_CALLBACK_TYPE)
is

begin
    XT.FREE(C_TYPES.CHAR_POINTER(CURRENT_DRINK));   -- Free old compound string.
    CURRENT_DRINK := XM_CONVENIENCE.STRING.COPY(LIST.all.ITEM);  -- Make a copy.
end LIST_PROC;
