-- All widgets that are created call back to this procedure.  We record
-- the ID in the global array and for some of them, make a copy of the
-- widget label name.
--
with C_TYPES, XT, XM, XM_WIDGET, XM_STRING;
separate (XM_BURGER_PKG)
procedure CREATE_PROC (
    WIDGET  : in XT.WIDGET_TYPE;
    TAG	    : in WIDGET_NAMES_TYPE;
    REASON  : in XM_WIDGET.REASON_TYPE) is

    TEMP_CSTRING : XM.STRING_TYPE;

begin
    WIDGET_ARRAY(TAG) := WIDGET;

    -- For internationalization ease, we capture a few strings from
    -- the widgets themselves.  We could go out and fetch them as needed
    -- but since we use these all the time, this method is more
    -- efficient.
    --
    case TAG is
	when BURGER_LABEL =>
	    begin
		GET_CSTRING(WIDGET, XM_STRING.NLABEL_STRING, TEMP_CSTRING);

		NAMES(BURGERS) := XM_CONVENIENCE.STRING.COPY(TEMP_CSTRING);
	    end;

	when FRIES_LABEL =>
	    begin
		GET_CSTRING(WIDGET, XM_STRING.NLABEL_STRING, TEMP_CSTRING);

		NAMES(FRIES) := XM_CONVENIENCE.STRING.COPY(TEMP_CSTRING);
	    end;

	when DRINK_LABEL =>
	    begin
		GET_CSTRING(WIDGET, XM_STRING.NLABEL_STRING, TEMP_CSTRING);

		NAMES(DRINKS) := XM_CONVENIENCE.STRING.COPY(TEMP_CSTRING);
	    end;

	when OTHERS => null;
    end case;
end CREATE_PROC;
