-- Routine called by all push buttons.  We use the tag to tell us
-- which widget it is, then react accordingly.
--
with C_TYPES,
     XT, XM, XM_CONVENIENCE, XM_WIDGET, XM_STRING;
use  XM;
separate (XM_BURGER_PKG)
procedure ACTIVATE_PROC (

    WIDGET  : in XT.WIDGET_TYPE;
    TAG	    : in WIDGET_NAMES_TYPE;
    REASON  : in XM_WIDGET.REASON_TYPE) is

    use XM.MRM;

    CLASS : XM.MRM.TYPE_TYPE;
    STATUS: XM.MRM.RETURN_TYPE;

    LIST_TEXT, TEXT, CSTEMP : XM.STRING_TYPE;
    FRIES_TEXT_PTR :  C_TYPES.CHAR_POINTER;
    FRIES_NUM : INTEGER;

begin

    -- Select action based on widget name
    --
    case TAG is
	when NYI =>
	    -- The user activated a "not yet implemented" pushbutton.
	    -- Send the user a message.
	    -- 
	    if XT.IS_NULL(WIDGET_ARRAY(NYI)) then

		-- The first time, fetch from the database.
		-- 
		XM.MRM.FETCH_WIDGET (
		    RESULT	    => STATUS,
		    HIERARCHY_ID    => MRM_HIERARCHY,
		    NAME	    => C_TYPES.NULL_TERMINATED.TO_STRING("nyi"),
		    PARENT	    => TOP_LEVEL,
		    WIDGET	    => WIDGET_ARRAY(NYI),
		    CLASS	    => CLASS);

		if STATUS /= XM.MRM.SUCCESS then
		    S_ERROR("Can't fetch NYI widget");
		end if;
	    end if;

	    -- Put up the message box saying "not yet implemented"
	    -- 
	    XT.MANAGE_CHILD( WIDGET_ARRAY(NYI) );

	when SUBMIT_ORDER =>
	    -- This would send the order off to the kitchen.  In this
	    -- case, we just pretend the order was submitted.
	    -- 
	    CLEAR_ORDER;

	when CANCEL_ORDER =>
	    -- Clear out the order display
	    -- 
	    CLEAR_ORDER;

	when DISMISS =>
	    -- Bring down the control box and reset the values
	    -- to the default
	    -- 
	    XT.UNMANAGE_CHILD( WIDGET_ARRAY(ORDER_BOX) );
	    RESET_VALUES;

	when NOAPPLY =>
	    RESET_VALUES;

	when APPLY =>
	    -- Take the current settings and write them into the list box.
	    --
	    if QUANTITIES(BURGERS) > 0 then
		-- Put burger quantity in the display string
		--
		LIST_TEXT := XM_CONVENIENCE.STRING.CREATE_L_TO_R(
		    TEXT     => C_TYPES.NULL_TERMINATED.TO_STRING(
				INTEGER'image(QUANTITIES(BURGERS)) & " " ),
		    CHAR_SET => CHAR_SET );

		-- Collect hamburger attributes that are ON
		-- 
		for WHICH in BURGER_TOGGLES_TYPE'first..BURGER_TOGGLES_TYPE'last
		loop
		    if TOGGLE_ARRAY(WHICH) = true then

			-- Get the name of the qualifier from the
			-- widget and add to the display string, taking
			-- care to free temporary strings (but not the
			-- widget label string.)
			-- 
			GET_CSTRING(
			    WIDGET_ARRAY(WHICH),
			    XM_STRING.NLABEL_STRING,
			    TEXT);

			CSTEMP	  := LIST_TEXT;
			LIST_TEXT := XM_CONVENIENCE.STRING.CONCAT(
			    LIST_TEXT, TEXT );

			XT.FREE(C_TYPES.CHAR_POINTER(CSTEMP));

			CSTEMP	  := LIST_TEXT;
			LIST_TEXT := XM_CONVENIENCE.STRING.CONCAT(
			    LIST_TEXT, LATIN_SPACE );

			XT.FREE(C_TYPES.CHAR_POINTER(CSTEMP));
		    end if;
		end loop;

		-- Concatenate hamburger name to the display string
		-- 
		CSTEMP	  := LIST_TEXT;
		LIST_TEXT := XM_CONVENIENCE.STRING.CONCAT(
		    LIST_TEXT, NAMES(BURGERS) );

		XM_CONVENIENCE.LIST.ADD_ITEM(
		    WIDGET_ARRAY(TOTAL_ORDER),
		    LIST_TEXT,
		    XM.POSITION_TYPE(0) );

		XT.FREE(C_TYPES.CHAR_POINTER(CSTEMP));
		XT.FREE(C_TYPES.CHAR_POINTER(LIST_TEXT));
	    end if;

	    -- Fries text widget does not have a callback.  So we query the
	    -- widget now to determine what its value is.  Convert to
	    -- an integer.
	    -- 
	    FRIES_TEXT_PTR := XM_CONVENIENCE.TEXT.GET_STRING(
		WIDGET  => WIDGET_ARRAY(FRIES_QUANTITY) );

	    FRIES_NUM := INTEGER'value(
		C_TYPES.NULL_TERMINATED.TO_STRING(FRIES_TEXT_PTR) );

	    -- If fries quantity is invalid (less than zero), reset it to
	    -- zero.
	    --
	    if FRIES_NUM < 0 then
		XM_CONVENIENCE.TEXT.SET_STRING(
		    WIDGET_ARRAY(FRIES_QUANTITY),
		    C_TYPES.NULL_TERMINATED.TO_STRING("0") );

	    elsif FRIES_NUM > 0 then

		-- Put the fries quantity in the display string
		--
		LIST_TEXT := XM_CONVENIENCE.STRING.CREATE_L_TO_R(
		    C_TYPES.NULL_TERMINATED.TO_STRING(
			INTEGER'image(FRIES_NUM) & " " ),
		    CHAR_SET );

		-- Append the fries size
		-- 
		CSTEMP    := LIST_TEXT;
		LIST_TEXT := XM_CONVENIENCE.STRING.CONCAT(
		    LIST_TEXT, CURRENT_FRIES );

		XT.FREE(C_TYPES.CHAR_POINTER(CSTEMP));

		CSTEMP	  := LIST_TEXT;
		LIST_TEXT := XM_CONVENIENCE.STRING.CONCAT(
		    LIST_TEXT, LATIN_SPACE );

		XT.FREE(C_TYPES.CHAR_POINTER(CSTEMP));

		-- Append the fries name and add to total order display
		-- 
		CSTEMP	  := LIST_TEXT;
		LIST_TEXT := XM_CONVENIENCE.STRING.CONCAT(
		    LIST_TEXT, NAMES(FRIES) );

		XM_CONVENIENCE.LIST.ADD_ITEM(
		    WIDGET_ARRAY(TOTAL_ORDER),
		    LIST_TEXT,
		    XM.POSITION_TYPE(0) );

		XT.FREE(C_TYPES.CHAR_POINTER(CSTEMP));
		XT.FREE(C_TYPES.CHAR_POINTER(LIST_TEXT));
	    end if;

	    if QUANTITIES(DRINKS) > 0 then
		-- Put drinks quantity into the display string
		--
		LIST_TEXT := XM_CONVENIENCE.STRING.CREATE_L_TO_R(
		    C_TYPES.NULL_TERMINATED.TO_STRING(
			INTEGER'image(QUANTITIES(DRINKS)) & " " ),
		    CHAR_SET );

		-- Concatenate drink size and name to the display string
		-- 
		CSTEMP    := LIST_TEXT;
		LIST_TEXT := XM_CONVENIENCE.STRING.CONCAT(
		    LIST_TEXT, CURRENT_DRINK );

		XT.FREE(C_TYPES.CHAR_POINTER(CSTEMP));

		CSTEMP	  := LIST_TEXT;
		LIST_TEXT := XM_CONVENIENCE.STRING.CONCAT(
		    LIST_TEXT, LATIN_SPACE);

		XT.FREE(C_TYPES.CHAR_POINTER(CSTEMP));

		CSTEMP	  := LIST_TEXT;
		LIST_TEXT := XM_CONVENIENCE.STRING.CONCAT(
		    LIST_TEXT, NAMES(DRINKS) );


		XM_CONVENIENCE.LIST.ADD_ITEM(
		    WIDGET_ARRAY(TOTAL_ORDER),
		    LIST_TEXT,
		    XM.POSITION_TYPE(0) );

		XT.FREE(C_TYPES.CHAR_POINTER(CSTEMP));
		XT.FREE(C_TYPES.CHAR_POINTER(LIST_TEXT));
	    end if;

	when FRIES_TINY   | FRIES_SMALL |
	     FRIES_MEDIUM | FRIES_LARGE | FRIES_HUGE =>

	    -- Some fries push button was activated, so get the string
	    -- from the interface, freeing the old one first, then making
	    -- a new copy.  We must make a copy as GET_CSTRING returns a
	    -- pointer to the toolkit's internal structures.
	    --
	    XT.FREE(C_TYPES.CHAR_POINTER(CURRENT_FRIES));

	    GET_CSTRING(WIDGET, XM_STRING.NLABEL_STRING, CURRENT_FRIES);

	    CURRENT_FRIES := XM_CONVENIENCE.STRING.COPY(CURRENT_FRIES);

	when DRINK_ADD =>
	    -- Increment the drink quantity and update the display.
	    -- 
	    QUANTITIES(DRINKS) := QUANTITIES(DRINKS) + 1;
	    UPDATE_DRINK;

	when DRINK_SUB =>
	    -- Decrement drink quantity, but do not let it go below zero.
	    --
	    if QUANTITIES(DRINKS) > 0 then
		QUANTITIES(DRINKS) := QUANTITIES(DRINKS) - 1;
	    end if;

	    UPDATE_DRINK;

	when OTHERS =>
	    null;
    end case;
end ACTIVATE_PROC;
