-- XM_BURGER.ADA
--
-- Abstract: Displays a graphical hamburger order entry system.
--
with SYSTEM, X_LIB, X_RESOURCE, C_TYPES, XT, XM, XM_STRING, XM_BURGER_PKG;

use XM_BURGER_PKG;

procedure XM_BURGER is

    use XM.MRM;     -- Needed to access /= for XM.MRM.RETURN_TYPE.

    --  Hierarchy file name.  To change file name,
    --  change definition of following constant.
    --
    HIERARCHY_FILE_NAME : constant C_TYPES.NULL_TERMINATED.STRING :=
	C_TYPES.NULL_TERMINATED.TO_STRING("xm_burger.uid");

    HIERARCHY_FILE_LIST : constant
	C_TYPES.NULL_TERMINATED.VECTOR_OF_CHAR_POINTER(1..1) :=
	    ( 1 => C_TYPES.TO_CHAR_POINTER(HIERARCHY_FILE_NAME'address) );

    -- Argument list for registering callback routines.  The names
    -- do not have to be in order.
    --
    REGISTER_LIST : XM.MRM.VECTOR_OF_REGISTER_ARG_TYPE(1..8) :=
	(1 => (NAME  => C_TYPES.TO_CHAR_POINTER(ACTIVATE_PROC_NAME'address),
	       VALUE => ACTIVATE_PROC'address),

	 2 => (NAME  => C_TYPES.TO_CHAR_POINTER(CREATE_PROC_NAME'address),
	       VALUE => CREATE_PROC'address),

	 3 => (NAME  => C_TYPES.TO_CHAR_POINTER(LIST_PROC_NAME'address),
	       VALUE => LIST_PROC'address),

	 4 => (NAME  => C_TYPES.TO_CHAR_POINTER(PULL_PROC_NAME'address),
	       VALUE => PULL_PROC'address),

	 5 => (NAME  => C_TYPES.TO_CHAR_POINTER(QUIT_PROC_NAME'address),
	       VALUE => QUIT_PROC'address),

	 6 => (NAME  => C_TYPES.TO_CHAR_POINTER(SCALE_PROC_NAME'address),
	       VALUE => SCALE_PROC'address),

	 7 => (NAME  => C_TYPES.TO_CHAR_POINTER(SHOW_HIDE_PROC_NAME'address),
	       VALUE => SHOW_HIDE_PROC'address),

	 8 => (NAME  => C_TYPES.TO_CHAR_POINTER(TOGGLE_PROC_NAME'address),
	       VALUE => TOGGLE_PROC'address));


    APP_CONTEXT : XT.APP_CONTEXT_TYPE;	    -- Application context
    DISPLAY	: X_LIB.DISPLAY_TYPE;	    -- Display

    -- Arg list passed to AppCreateShell specifying that the widget
    -- allows resize
    --
    SHELL_ARG_LIST: constant XT.ARG_LIST_TYPE(0..0) :=
	(0 => (
	    NAME  => XM_STRING.NALLOW_SHELL_RESIZE_PTR,
	    VALUE => XT.TO_ARG_VALUE_TYPE(true) ));

    -- Arguments required by initialization calls
    --
    CLASS	    : XM.MRM.TYPE_TYPE;       -- Dummy argument.

    OPEN_STATUS	    : XM.MRM.RETURN_TYPE;
    REGISTER_STATUS : XM.MRM.RETURN_TYPE;
    FETCH_STATUS    : XM.MRM.RETURN_TYPE;

    XM_BURGER_ARGC : NATURAL := 0;
    XM_BURGER_ARGV : SYSTEM.ADDRESS := SYSTEM.NULL_ADDRESS;

begin
    -- Initialize the Motif Resource Manager
    --
    XM.MRM.INITIALIZE;

    -- Initialize the X Toolkit.  
    --
    XT.TOOLKIT_INITIALIZE;

    -- Create the application context
    --
    APP_CONTEXT := XT.CREATE_APPLICATION_CONTEXT;

    -- Open the display
    --
    XT.OPEN_DISPLAY(
	RESULT		  => DISPLAY,
	APP_CONTEXT	  => APP_CONTEXT,
	DISPLAY_STRING	  => C_TYPES.NULL_TERMINATED.NULL_STRING,
	APPLICATION_NAME  =>
	    C_TYPES.NULL_TERMINATED.TO_STRING("MOTIFBURGER in DEC Ada"),
	APPLICATION_CLASS => C_TYPES.NULL_TERMINATED.TO_STRING("example"),
	OPTIONS		  => X_RESOURCE.NULL_VECTOR_OF_OPTION_DESC,
	ARGC		  => XM_BURGER_ARGC,
	ARGV		  => XM_BURGER_ARGV);

    -- Create the application shell.  This call returns the ID of the
    -- "top-level" widget.  The application's "main" widget must be the
    -- only child of this widget.
    --
    TOP_LEVEL := XT.APP_CREATE_SHELL(
	APPLICATION_NAME  => C_TYPES.NULL_TERMINATED.TO_STRING(
			         "MOTIFBURGER in DEC Ada" ),
	APPLICATION_CLASS => C_TYPES.NULL_TERMINATED.TO_STRING("example"),
	WIDGET_CLASS	  => XT.APPLICATION_SHELL_WIDGET_CLASS,
	DISPLAY		  => DISPLAY,
	ARGS		  => SHELL_ARG_LIST );

    -- Open the hierarchy file
    --
    XM.MRM.OPEN_HIERARCHY(
	RESULT		=> OPEN_STATUS,		          -- Status of operation
	NAMES_LIST	=> HIERARCHY_FILE_LIST,		  -- File names
	ANCILLARY_LIST	=> XM.MRM.NULL_ACCESS_OS_OPEN_PARAM,
	HIERARCHY_ID	=> MRM_HIERARCHY );	          -- Opened hierarchy ID

    if OPEN_STATUS /= XM.MRM.SUCCESS then
	S_ERROR("Can't open hierarchy");
    end if;

    -- Register the items MRM needs to bind for us
    --
    XM.MRM.REGISTER_NAMES(
	RESULT	    => REGISTER_STATUS,		-- Status of operation
	ARG_LIST    => REGISTER_LIST );		-- List of items
                                               
    if REGISTER_STATUS /= XM.MRM.SUCCESS then
	S_ERROR ("Can't register callbacks");
    end if;

    -- Get the main part of the application
    --
    XM.MRM.FETCH_WIDGET(
	RESULT		=> FETCH_STATUS,	-- Status of operation
	HIERARCHY_ID	=> MRM_HIERARCHY,	-- Hierarchy to fetch from
	NAME		=>			-- Name of widget to fetch
	    C_TYPES.NULL_TERMINATED.TO_STRING(
		"S_MAIN_WINDOW" ),
	PARENT		=> TOP_LEVEL,	        -- Parent widget
	WIDGET	   	=> MAIN_WINDOW_WIDGET,	-- Window widget
	CLASS		=> CLASS );		-- Not used

    if FETCH_STATUS /= XM.MRM.SUCCESS then
	S_ERROR("Can't fetch main window");
    end if;

    -- Manage the main part and realize everything.  The interface
    -- comes up on the display now.
    --
    XT.MANAGE_CHILD(MAIN_WINDOW_WIDGET);
    XT.REALIZE_WIDGET(TOP_LEVEL);

    -- Sit around forever waiting to process X-events.  We never leave
    -- XtAppMainLoop.  From here on, we only execute our callback routines.
    -- The program is terminated by raising the EXIT_APPLICATION exception.
    --
    XT.APP_MAIN_LOOP(APP_CONTEXT);
    
exception
    when EXIT_APPLICATION =>
	null;		    -- Leave the main block and exit the program
end XM_BURGER;
