--***********************************************************************
--									*
--									*
--   This software was written by Bevin Brett, of Digital Equipment	*
--   Corporation.							*
--									*
--   Digital assumes no responsibility AT ALL for the use or reliability*
--   of this software.							*
--									*
--   Redistribution and use in source and binary forms are permitted	*
--   provided that the above copyright notice and this paragraph are	*
--   duplicated in all such forms and that any documentation,		*
--   advertising materials, and other materials related to such		*
--   distribution and use acknowledge that the software was developed	*
--   by Digital Equipment Corporation. The name of Digital Equipment	*
--   Corporation may not be used to endorse or promote products derived	*
--   from this software without specific prior written permission.	*
--									*
--   THIS SOFTWARE IS PROVIDED ``AS IS'' AND WITHOUT ANY EXPRESS OR	*
--   IMPLIED WARRANTIES, INCLUDING, WITHOUT LIMITATION, THE IMPLIED	*
--   WARRANTIES OF MERCHANTIBILITY AND FITNESS FOR A PARTICULAR PURPOSE.*
--									*
--***********************************************************************

with TEXT_IO, INTEGER_TEXT_IO;

separate(GRAPHICS_WINDOW_MANAGER)
    procedure FILL_CONVEX_POLYGON(
	COLOR : COLORS.COLOR;
	POINTS: POINTS_TYPE
	)
    is
	V : VECTOR_OF_POINT_TYPE(POINTS'range);	-- translated points
    begin
	-- Translate the points into window coordinates
	for I in POINTS'range loop
	    V(I).X := WIDTH_PIXEL_COUNT_SUBTYPE (FLOAT(GW.WIDTH) *
						 FLOAT(POINTS(I).X));
	    V(I).Y := HEIGHT_PIXEL_COUNT_SUBTYPE(FLOAT(GW.HEIGHT) *
						 FLOAT(POINTS(I).Y));
	end loop;

	-- Print out what we are doing
	if DEBUGGING then
	    declare
		use TEXT_IO, INTEGER_TEXT_IO;
	    begin
		PUT_LINE("FILL_CONVEX_POLYGON(");
		PUT_LINE("    COLOR => " & COLORS.COLOR'image(COLOR) & ",");
		PUT     ("    POINTS=>(");
		for I in POINTS'range loop
		    PUT("("); PUT(INTEGER(V(I).X), WIDTH=>3);
		    PUT(","); PUT(INTEGER(V(I).Y), WIDTH=>3);
		    PUT(")");
		    if I /= POINTS'last then PUT(", "); end if;
		end loop;
		PUT_LINE("));");
	    end;
	end if;

	-- Draw the filled polygon
	FILL_POLYGON (
	    DISPLAY	=> DISPLAY,
	    DRAWABLE	=> DRAWABLE_TYPE(GW.PIXMAP),
	    GC		=> GW.GCs(COLOR),
	    POINTS	=> V,
	    SHAPE	=> CONVEX,
	    MODE	=> ORIGIN);

    end;
