--***********************************************************************
--									*
--									*
--   This software was written by Bevin Brett, of Digital Equipment	*
--   Corporation.							*
--									*
--   Digital assumes no responsibility AT ALL for the use or reliability*
--   of this software.							*
--									*
--   Redistribution and use in source and binary forms are permitted	*
--   provided that the above copyright notice and this paragraph are	*
--   duplicated in all such forms and that any documentation,		*
--   advertising materials, and other materials related to such		*
--   distribution and use acknowledge that the software was developed	*
--   by Digital Equipment Corporation. The name of Digital Equipment	*
--   Corporation may not be used to endorse or promote products derived	*
--   from this software without specific prior written permission.	*
--									*
--   THIS SOFTWARE IS PROVIDED ``AS IS'' AND WITHOUT ANY EXPRESS OR	*
--   IMPLIED WARRANTIES, INCLUDING, WITHOUT LIMITATION, THE IMPLIED	*
--   WARRANTIES OF MERCHANTIBILITY AND FITNESS FOR A PARTICULAR PURPOSE.*
--									*
--***********************************************************************

with TEXT_IO; use TEXT_IO;

separate(GRAPHICS_WINDOW_MANAGER)
    procedure CREATE_THE_WINDOW is

	procedure PUT(NAME : STRING; COLORS : VECTOR_OF_COLOR_TYPE) is
	begin
	    PUT_LINE(NAME & " => (");
	    for I in COLORS'range loop
		PUT("(PIXEL =>" &
		    COLORMAP_INDEX_TYPE'image(COLORS(I).PIXEL) & ",");
		PUT(" RED =>" &
		    COLOR_INTENSITY_TYPE'image(COLORS(I).RED) & ",");
		PUT(" GREEN =>" &
		    COLOR_INTENSITY_TYPE'image(COLORS(I).GREEN) & ",");
		PUT(" BLUE =>" &
		    COLOR_INTENSITY_TYPE'image(COLORS(I).BLUE) & ")");
		if I /= COLORS'last then PUT_LINE(", "); end if;
	    end loop;
	    PUT_LINE(")");
	    NEW_LINE;
	end;

    begin
	-- Specify all the non-default attributes for the window
	--
	WINDOW_MASKS :=
	    (EVENT_MASK|BACKGROUND_PIXEL|COLORMAP => TRUE,
	     others => FALSE);

	SWA.EVENT_MASK := 
	    (--KEY_PRESS|KEY_RELEASE|
	     --BUTTON_PRESS|BUTTON_RELEASE|
	     --POINTER_MOTION|EXPOSURE => TRUE,
	     BUTTONS_MOTION => (others => FALSE),
	     others => FALSE);

	SWA.BACKGROUND_PIXEL := WHITE_PIXEL_OF_SCREEN(SCREEN);

	SWA.COLORMAP := COLORMAP;

	--  Choose the size of the window as a large square
	declare
	    W : INTEGER := INTEGER(WIDTH);
	    H : INTEGER := INTEGER(HEIGHT);
	    M : INTEGER := (W*BOOLEAN'pos(W<H) + H*BOOLEAN'pos(W>=H))/2;
	begin
	    GW.WIDTH    := WIDTH_PIXEL_COUNT_SUBTYPE(M);
	    GW.HEIGHT   := HEIGHT_PIXEL_COUNT_SUBTYPE(M);
	end;

	-- Show what was chosen
	if DEBUGGING then
	    PUT_LINE("GW.WIDTH =>" & INTEGER'image(INTEGER(GW.WIDTH )));
	    PUT_LINE("GW.HEIGHT=>" & INTEGER'image(INTEGER(GW.HEIGHT)));
	end if;

	-- Create the window
	GW.WINDOW := 
	    CREATE_WINDOW(
		DISPLAY,
		ROOT_WINDOW_OF_SCREEN(SCREEN),
		0,
		0,
		GW.WIDTH,
		GW.HEIGHT,
		0,
		DEPTH,
		INPUT_OUTPUT,
		VISUAL,
		WINDOW_MASKS,
		SWA);

	GW.PIXMAP :=
	    CREATE_PIXMAP(
		DISPLAY,
		DRAWABLE_TYPE(GW.WINDOW),
		GW.WIDTH,
		GW.HEIGHT,
		DEPTH);
		
	-- Create graphics contexts
	--
	declare
	    function GET_COLORMAP_INDEX(
		COLOR_NAME : STRING) return COLORMAP_INDEX_TYPE is

		SUCCEEDED   : BOOLEAN;
		SCREEN_DEF  : COLOR_TYPE;
		EXACT_DEF   : COLOR_TYPE;
		ALT	    : STRING(1..80);
		LAST	    : NATURAL;
	    begin
		ALLOC_NAMED_COLOR(SUCCEEDED, DISPLAY, COLORMAP,
		    C_TYPES.NULL_TERMINATED.TO_STRING(COLOR_NAME),
		    SCREEN_DEF, EXACT_DEF);
		if not SUCCEEDED then
		    PUT_LINE("No " & COLOR_NAME & " available, substitute: ");
		    GET_LINE(ALT, LAST);
		    return GET_COLORMAP_INDEX(ALT(1..LAST));
		end if;
		return SCREEN_DEF.PIXEL;
	    end;

	    procedure CREATE_GC(
		COLOR	: COLORS.COLOR;
		NAME	: STRING) is
		GC_VALUES : GC_VALUES_TYPE := GC_VALUES_INIT;
	    begin
		GC_VALUES.FUNC		:= GX_COPY;
		GC_VALUES.FOREGROUND	:= GET_COLORMAP_INDEX(NAME);
		GC_VALUES.BACKGROUND	:= BLACK_PIXEL_OF_SCREEN(SCREEN);

		if DEBUGGING then
		    PUT_LINE(NAME & " => CREATE_GC(");
		    PUT("  PLANE_MASK => (");
			for I in GC_VALUES.PLANE_MASK'range loop
			    PUT(BOOLEAN'image(GC_VALUES.PLANE_MASK(I))(1));
			end loop;
			NEW_LINE;
		    PUT_LINE("  FOREGROUND =>" &
		        COLORMAP_INDEX_TYPE'image(GC_VALUES.FOREGROUND));
		    PUT_LINE(")");
		end if;

		GW.GCs(COLOR) :=
		    CREATE_GC( DISPLAY 	=> DISPLAY, DRAWABLE	=> DRAWABLE_TYPE(GW.WINDOW),
			VALUES_MASK 	=> (FUNC|FOREGROUND|BACKGROUND=>TRUE,
					    others=>FALSE),
			VALUES		=> GC_VALUES);
	    end;
	begin
	    CREATE_GC(Color_1, "red");
	    CREATE_GC(Color_2, "navy blue");
	    CREATE_GC(Color_3, "yellow");
	    CREATE_GC(Color_4, "green");
	    CREATE_GC(Color_5, "blue");
	    CREATE_GC(Color_6, "grey");
	    CREATE_GC(Color_Interior, "black");
	    CREATE_GC(Color_Background, "white");
	end;

	ERASE;

   end;
