--***********************************************************************
--									*
--									*
--   This software was written by Bevin Brett, of Digital Equipment	*
--   Corporation.							*
--									*
--   Digital assumes no responsibility AT ALL for the use or reliability*
--   of this software.							*
--									*
--   Redistribution and use in source and binary forms are permitted	*
--   provided that the above copyright notice and this paragraph are	*
--   duplicated in all such forms and that any documentation,		*
--   advertising materials, and other materials related to such		*
--   distribution and use acknowledge that the software was developed	*
--   by Digital Equipment Corporation. The name of Digital Equipment	*
--   Corporation may not be used to endorse or promote products derived	*
--   from this software without specific prior written permission.	*
--									*
--   THIS SOFTWARE IS PROVIDED ``AS IS'' AND WITHOUT ANY EXPRESS OR	*
--   IMPLIED WARRANTIES, INCLUDING, WITHOUT LIMITATION, THE IMPLIED	*
--   WARRANTIES OF MERCHANTIBILITY AND FITNESS FOR A PARTICULAR PURPOSE.*
--									*
--***********************************************************************

with
    BUG;

with X,X_LIB,C_TYPES;
use  X,X_LIB;

pragma ELABORATE(
    X,X_LIB,C_TYPES);

package body GRAPHICS_WINDOW_MANAGER is

    DEBUGGING : BOOLEAN := FALSE;
	pragma VOLATILE(DEBUGGING); -- so can be changed via debugger

    NO_SUCH_DISPLAY : constant DISPLAY_TYPE := null;

    type COLOR_VECTOR_OF_GC_TYPE is array(COLOR) of GC_TYPE;

    type GRAPHICS_WINDOW_TYPE is
	record
	    WINDOW  : WINDOW_TYPE;
	    PIXMAP  : PIXMAP_TYPE;
	    HEIGHT  : HEIGHT_PIXEL_COUNT_SUBTYPE;
	    WIDTH   : WIDTH_PIXEL_COUNT_SUBTYPE;
	    GCs	    : COLOR_VECTOR_OF_GC_TYPE;
	end record;

    DISPLAY	    : DISPLAY_TYPE;
    GW		    : GRAPHICS_WINDOW_TYPE;
    COLORMAP	    : COLORMAP_TYPE;
    FONT	    : FONT_TYPE;
    SCREEN	    : ACCESS_SCREEN_TYPE;
    VISUAL	    : VISUAL_TYPE;

    DEPTH	    : DEPTH_TYPE;
    HEIGHT	    : HEIGHT_PIXEL_COUNT_SUBTYPE;
    HEIGHT_MM	    : MILLIMETRES_TYPE;
    SWA 	    : SET_WINDOW_ATTRIBUTES_TYPE;
    WIDTH	    : WIDTH_PIXEL_COUNT_SUBTYPE;
    WIDTH_MM	    : MILLIMETRES_TYPE;
    WINDOW_MASKS    : SET_WINDOW_ATTRIBUTES_MASK_TYPE;

    ALREADY_A_GRAPHICS_WINDOW	: exception;
    NOT_A_GRAPHICS_WINDOW	: exception;

    procedure ERASE is
    begin
	FILL_POLYGON (
	    DISPLAY	    => DISPLAY,
	    DRAWABLE	    => DRAWABLE_TYPE(GW.PIXMAP),
	    GC		    => GW.GCs(Color_Background),
	    POINTS	    => ( (0,0), (0,GW.HEIGHT),
				 (GW.WIDTH, GW.HEIGHT), (GW.WIDTH,0) ),
	    SHAPE	    => CONVEX,
	    MODE	    => ORIGIN);
    end;

    procedure CREATE_THE_WINDOW
    is separate;

    procedure FILL_CONVEX_POLYGON(
	COLOR : COLORS.COLOR;
	POINTS: POINTS_TYPE
	)
    is separate;

    procedure START_NEW_PICTURE
    is separate;	

    procedure STARTUP(NAME : STRING) is
    begin
	DISPLAY := OPEN_DISPLAY(C_TYPES.NULL_TERMINATED.TO_STRING(""));
	if DISPLAY = NO_SUCH_DISPLAY then
	    BUG("Unable to open DISPLAY");
	end if;

	SCREEN	    := DEFAULT_SCREEN_OF_DISPLAY(DISPLAY);
	COLORMAP    := DEFAULT_COLORMAP_OF_SCREEN(SCREEN);
	HEIGHT	    := HEIGHT_OF_SCREEN(SCREEN);
	HEIGHT_MM   := HEIGHT_MM_OF_SCREEN(SCREEN);
	WIDTH	    := WIDTH_OF_SCREEN(SCREEN);
	WIDTH_MM    := WIDTH_MM_OF_SCREEN(SCREEN);
	DEPTH	    := DEFAULT_DEPTH_OF_SCREEN(SCREEN);
	VISUAL	    := DEFAULT_VISUAL_OF_SCREEN(SCREEN).all;

	-- Load the font for text writing
	--
	FONT := 
	    LOAD_FONT(
		DISPLAY	=> DISPLAY,
		FONT_NAME   => 
		    C_TYPES.NULL_TERMINATED.TO_STRING(
			"-Adobe-New Century Schoolbook-Medium-R-Normal" &
			"--*-140-*-*-P-*-ISO8859-1"));

	-- Create the window
	--
	CREATE_THE_WINDOW;

	-- Define the name of the window
	--
	STORE_NAME(
	    DISPLAY	=> DISPLAY,
	    WINDOW	=> GW.WINDOW,
	    NAME	=> C_TYPES.NULL_TERMINATED.TO_STRING(NAME));

	-- Map the window
	--
	MAP_WINDOW(DISPLAY, GW.WINDOW);

	FLUSH(DISPLAY);
    end;

end;
