-- THIS SOFTWARE IS PROVIDED ''AS IS'' AND WITHOUT ANY EXPRESS OR IMPLIED
-- WARRANTIES, INCLUDING, WITHOUT LIMITATION, IMPLIED WARRANTIES OF
-- NON-INFRINGEMENT, MERCHANTABILITY OR FITNESS FOR A PARTICULAR PURPOSE.
-- Digital assumes no responsibility AT ALL for the use or reliability
-- of this software.

-- XM_SELECTION_BOX.ADA
--
-- Abstract: Demo X Window's selection box widget.
--
with C_TYPES, XT, XM, XM_CONVENIENCE, XM_WIDGET, XM_STRING;
package SELECT_PKG is

    --
    -- This program shows how to use the Selection Box widget.  It is based
    -- on the example in section 7.3 on page 110 of the first edition of
    -- "Motif Programming" by Marshall Brain, published by Digital Press.
    --
 
    CONTEXT   : XT.APP_CONTEXT_TYPE;
 
    CHAR_SET  : XM.STRING_CHAR_SET_TYPE :=
	XM.STRING_CHAR_SET_TYPE(XM_STRING.STRING_DEFAULT_CHARSET_PTR);
 
    TOP_LEVEL : XT.WIDGET_TYPE;
    BUTTON    : XT.WIDGET_TYPE;
    DIALOG    : XT.WIDGET_TYPE;
 
    type DIALOG_STATE is (OK, CANCEL);
	for DIALOG_STATE'size use 8;       -- Needed to create DIALOG_PACKAGE. 
 
    CAT       : constant C_TYPES.NULL_TERMINATED.STRING
              := C_TYPES.NULL_TERMINATED.TO_STRING("cat");
 
    DOG       : constant C_TYPES.NULL_TERMINATED.STRING
              := C_TYPES.NULL_TERMINATED.TO_STRING("dog");
 
    COW       : constant C_TYPES.NULL_TERMINATED.STRING
              := C_TYPES.NULL_TERMINATED.TO_STRING("cow");
 
    GOAT      : constant C_TYPES.NULL_TERMINATED.STRING
              := C_TYPES.NULL_TERMINATED.TO_STRING("goat");
 
    HORSE     : constant C_TYPES.NULL_TERMINATED.STRING
              := C_TYPES.NULL_TERMINATED.TO_STRING("horse");
 
    MOUSE     : constant C_TYPES.NULL_TERMINATED.STRING
              := C_TYPES.NULL_TERMINATED.TO_STRING("mouse");
 
    PIG       : constant C_TYPES.NULL_TERMINATED.STRING
              := C_TYPES.NULL_TERMINATED.TO_STRING("pig");
 
    SHEEP     : constant C_TYPES.NULL_TERMINATED.STRING
              := C_TYPES.NULL_TERMINATED.TO_STRING("sheep");
 
    RAT       : constant C_TYPES.NULL_TERMINATED.STRING
              := C_TYPES.NULL_TERMINATED.TO_STRING("rat");
 
    DONKEY    : constant C_TYPES.NULL_TERMINATED.STRING
              := C_TYPES.NULL_TERMINATED.TO_STRING("donkey");
 
    ELEPHANT  : constant C_TYPES.NULL_TERMINATED.STRING
              := C_TYPES.NULL_TERMINATED.TO_STRING("elephant");
 
    SQUIRREL  : constant C_TYPES.NULL_TERMINATED.STRING
              := C_TYPES.NULL_TERMINATED.TO_STRING("squirrel");
 
    ANIMALS   : C_TYPES.NULL_TERMINATED.VECTOR_OF_CHAR_POINTER(1 .. 12) := (
	C_TYPES.TO_CHAR_POINTER(CAT'address),
	C_TYPES.TO_CHAR_POINTER(DOG'address),
	C_TYPES.TO_CHAR_POINTER(COW'address),
	C_TYPES.TO_CHAR_POINTER(GOAT'address),
	C_TYPES.TO_CHAR_POINTER(HORSE'address),
	C_TYPES.TO_CHAR_POINTER(MOUSE'address),
	C_TYPES.TO_CHAR_POINTER(PIG'address),
	C_TYPES.TO_CHAR_POINTER(SHEEP'address),
	C_TYPES.TO_CHAR_POINTER(RAT'address),
	C_TYPES.TO_CHAR_POINTER(DONKEY'address),
	C_TYPES.TO_CHAR_POINTER(ELEPHANT'address),
	C_TYPES.TO_CHAR_POINTER(SQUIRREL'address) );

    procedure DIALOG_CALLBACK(
	WIDGET      : XT.WIDGET_TYPE;
	CLIENT_DATA : DIALOG_STATE;
	CALL_DATA   : XM_WIDGET.ACCESS_SELECTION_BOX_CALLBACK_TYPE );

        pragma EXPORT_PROCEDURE(DIALOG_CALLBACK,
	    MECHANISM => (VALUE, VALUE, VALUE) );
 
    type ACCESS_PUSH_BUTTON_CALLBACK_TYPE is
	access XM_WIDGET.PUSH_BUTTON_CALLBACK_TYPE;

    procedure BUTTON_CALLBACK(
	WIDGET      : XT.WIDGET_TYPE;
	CLIENT_DATA : XT.POINTER_TYPE;
	CALL_DATA   : XM_WIDGET.ACCESS_PUSH_BUTTON_CALLBACK_TYPE );

	pragma EXPORT_PROCEDURE(BUTTON_CALLBACK,
	    MECHANISM => (VALUE, VALUE, VALUE) );
 
end SELECT_PKG;
 
with TEXT_IO;
package body SELECT_PKG is
 
    procedure DIALOG_CALLBACK(
	WIDGET      : XT.WIDGET_TYPE;
	CLIENT_DATA : DIALOG_STATE;
	CALL_DATA   : XM_WIDGET.ACCESS_SELECTION_BOX_CALLBACK_TYPE ) is

    -- Callback function for the dialog box.
 
	TEXT   : C_TYPES.CHAR_POINTER;
	RESULT : BOOLEAN;                    -- dummy argument.
 
    begin
	case CLIENT_DATA is
	    when OK =>
 
		-- Get the string from the call_data parameter.
		--
		XM_CONVENIENCE.STRING.GET_L_TO_R(RESULT,
		    XM.STRING_TYPE(CALL_DATA.all.VALUE), CHAR_SET, TEXT );

		TEXT_IO.PUT("Selected a ");
		TEXT_IO.PUT_LINE(C_TYPES.NULL_TERMINATED.TO_STRING(TEXT));
 
		XT.FREE(TEXT);
 
	    when CANCEL =>
		TEXT_IO.PUT_LINE("CANCEL selected");
	end case;
 
        -- Make the dialog box invisible.
 
	XT.UNMANAGE_CHILD(WIDGET);
    end DIALOG_CALLBACK;
 
    procedure BUTTON_CALLBACK(
	WIDGET      : XT.WIDGET_TYPE;
	CLIENT_DATA : XT.POINTER_TYPE;
	CALL_DATA   : XM_WIDGET.ACCESS_PUSH_BUTTON_CALLBACK_TYPE ) is

    -- Callback function for the pushbutton.
 
	LIST_WIDGET : XT.WIDGET_TYPE;
	TEXT        : XM.STRING_TYPE;
 
    begin
        -- Add items to the selection box list.
	--
	LIST_WIDGET :=
	    XM_WIDGET.SELECTION_BOX_GET_CHILD(DIALOG, XM_WIDGET.LIST);

	XM_CONVENIENCE.LIST.DELETE_ALL_ITEMS(LIST_WIDGET);
 
	for LIST_COUNT in ANIMALS'range loop
 
	    TEXT := XM_CONVENIENCE.STRING.CREATE(
		C_TYPES.NULL_TERMINATED.TO_STRING(ANIMALS(LIST_COUNT)),
		CHAR_SET );
 
	    XM_CONVENIENCE.LIST.ADD_ITEM(LIST_WIDGET, TEXT, 0);
	    XM_CONVENIENCE.STRING.FREE(TEXT);
	end loop;
 
	XT.MANAGE_CHILD(DIALOG);
    end BUTTON_CALLBACK;
 
end SELECT_PKG;
 
with C_TYPES, X_RESOURCE, XT, XM, XM_CONVENIENCE, XM_WIDGET, XM_STRING;

with SELECT_PKG, SYSTEM; 
use  SELECT_PKG, SYSTEM;

procedure XM_SELECTION_BOX is
 
    package MANIPULATE_STRING is new XT.MANIPULATE_AVT(XM.STRING_TYPE);
    function TO_POINTER_TYPE is new XT.GENERIC_TO_POINTER_TYPE(DIALOG_STATE);
 
    AL : XT.ARG_LIST_TYPE(0 .. 1);
    ARGC : NATURAL := 0;
    ARGV : ADDRESS := NULL_ADDRESS;
 
begin
    -- Create the top level shell.
    --
    XT.APP_INITIALIZE(TOP_LEVEL, CONTEXT,
	C_TYPES.NULL_TERMINATED.NULL_STRING,
	X_RESOURCE.NULL_VECTOR_OF_OPTION_DESC,
	ARGC,
	ARGV,
	C_TYPES.NULL_TERMINATED.NULL_STRING,
	AL(1..0) );
 
    -- Create the pushbutton.
    --
    AL(0) := (
	XM_STRING.NLABEL_STRING_PTR,
	MANIPULATE_STRING.TO_ARG_VALUE_TYPE(XM_CONVENIENCE.STRING.CREATE_L_TO_R(
	    C_TYPES.NULL_TERMINATED.TO_STRING("Push Me"), CHAR_SET )));
 
    BUTTON := XM_WIDGET.CREATE_PUSH_BUTTON(
	TOP_LEVEL, C_TYPES.NULL_TERMINATED.TO_STRING("button"), AL(0..0) );
 
    XT.MANAGE_CHILD(BUTTON);
 
    XT.ADD_CALLBACK(
	BUTTON,
	XM_STRING.NACTIVATE_CALLBACK,
	XT.BASE_PROC_TYPE(BUTTON_CALLBACK'address),
	XT.NULL_POINTER);
 
    -- Create the selection box widget.
    --
    AL(0) := (XM_STRING.NMUST_MATCH_PTR, XT.TO_ARG_VALUE_TYPE(TRUE));
 
    AL(1) := (
	XM_STRING.NSELECTION_LABEL_STRING_PTR,
	MANIPULATE_STRING.TO_ARG_VALUE_TYPE(XM_CONVENIENCE.STRING.CREATE_L_TO_R(
	    C_TYPES.NULL_TERMINATED.TO_STRING("Pick an animal. "), CHAR_SET )));
 
    DIALOG := XM_WIDGET.CREATE_SELECTION_DIALOG(
	TOP_LEVEL, C_TYPES.NULL_TERMINATED.TO_STRING("dialog"), AL );
 
    XT.ADD_CALLBACK(
	DIALOG,
	XM_STRING.NOK_CALLBACK,
	XT.BASE_PROC_TYPE(DIALOG_CALLBACK'address),
        TO_POINTER_TYPE(OK) );
 
    XT.ADD_CALLBACK(
	DIALOG,
	XM_STRING.NCANCEL_CALLBACK,
	XT.BASE_PROC_TYPE(DIALOG_CALLBACK'address),
	TO_POINTER_TYPE(CANCEL) );
 
    XT.UNMANAGE_CHILD(
	XM_WIDGET.SELECTION_BOX_GET_CHILD(DIALOG, XM_WIDGET.HELP_BUTTON) );
 
    XT.REALIZE_WIDGET(TOP_LEVEL);
    XT.APP_MAIN_LOOP(CONTEXT);
end XM_SELECTION_BOX;
