-- THIS SOFTWARE IS PROVIDED ''AS IS'' AND WITHOUT ANY EXPRESS OR IMPLIED
-- WARRANTIES, INCLUDING, WITHOUT LIMITATION, IMPLIED WARRANTIES OF
-- NON-INFRINGEMENT, MERCHANTABILITY OR FITNESS FOR A PARTICULAR PURPOSE.
-- Digital assumes no responsibility AT ALL for the use or reliability
-- of this software.

-- XM_SCROLL_BAR.ADA
--
-- Abstract: Demo of X Windows scroll bar control.
--
with XT, XM_WIDGET;
package SCROLL_BAR_PKG is

    --
    -- This program shows how to use the Scroll Bar widget.  It is based
    -- on the example in section 11.2 on page 174 of the first edition of
    -- "Motif Programming" by Marshall Brain, published by Digital Press.
    --
 
    procedure SCROLL_CALLBACK(
	WIDGET	    : XT.WIDGET_TYPE;
	CLIENT_DATA : XT.POINTER_TYPE;
	CALL_DATA   : XM_WIDGET.ACCESS_ANY_CALLBACK_TYPE);
 
	pragma EXPORT_PROCEDURE(SCROLL_CALLBACK,
	    MECHANISM => (VALUE, VALUE, VALUE) );
 
end SCROLL_BAR_PKG;
 
with TEXT_IO, INTEGER_TEXT_IO, C_TYPES, XM_STRING;
package body SCROLL_BAR_PKG is
 
    procedure SCROLL_CALLBACK(
	WIDGET	    : XT.WIDGET_TYPE;
	CLIENT_DATA : XT.POINTER_TYPE;
	CALL_DATA   : XM_WIDGET.ACCESS_ANY_CALLBACK_TYPE) is

    -- Called everytime the scroll bar changes.
 
	VALUE : INTEGER;
	AL    : XT.ARG_LIST_TYPE(0 .. 0);
 
    begin
	-- Get the value of the scroll bar.
	--
	AL(0) := (XM_STRING.NVALUE_PTR, XT.TO_ARG_VALUE_TYPE(VALUE'address));
 
	XT.GET_VALUES(WIDGET, AL);
 
	TEXT_IO.PUT("value = ");
	INTEGER_TEXT_IO.PUT(VALUE);
	TEXT_IO.NEW_LINE;
    end SCROLL_CALLBACK;
end SCROLL_BAR_PKG;
 
with C_TYPES, X_RESOURCE, XT, XM, XM_WIDGET, XM_STRING;
 
with SCROLL_BAR_PKG, SYSTEM;
use  SCROLL_BAR_PKG, SYSTEM;

procedure XM_SCROLL_BAR is
 
    package MANIPULATE_ORIENTATION_TYPE is new
	XT.MANIPULATE_AVT(XM_WIDGET.ORIENTATION_TYPE);
 
    CONTEXT   : XT.APP_CONTEXT_TYPE;
    SCROLL    : XT.WIDGET_TYPE;
    TOP_LEVEL : XT.WIDGET_TYPE;
 
    AL	      : XT.ARG_LIST_TYPE(0 .. 2);
    ARGC      : NATURAL := 0;
    ARGV      : ADDRESS := NULL_ADDRESS;
 
begin
 
    -- Create the top level shell.
    --
    XT.APP_INITIALIZE(TOP_LEVEL, CONTEXT,
	C_TYPES.NULL_TERMINATED.NULL_STRING,
	X_RESOURCE.NULL_VECTOR_OF_OPTION_DESC,
	ARGC,
	ARGV,
	C_TYPES.NULL_TERMINATED.NULL_STRING,
	AL(1..0) );
 
    -- Create the scroll bar.
    --
    AL(0) := (XM_STRING.NMINIMUM_PTR, XT.TO_ARG_VALUE_TYPE(0));
 
    AL(1) := (XM_STRING.NMAXIMUM_PTR, XT.TO_ARG_VALUE_TYPE(1000));
 
    AL(2) := (
	XM_STRING.NORIENTATION_PTR,
	MANIPULATE_ORIENTATION_TYPE.TO_ARG_VALUE_TYPE(XM_WIDGET.HORIZONTAL) );
 
    SCROLL := XM_WIDGET.CREATE_SCROLL_BAR(
	TOP_LEVEL, C_TYPES.NULL_TERMINATED.TO_STRING("scroll"), AL );
 
    XT.MANAGE_CHILD(SCROLL);
 
    XT.ADD_CALLBACK(
	SCROLL,
	XM_STRING.NVALUE_CHANGED_CALLBACK,
	XT.BASE_PROC_TYPE(SCROLL_CALLBACK'address),
	XT.NULL_POINTER);
 
    XT.REALIZE_WIDGET(TOP_LEVEL);
    XT.APP_MAIN_LOOP(CONTEXT);
end XM_SCROLL_BAR;
