-- THIS SOFTWARE IS PROVIDED ''AS IS'' AND WITHOUT ANY EXPRESS OR IMPLIED
-- WARRANTIES, INCLUDING, WITHOUT LIMITATION, IMPLIED WARRANTIES OF
-- NON-INFRINGEMENT, MERCHANTABILITY OR FITNESS FOR A PARTICULAR PURPOSE.
-- Digital assumes no responsibility AT ALL for the use or reliability
-- of this software.

-- XM_SCALE.ADA
--
-- Abstract: Demonstrates X Windows sliding scale widget.
--
with C_TYPES, XT, XM, XM_WIDGET, XM_STRING;
package SCALE_PKG is

    --
    -- This program shows how to use the Scale widget.  It is based
    -- on the example in section 4.5 on page 61 of the first edition of
    -- "Motif Programming" by Marshall Brain, published by Digital Press.
    --

    procedure HANDLE_SCALE(
	WIDGET	    : XT.WIDGET_TYPE;
	CLIENT_DATA : INTEGER;
	CALL_DATA   : XM_WIDGET.ACCESS_ANY_CALLBACK_TYPE);
 
	pragma EXPORT_PROCEDURE(HANDLE_SCALE,
	    MECHANISM => (VALUE, VALUE, VALUE));

end SCALE_PKG;
 
with TEXT_IO, INTEGER_TEXT_IO;
package body SCALE_PKG is
 
    procedure HANDLE_SCALE(
	WIDGET	    : XT.WIDGET_TYPE;
	CLIENT_DATA : INTEGER;
	CALL_DATA   : XM_WIDGET.ACCESS_ANY_CALLBACK_TYPE) is

    -- Callback function for the scale widget.
 
	AL    : XT.ARG_LIST_TYPE(0 .. 0);
	VALUE : INTEGER;
 
    begin
	AL(0) := (XM_STRING.NVALUE_PTR, XT.TO_ARG_VALUE_TYPE(VALUE'address));
 
	XT.GET_VALUES(WIDGET, AL);

	TEXT_IO.PUT("value = ");
	INTEGER_TEXT_IO.PUT(VALUE);
	TEXT_IO.NEW_LINE;
 
    end HANDLE_SCALE;
end SCALE_PKG;
 
with C_TYPES, X_RESOURCE, XT, XM, XM_CONVENIENCE, XM_WIDGET, XM_STRING;

with SYSTEM, SCALE_PKG; use  SCALE_PKG;
procedure XM_SCALE is
 
    package MANIPULATE_STRING is new XT.MANIPULATE_AVT(XM.STRING_TYPE);
    package MANIPULATE_ORIENTATION is new
	XT.MANIPULATE_AVT(XM_WIDGET.ORIENTATION_TYPE);
 
    CONTEXT   : XT.APP_CONTEXT_TYPE;
    CHAR_SET  : XM.STRING_CHAR_SET_TYPE :=
	XM.STRING_CHAR_SET_TYPE(XM_STRING.STRING_DEFAULT_CHARSET_PTR);
 
    TOP_LEVEL : XT.WIDGET_TYPE;
    SCALE     : XT.WIDGET_TYPE;
 
    AL        : XT.ARG_LIST_TYPE(0 .. 1);
    ARGC      : NATURAL := 0;
    ARGV      : SYSTEM.ADDRESS := SYSTEM.NULL_ADDRESS;

begin

    -- Create the top level shell.
    --
    XT.APP_INITIALIZE(TOP_LEVEL, CONTEXT,
	C_TYPES.NULL_TERMINATED.NULL_STRING,
        X_RESOURCE.NULL_VECTOR_OF_OPTION_DESC,
	ARGC,
	ARGV,
	C_TYPES.NULL_TERMINATED.NULL_STRING,
	AL(1..0) );
 
    -- Create the scale widget.
    --
    AL(0) := (
	XM_STRING.NTITLE_STRING_PTR,
	MANIPULATE_STRING.TO_ARG_VALUE_TYPE(XM_CONVENIENCE.STRING.CREATE(
	    C_TYPES.NULL_TERMINATED.TO_STRING("Slide Me"), CHAR_SET )));
 
    AL(1) := (
	XM_STRING.NORIENTATION_PTR,
	MANIPULATE_ORIENTATION.TO_ARG_VALUE_TYPE(XM_WIDGET.HORIZONTAL) );
 
    SCALE := XM_WIDGET.CREATE_SCALE(
	TOP_LEVEL, C_TYPES.NULL_TERMINATED.TO_STRING("scale"), AL );
 
    XT.MANAGE_CHILD(SCALE);
 
    XT.ADD_CALLBACK(
	SCALE,
	XM_STRING.NVALUE_CHANGED_CALLBACK,
	XT.BASE_PROC_TYPE(HANDLE_SCALE'address),
	XT.NULL_POINTER );
 
    XT.REALIZE_WIDGET(TOP_LEVEL);
    XT.APP_MAIN_LOOP(CONTEXT);
end XM_SCALE;
