-- THIS SOFTWARE IS PROVIDED ''AS IS'' AND WITHOUT ANY EXPRESS OR IMPLIED
-- WARRANTIES, INCLUDING, WITHOUT LIMITATION, IMPLIED WARRANTIES OF
-- NON-INFRINGEMENT, MERCHANTABILITY OR FITNESS FOR A PARTICULAR PURPOSE.
-- Digital assumes no responsibility AT ALL for the use or reliability
-- of this software.

-- XM_ROW_COLUMN.ADA
--
-- Abstract: Demo X Windows resizeable RowColumn widget.
--
with SYSTEM, X_RESOURCE, XM_WIDGET, XM_CONVENIENCE, XT, XM, XM_STRING, C_TYPES;
 
procedure XM_ROW_COLUMN is

    --
    -- This program shows how to use the RowColumn widget.  It is based
    -- on the example in section 5.4 on page 78 of the first edition of
    -- "Motif Programming" by Marshall Brain, published by Digital Press.
    --

    package MANIPULATE_STRING  is new XT.MANIPULATE_AVT(XM.STRING_TYPE);
    package MANIPULATE_PACKING is new XT.MANIPULATE_AVT(XM_WIDGET.PACK_TYPE);
    package MANIPULATE_ORIENTATION is new
	XT.MANIPULATE_AVT(XM_WIDGET.ORIENTATION_TYPE);

    CHAR_SET : XM.STRING_CHAR_SET_TYPE :=
	XM.STRING_CHAR_SET_TYPE(XM_STRING.STRING_DEFAULT_CHARSET_PTR);
 
    TOP_LEVEL       : XT.WIDGET_TYPE;
    ROW_COL         : XT.WIDGET_TYPE;
    BUTTONS         : XT.VECTOR_OF_WIDGET_TYPE(0 .. 9);
 
    AL              : XT.ARG_LIST_TYPE(0 .. 2);
    CONTEXT         : XT.APP_CONTEXT_TYPE;

    ARGC	    : NATURAL := 0;
    ARGV	    : SYSTEM.ADDRESS := SYSTEM.NULL_ADDRESS;

begin
 
    -- Create the toplevel shell.
    --
    XT.APP_INITIALIZE(TOP_LEVEL, CONTEXT,
	C_TYPES.NULL_TERMINATED.NULL_STRING,
	X_RESOURCE.NULL_VECTOR_OF_OPTION_DESC,
	ARGC,
	ARGV,
	C_TYPES.NULL_TERMINATED.NULL_STRING,
	AL(1..0) );
 
    -- Resize toplevel.
    --
    AL(0) := (XM_STRING.NHEIGHT_PTR, XT.TO_ARG_VALUE_TYPE(120));
    AL(1) := (XM_STRING.NWIDTH_PTR,  XT.TO_ARG_VALUE_TYPE(480));
 
    XT.SET_VALUES(TOP_LEVEL, AL(0 .. 1));
 
    -- Create a RowColumn container to hold widgets.
    --
    AL(0) := (
	XM_STRING.NPACKING_PTR,
	MANIPULATE_PACKING.TO_ARG_VALUE_TYPE(Xm_WIDGET.PACK_TIGHT) );
 
    AL(1) := (
	XM_STRING.NORIENTATION_PTR,
	MANIPULATE_ORIENTATION.TO_ARG_VALUE_TYPE(Xm_widget.HORIZONTAL) );
 
    AL(2) := (XM_STRING.NADJUST_LAST_PTR, XT.TO_ARG_VALUE_TYPE(false));
 
    ROW_COL := XM_WIDGET.CREATE_ROW_COLUMN(
	TOP_LEVEL, C_TYPES.NULL_TERMINATED.TO_STRING("row_col"), AL );
 
    XT.MANAGE_CHILD(ROW_COL);
 
    -- Create 10 pushbuttons.
    --
    for X in BUTTONS'range loop
        AL(0) := (
	    XM_STRING.NLABEL_STRING_PTR,
	    MANIPULATE_STRING.TO_ARG_VALUE_TYPE(XM_CONVENIENCE.STRING.CREATE(
		C_TYPES.NULL_TERMINATED.TO_STRING("I'm a button"),
		CHAR_SET )));

	BUTTONS(X) := XM_WIDGET.CREATE_PUSH_BUTTON(
	    ROW_COL, C_TYPES.NULL_TERMINATED.TO_STRING("button"), AL(0..0) );
 
	XT.MANAGE_CHILD( BUTTONS(X) );
    end loop;
 
    XT.REALIZE_WIDGET(TOP_LEVEL);
    XT.APP_MAIN_LOOP(CONTEXT);
end XM_ROW_COLUMN;
