-- THIS SOFTWARE IS PROVIDED ''AS IS'' AND WITHOUT ANY EXPRESS OR IMPLIED
-- WARRANTIES, INCLUDING, WITHOUT LIMITATION, IMPLIED WARRANTIES OF
-- NON-INFRINGEMENT, MERCHANTABILITY OR FITNESS FOR A PARTICULAR PURPOSE.
-- Digital assumes no responsibility AT ALL for the use or reliability
-- of this software.

-- XM_MESSAGE_BOX.ADA	
--
-- Abstract: Demonstrates X Windows message box widget.
--
with XT, XM_WIDGET;
package BOX_PKG is

    --
    -- This program shows how to use the message box widget.  It is based
    -- on the example in section 7.1 on page 101 of the first edition of
    -- "Motif Programming" by Marshall Brain, published by Digital Press.
    --
 
    DIALOG : XT.WIDGET_TYPE;
 
    type DIALOG_STATE is (OK, CANCEL);
	for DIALOG_STATE'size use 8;      -- Needed so to_pointer will work.

    procedure DIALOG_CALLBACK(
	WIDGET	    : in XT.WIDGET_TYPE;
	CLIENT_DATA : in DIALOG_STATE;
	CALL_DATA   : in XM_WIDGET.ACCESS_ANY_CALLBACK_TYPE );
 
	pragma EXPORT_PROCEDURE(DIALOG_CALLBACK,
	    MECHANISM => (VALUE, VALUE, VALUE) );
 
    procedure BUTTON_CALLBACK(
	WIDGET	    : in XT.WIDGET_TYPE;
	CLIENT_DATA : in XT.POINTER_TYPE;
	CALL_DATA   : in XM_WIDGET.ACCESS_ANY_CALLBACK_TYPE );

	pragma EXPORT_PROCEDURE(BUTTON_CALLBACK,
	    MECHANISM => (VALUE, VALUE, VALUE) );

end BOX_PKG;
 
with TEXT_IO;
package body BOX_PKG is
 
    procedure DIALOG_CALLBACK(
	WIDGET	    : in XT.WIDGET_TYPE;
	CLIENT_DATA : in DIALOG_STATE;
	CALL_DATA   : in XM_WIDGET.ACCESS_ANY_CALLBACK_TYPE ) is

    -- Callback function for the dialog box.

    begin
	case CLIENT_DATA is
	    when OK     => TEXT_IO.PUT_LINE("OK selected");
 
	    when CANCEL => TEXT_IO.PUT_LINE("CANCEL selected");
	end case;
 
        -- Make the dialog box invisible.
 
	XT.UNMANAGE_CHILD(WIDGET);
    end DIALOG_CALLBACK;
 
    procedure BUTTON_CALLBACK(
	WIDGET	    : in XT.WIDGET_TYPE;
	CLIENT_DATA : in XT.POINTER_TYPE;
	CALL_DATA   : in XM_WIDGET.ACCESS_ANY_CALLBACK_TYPE ) is

    -- Callback function for the pushbutton.

    begin
	-- Make the dialog box visible.
	--
	XT.MANAGE_CHILD(DIALOG);
    end BUTTON_CALLBACK;
end BOX_PKG;
 
with C_TYPES, X_RESOURCE, 
     XT, XM, XM_CONVENIENCE, XM_WIDGET, XM_STRING;
 
with BOX_PKG, SYSTEM; 
use  BOX_PKG, SYSTEM;

procedure XM_MESSAGE_BOX is
 
    function TO_POINTER_TYPE is new XT.GENERIC_TO_POINTER_TYPE(DIALOG_STATE);
 
    package MANIPULATE_STRING is new XT.MANIPULATE_AVT(XM.STRING_TYPE);

    CONTEXT   : XT.APP_CONTEXT_TYPE;
 
    CHAR_SET  : XM.STRING_CHAR_SET_TYPE :=
	XM.STRING_CHAR_SET_TYPE(XM_STRING.STRING_DEFAULT_CHARSET_PTR);
 
    TOP_LEVEL : XT.WIDGET_TYPE;
    BUTTON    : XT.WIDGET_TYPE;
    AL        : XT.ARG_LIST_TYPE(0 .. 0);
 
    ARGC : NATURAL := 0;
    ARGV : ADDRESS := NULL_ADDRESS;

begin
    -- Create the top level shell.
    --
    XT.APP_INITIALIZE(TOP_LEVEL, CONTEXT,
	C_TYPES.NULL_TERMINATED.NULL_STRING,
	X_RESOURCE.NULL_VECTOR_OF_OPTION_DESC,
	ARGC,
	ARGV,
	C_TYPES.NULL_TERMINATED.NULL_STRING,
	AL(1 .. 0) );
 
    -- Create (but do not manage) the message dialog.
 
    AL(0) := (
	XM_STRING.NMESSAGE_STRING_PTR,
	MANIPULATE_STRING.TO_ARG_VALUE_TYPE(XM_CONVENIENCE.STRING.CREATE_L_TO_R(
	    C_TYPES.NULL_TERMINATED.TO_STRING("Is everything OK?"), CHAR_SET)));
 
    DIALOG := XM_WIDGET.CREATE_MESSAGE_DIALOG(
	TOP_LEVEL, C_TYPES.NULL_TERMINATED.TO_STRING("dialog"), AL );
 
    XT.ADD_CALLBACK(
	DIALOG,
	XM_STRING.NOK_CALLBACK,
	XT.BASE_PROC_TYPE(DIALOG_CALLBACK'address),
        TO_POINTER_TYPE(OK) );

    XT.ADD_CALLBACK(
	DIALOG,
	XM_STRING.NCANCEL_CALLBACK,
	XT.BASE_PROC_TYPE(DIALOG_CALLBACK'address),
	TO_POINTER_TYPE(CANCEL));
 
    XT.UNMANAGE_CHILD(
	XM_WIDGET.MESSAGE_BOX_GET_CHILD(DIALOG, XM_WIDGET.HELP_BUTTON) );
 
    -- Create and manage pushbutton.
    --
    AL(0) := (
	XM_STRING.NLABEL_STRING_PTR,
	MANIPULATE_STRING.TO_ARG_VALUE_TYPE(XM_CONVENIENCE.STRING.CREATE_L_TO_R(
	    C_TYPES.NULL_TERMINATED.TO_STRING("Push Me"), CHAR_SET )));
 
    BUTTON := XM_WIDGET.CREATE_PUSH_BUTTON(
	TOP_LEVEL, C_TYPES.NULL_TERMINATED.TO_STRING("button"), AL );
 
    XT.MANAGE_CHILD(BUTTON);
 
    XT.ADD_CALLBACK(
	BUTTON,
	XM_STRING.NACTIVATE_CALLBACK,
	XT.BASE_PROC_TYPE(BUTTON_CALLBACK'address),
	XT.NULL_POINTER);
 
    XT.REALIZE_WIDGET(TOP_LEVEL);
    XT.APP_MAIN_LOOP(CONTEXT);
end XM_MESSAGE_BOX;
