-- THIS SOFTWARE IS PROVIDED ''AS IS'' AND WITHOUT ANY EXPRESS OR IMPLIED
-- WARRANTIES, INCLUDING, WITHOUT LIMITATION, IMPLIED WARRANTIES OF
-- NON-INFRINGEMENT, MERCHANTABILITY OR FITNESS FOR A PARTICULAR PURPOSE.
-- Digital assumes no responsibility AT ALL for the use or reliability
-- of this software.

-- XM_LIST.ADA
--
-- Abstract: Displays an X Windows list box example.
--
with C_TYPES, XT, XM, XM_WIDGET, XM_STRING;
package LIST_PKG is

    --
    -- This program shows how to use the List widget.  It is based
    -- on the example in section 11.6 on page 181 of the first edition of
    -- "Motif Programming" by Marshall Brain, published by Digital Press.
    --

    CONTEXT  : XT.APP_CONTEXT_TYPE;
    CHAR_SET : XM.STRING_CHAR_SET_TYPE :=
	XM.STRING_CHAR_SET_TYPE(XM_STRING.STRING_DEFAULT_CHARSET_PTR);
 
    LIST_WIDGET : XT.WIDGET_TYPE;
    TOP_LEVEL   : XT.WIDGET_TYPE;
 
    CAT         : constant C_TYPES.NULL_TERMINATED.STRING
                := C_TYPES.NULL_TERMINATED.TO_STRING("cat");
 
    DOG         : constant C_TYPES.NULL_TERMINATED.STRING
                := C_TYPES.NULL_TERMINATED.TO_STRING("dog");
 
    COW         : constant C_TYPES.NULL_TERMINATED.STRING
                := C_TYPES.NULL_TERMINATED.TO_STRING("cow");
 
    GOAT        : constant C_TYPES.NULL_TERMINATED.STRING
                := C_TYPES.NULL_TERMINATED.TO_STRING("goat");
 
    HORSE       : constant C_TYPES.NULL_TERMINATED.STRING
                := C_TYPES.NULL_TERMINATED.TO_STRING("horse");
 
    MOUSE       : constant C_TYPES.NULL_TERMINATED.STRING
                := C_TYPES.NULL_TERMINATED.TO_STRING("mouse");
 
    PIG         : constant C_TYPES.NULL_TERMINATED.STRING
                := C_TYPES.NULL_TERMINATED.TO_STRING("pig");
 
    SHEEP       : constant C_TYPES.NULL_TERMINATED.STRING
                := C_TYPES.NULL_TERMINATED.TO_STRING("sheep");
 
    RAT         : constant C_TYPES.NULL_TERMINATED.STRING
                := C_TYPES.NULL_TERMINATED.TO_STRING("rat");
 
    DONKEY      : constant C_TYPES.NULL_TERMINATED.STRING
                := C_TYPES.NULL_TERMINATED.TO_STRING("donkey");
 
    ELEPHANT    : constant C_TYPES.NULL_TERMINATED.STRING
                := C_TYPES.NULL_TERMINATED.TO_STRING("elephant");
 
    SQUIRREL    : constant C_TYPES.NULL_TERMINATED.STRING
                := C_TYPES.NULL_TERMINATED.TO_STRING("squirrel");
 
    ANIMALS     : C_TYPES.NULL_TERMINATED.VECTOR_OF_CHAR_POINTER(1 .. 12) := (
	C_TYPES.TO_CHAR_POINTER(CAT'address),
	C_TYPES.TO_CHAR_POINTER(DOG'address),
	C_TYPES.TO_CHAR_POINTER(COW'address),
	C_TYPES.TO_CHAR_POINTER(GOAT'address),
	C_TYPES.TO_CHAR_POINTER(HORSE'address),
	C_TYPES.TO_CHAR_POINTER(MOUSE'address),
	C_TYPES.TO_CHAR_POINTER(PIG'address),
	C_TYPES.TO_CHAR_POINTER(SHEEP'address),
	C_TYPES.TO_CHAR_POINTER(RAT'address),
	C_TYPES.TO_CHAR_POINTER(DONKEY'address),
	C_TYPES.TO_CHAR_POINTER(ELEPHANT'address),
	C_TYPES.TO_CHAR_POINTER(SQUIRREL'address) );
 
    procedure SELECT_CALLBACK(
	WIDGET	    : XT.WIDGET_TYPE;
	CLIENT_DATA : XT.POINTER_TYPE;
	CALL_DATA   : XM_WIDGET.ACCESS_ANY_CALLBACK_TYPE );

	pragma EXPORT_PROCEDURE(SELECT_CALLBACK,
	    MECHANISM => (VALUE, VALUE, VALUE) );
 
    procedure ADD_ITEMS;
 
end LIST_PKG;
 
with TEXT_IO, INTEGER_TEXT_IO, XM_CONVENIENCE;
package body LIST_PKG is
 
    procedure SELECT_CALLBACK(
	WIDGET	    : XT.WIDGET_TYPE;
	CLIENT_DATA : XT.POINTER_TYPE;
	CALL_DATA   : XM_WIDGET.ACCESS_ANY_CALLBACK_TYPE) is

    -- Called when the item in the list is selected.
 
	POS_LIST        : XM.ACCESS_UNCHECKED_VECTOR_OF_POSITION_TYPE;
	POS_LIST_LENGTH : XM.POSITION_COUNT_TYPE;
	MEM_ALLOCATED   : BOOLEAN;
 
    begin
	XM_CONVENIENCE.LIST.GET_SELECTED_POS(
	    MEM_ALLOCATED, LIST_WIDGET, POS_LIST, POS_LIST_LENGTH );

	if INTEGER(POS_LIST_LENGTH) = 0 then
	    TEXT_IO.PUT("No animals selected.");

	else 
	    for X in 1 .. INTEGER(POS_LIST_LENGTH) loop
		INTEGER_TEXT_IO.PUT(INTEGER(POS_LIST(X)));
		TEXT_IO.PUT(" ");
	    end loop;
	end if; 

	TEXT_IO.NEW_LINE;
 
	if MEM_ALLOCATED then
	    XT.FREE(C_TYPES.TO_CHAR_POINTER(POS_LIST.all'address));
	end if;
 
    end SELECT_CALLBACK;
 
    procedure ADD_ITEMS is

    -- Add items to the list.
 
	TEXT : XM.STRING_TYPE;
 
    begin
	for LIST_COUNT in ANIMALS'range loop
	    TEXT := XM_CONVENIENCE.STRING.CREATE(
		C_TYPES.NULL_TERMINATED.TO_STRING(ANIMALS(LIST_COUNT)),
		CHAR_SET );
 
	    XM_CONVENIENCE.LIST.ADD_ITEM(LIST_WIDGET, TEXT, 0);
	    XM_CONVENIENCE.STRING.FREE(TEXT);
	end loop;
    end ADD_ITEMS;
 
end LIST_PKG;
 
 
with LIST_PKG; use  LIST_PKG;
with SYSTEM, C_TYPES, X_RESOURCE, XT, XM, XM_WIDGET, XM_STRING;

procedure XM_LIST is
 
    package MANIPULATE_SELECTION_POLICY is new
	XT.MANIPULATE_AVT(XM_WIDGET.SELECTION_POLICY_TYPE);
 
    AL : XT.ARG_LIST_TYPE(0 .. 1);

    ARGC : NATURAL := 0;
    ARGV : SYSTEM.ADDRESS := SYSTEM.NULL_ADDRESS;

begin
    -- Create the toplevel shell.
    --
    XT.APP_INITIALIZE(TOP_LEVEL, CONTEXT,
	C_TYPES.NULL_TERMINATED.NULL_STRING,
	X_RESOURCE.NULL_VECTOR_OF_OPTION_DESC,
	ARGC, 
	ARGV,
	C_TYPES.NULL_TERMINATED.NULL_STRING,
	AL(1..0) );
 
    -- Set the default size of the window.
    -- 
    AL(0) := (XM_STRING.NWIDTH_PTR,  XT.TO_ARG_VALUE_TYPE(200));
    AL(1) := (XM_STRING.NHEIGHT_PTR, XT.TO_ARG_VALUE_TYPE(200));

    XT.SET_VALUES(TOP_LEVEL, AL);
 
    -- Create a list widget.
    --
    AL(0) := (
	XM_STRING.NSELECTION_POLICY_PTR,
	MANIPULATE_SELECTION_POLICY.TO_ARG_VALUE_TYPE(
	    XM_WIDGET.MULTIPLE_SELECT ));
 
    LIST_WIDGET := XM_WIDGET.CREATE_SCROLLED_LIST(
	TOP_LEVEL, C_TYPES.NULL_TERMINATED.TO_STRING("list"), AL(0..0) );
 
    XT.MANAGE_CHILD(LIST_WIDGET);
 
    XT.ADD_CALLBACK(
	LIST_WIDGET,
	XM_STRING.NMULTIPLE_SELECTION_CALLBACK,
	XT.BASE_PROC_TYPE(SELECT_CALLBACK'address),
	XT.NULL_POINTER );
 
    ADD_ITEMS;
 
    XT.REALIZE_WIDGET(TOP_LEVEL);
    XT.APP_MAIN_LOOP(CONTEXT);
end XM_LIST;
