-- THIS SOFTWARE IS PROVIDED ''AS IS'' AND WITHOUT ANY EXPRESS OR IMPLIED
-- WARRANTIES, INCLUDING, WITHOUT LIMITATION, IMPLIED WARRANTIES OF
-- NON-INFRINGEMENT, MERCHANTABILITY OR FITNESS FOR A PARTICULAR PURPOSE.
-- Digital assumes no responsibility AT ALL for the use or reliability
-- of this software.

-- XM_COMMAND.ADA
--
-- Abstract: Command window demo.
--
with TEXT_IO, C_TYPES, XT, XM, XM_CONVENIENCE, XM_WIDGET, XM_STRING;
package COMMAND_PKG is

    --
    -- This program shows how to use the command widget.  It is based
    -- on the example in section 11.8 on page 186 of the first edition of
    -- "Motif Programming" by Marshall Brain, published by Digital Press.
    --

    CHAR_SET : XM.STRING_CHAR_SET_TYPE :=
	XM.STRING_CHAR_SET_TYPE(XM_STRING.STRING_DEFAULT_CHARSET_PTR);
 
    procedure COMMAND_ENTERED_CALLBACK(
	WIDGET	    : XT.WIDGET_TYPE;
	CLIENT_DATA : INTEGER;
	CALL_DATA   : XM_WIDGET.ACCESS_COMMAND_CALLBACK_TYPE);
 
	pragma EXPORT_PROCEDURE(COMMAND_ENTERED_CALLBACK,
	    MECHANISM => (VALUE, VALUE, VALUE) );
  
 
    procedure COMMAND_CHANGED_CALLBACK(
	WIDGET	    : XT.WIDGET_TYPE;
	CLIENT_DATA : INTEGER;
	CALL_DATA   : XM_WIDGET.ACCESS_COMMAND_CALLBACK_TYPE);
 
	pragma EXPORT_PROCEDURE(COMMAND_CHANGED_CALLBACK,
	    MECHANISM => (VALUE, VALUE, VALUE) );
 
end COMMAND_PKG;

package body COMMAND_PKG is
 
    procedure COMMAND_ENTERED_CALLBACK(
	WIDGET      : XT.WIDGET_TYPE;
	CLIENT_DATA : INTEGER;
	CALL_DATA   : XM_WIDGET.ACCESS_COMMAND_CALLBACK_TYPE ) is
 
    -- Handle callbacks generated when the command is entered.
 
	TEXT   : C_TYPES.CHAR_POINTER;
	RESULT : BOOLEAN;		-- dummy result value.
 
    begin
	XM_CONVENIENCE.STRING.GET_L_TO_R(
	    RESULT, XM.STRING_TYPE(CALL_DATA.all.VALUE), CHAR_SET, TEXT);
 
	TEXT_IO.PUT("command entered = '");
	TEXT_IO.PUT(C_TYPES.NULL_TERMINATED.TO_STRING(TEXT));
	TEXT_IO.PUT_LINE("'");
 
	XT.FREE(TEXT);
    end COMMAND_ENTERED_CALLBACK;
 
    procedure COMMAND_CHANGED_CALLBACK(
	WIDGET      : XT.WIDGET_TYPE;
	CLIENT_DATA : INTEGER;
	CALL_DATA   : XM_WIDGET.ACCESS_COMMAND_CALLBACK_TYPE) is
 
    -- Handle callbacks generated when the command is changed.
 
	TEXT   : C_TYPES.CHAR_POINTER;
	RESULT : BOOLEAN;                -- dummy result value.
 
    begin
	XM_CONVENIENCE.STRING.GET_L_TO_R(
	    RESULT, XM.STRING_TYPE(CALL_DATA.all.VALUE), CHAR_SET, TEXT);
 
	TEXT_IO.PUT("command changed = '");
	TEXT_IO.PUT(C_TYPES.NULL_TERMINATED.TO_STRING(TEXT));
	TEXT_IO.PUT_LINE("'");
 
	XT.FREE(TEXT);
    end COMMAND_CHANGED_CALLBACK;
end COMMAND_PKG;
 
with TEXT_IO, C_TYPES, X_RESOURCE, XT, XM, 
     XM_CONVENIENCE, XM_WIDGET, XM_STRING;
 
with COMMAND_PKG, SYSTEM; 
use  COMMAND_PKG, SYSTEM;

procedure XM_COMMAND is

    package MANIPULATE_STRING is new XT.MANIPULATE_AVT(XM.STRING_TYPE);
 
    CONTEXT       : XT.APP_CONTEXT_TYPE;
 
    TOP_LEVEL     : XT.WIDGET_TYPE;
    COMMAND       : XT.WIDGET_TYPE;
    BUTTON        : XT.WIDGET_TYPE;

    AL            : XT.ARG_LIST_TYPE(0 .. 0);
    
    ARGC : NATURAL := 0;
    ARGV : SYSTEM.ADDRESS := SYSTEM.NULL_ADDRESS;

begin
    -- Create the top level shell.
    --
    XT.APP_INITIALIZE(TOP_LEVEL, CONTEXT,
	C_TYPES.NULL_TERMINATED.NULL_STRING,
	X_RESOURCE.NULL_VECTOR_OF_OPTION_DESC,
	ARGC,
	ARGV,
	C_TYPES.NULL_TERMINATED.NULL_STRING,
	AL(1..0) );
 
    AL(0) := (
	XM_STRING.NPROMPT_STRING_PTR,
	MANIPULATE_STRING.TO_ARG_VALUE_TYPE(XM_CONVENIENCE.STRING.CREATE_L_TO_R(
	    C_TYPES.NULL_TERMINATED.TO_STRING("Enter a command"), CHAR_SET )));
 
    COMMAND := XM_WIDGET.CREATE_COMMAND(
	TOP_LEVEL, C_TYPES.NULL_TERMINATED.TO_STRING("command"), AL );
 
    XT.ADD_CALLBACK(
	COMMAND,
	XM_STRING.NCOMMAND_ENTERED_CALLBACK,
	XT.BASE_PROC_TYPE(COMMAND_ENTERED_CALLBACK'address),
	XT.NULL_POINTER );
 
    XT.ADD_CALLBACK(
	COMMAND,
	XM_STRING.NCOMMAND_CHANGED_CALLBACK,
	XT.BASE_PROC_TYPE(COMMAND_CHANGED_CALLBACK'address),
	XT.NULL_POINTER );
 
    XT.MANAGE_CHILD(COMMAND);
 
    XT.REALIZE_WIDGET(TOP_LEVEL);
 
    XT.APP_MAIN_LOOP(CONTEXT);
end XM_COMMAND;
