--***********************************************************************
--									*
--	COPYRIGHT 1992		DIGITAL EQUIPMENT CORPORATION		*
--									*
--   This software was written by Bevin Brett, of Digital Equipment	*
--   Corporation.							*
--									*
--   Digital assumes no responsibility AT ALL for the use or reliability*
--   of this software.							*
--									*
--   Redistribution and use in source and binary forms are permitted	*
--   provided that this entire heading from --*** to --*** are          *
--   duplicated in all such forms and that any documentation,		*
--   advertising materials, and other materials related to such		*
--   distribution and use acknowledge that the software was developed	*
--   by Digital Equipment Corporation. The name of Digital Equipment	*
--   Corporation may not be used to endorse or promote products derived	*
--   from this software without specific prior written permission.	*
--									*
--   THIS SOFTWARE IS PROVIDED ``AS IS'' AND WITHOUT ANY EXPRESS OR	*
--   IMPLIED WARRANTIES, INCLUDING, WITHOUT LIMITATION, THE IMPLIED	*
--   WARRANTIES OF MERCHANTIBILITY AND FITNESS FOR A PARTICULAR PURPOSE.*
--									*
--***********************************************************************


with CALENDAR,	CONDITION_HANDLING, STARLET, SYSTEM;
use		CONDITION_HANDLING, STARLET;

pragma ELABORATE(
    CALENDAR,	CONDITION_HANDLING, STARLET, SYSTEM);

package body SYSTEM_INTERFACE is

    RANDOM_SEED : INTEGER;


    function DIGITS_SQRT(A : SOME_FLOAT) return SOME_FLOAT is

	function F_SQRT (A : SYSTEM.F_FLOAT) return SYSTEM.F_FLOAT;
	pragma INTERFACE (VAXRTL, F_SQRT);
	pragma IMPORT_FUNCTION (F_SQRT, "MTH$SQRT", MECHANISM => REFERENCE);

	function D_SQRT (A : SYSTEM.D_FLOAT) return SYSTEM.D_FLOAT;
	pragma INTERFACE (VAXRTL, D_SQRT);
	pragma IMPORT_FUNCTION (D_SQRT, "MTH$DSQRT", MECHANISM => REFERENCE);

	function G_SQRT (A : SYSTEM.G_FLOAT) return SYSTEM.G_FLOAT;
	pragma INTERFACE (VAXRTL, G_SQRT);
	pragma IMPORT_FUNCTION (G_SQRT, "MTH$GSQRT", MECHANISM => REFERENCE);

-- Alpha doesn't have H_FLOAT
--	function H_SQRT (A : SYSTEM.H_FLOAT) return SYSTEM.H_FLOAT;
--	pragma INTERFACE (VAXRTL, H_SQRT);
--	pragma IMPORT_FUNCTION (H_SQRT, "MTH$HSQRT", MECHANISM => REFERENCE);

    begin
	if SOME_FLOAT'MACHINE_MANTISSA = SYSTEM.F_FLOAT'MACHINE_MANTISSA then
	    return SOME_FLOAT(F_SQRT (SYSTEM.F_FLOAT(A)));
	elsif SOME_FLOAT'MACHINE_MANTISSA = SYSTEM.D_FLOAT'MACHINE_MANTISSA then
	    return SOME_FLOAT(D_SQRT (SYSTEM.D_FLOAT(A)));
	elsif SOME_FLOAT'MACHINE_MANTISSA = SYSTEM.G_FLOAT'MACHINE_MANTISSA then
	    return SOME_FLOAT(G_SQRT (SYSTEM.G_FLOAT(A)));
--	elsif SOME_FLOAT'MACHINE_MANTISSA = SYSTEM.H_FLOAT'MACHINE_MANTISSA then
--	    return SOME_FLOAT(H_SQRT (SYSTEM.H_FLOAT(A)));
	else
	    raise PROGRAM_ERROR;
	end if;
    end;

    function GET_CPU_TIME return DURATION is

	CPUTIM : INTEGER;
	    pragma VOLATILE(CPUTIM);

	LENGTH : SYSTEM.UNSIGNED_WORD;
	    pragma VOLATILE(LENGTH);

	ITMLST : constant ITEM_LIST_TYPE :=
		((BUF_LEN	=> SYSTEM.UNSIGNED_WORD(CPUTIM'size/8),
		 ITEM_CODE	=> JPI_CPUTIM,
		 BUF_ADDRESS	=> CPUTIM'address,
		 RET_ADDRESS	=> LENGTH'address),
		 (BUF_LEN	=> 0,
		 ITEM_CODE	=> 0,
		 BUF_ADDRESS	=> SYSTEM.ADDRESS_ZERO,
		 RET_ADDRESS	=> SYSTEM.ADDRESS_ZERO));
	STATUS : COND_VALUE_TYPE;
    begin
	GETJPIW(STATUS, ITMLST=>ITMLST);
	return DURATION(CPUTIM*DURATION'(0.01));
    end;

    procedure MTH_RANDOM(
	RESULT	: out SYSTEM.F_FLOAT;
	SEED	: in out INTEGER);
	pragma INTERFACE(MTH, MTH_RANDOM);
	pragma IMPORT_VALUED_PROCEDURE(MTH_RANDOM, EXTERNAL => "MTH$RANDOM",
	    mechanism => (VALUE, REFERENCE));

    function RANDOM return FLOAT is
	RESULT  : SYSTEM.F_FLOAT;
    begin
	MTH_RANDOM(RESULT, RANDOM_SEED);
	return FLOAT(RESULT);
    end;


    function SIN(X : FAST_FLOAT) return FAST_FLOAT is
	function MTH_SIN(X : SYSTEM.F_FLOAT) return SYSTEM.F_FLOAT;
	pragma INTERFACE(MTH, MTH_SIN);
	pragma IMPORT_FUNCTION(MTH_SIN, EXTERNAL => "MTH$SIN",
		MECHANISM	 => (REFERENCE),
		RESULT_MECHANISM => VALUE);
    begin
	return FAST_FLOAT(MTH_SIN(SYSTEM.F_FLOAT(X)));
    end;

    function ASIN(X : FAST_FLOAT) return FAST_FLOAT is
	function MTH_ASIN(X : SYSTEM.F_FLOAT) return SYSTEM.F_FLOAT;
	pragma INTERFACE(MTH, MTH_ASIN);
	pragma IMPORT_FUNCTION(MTH_ASIN, EXTERNAL => "MTH$ASIN",
		MECHANISM	 => (REFERENCE),
		RESULT_MECHANISM => VALUE);
    begin
	return FAST_FLOAT(MTH_ASIN(SYSTEM.F_FLOAT(X)));
    end;

    function ALLOCATE_MEMORY(NUMBER_OF_BYTES : POSITIVE) return ADDRESS is

	STATUS	    : INTEGER;
	ALLOCATED   : ADDRESS;

	procedure GET_VM (
	    STATUS	    : out INTEGER;
	    NUMBER_OF_BYTES : in  POSITIVE;
	    BASE_ADDRESS    : out ADDRESS);

	pragma INTERFACE(LIB, GET_VM);
	pragma IMPORT_VALUED_PROCEDURE(GET_VM, external => "LIB$GET_VM",
	    mechanism => (VALUE, REFERENCE, REFERENCE));

    begin
	GET_VM(STATUS, NUMBER_OF_BYTES, ALLOCATED);
	if STATUS rem 8 = 1 then
	    return ALLOCATED;
	else
	    return SYSTEM_INTERFACE.ADDRESS_ZERO;
	end if;
    end;


begin
    declare
	use CALENDAR;
	YEAR	: YEAR_NUMBER;
	MONTH	: MONTH_NUMBER;
	DAY	: DAY_NUMBER;
	SECONDS	: DAY_DURATION;
    begin
	SPLIT(CLOCK, YEAR,MONTH,DAY,SECONDS);
	RANDOM_SEED :=
	    INTEGER((FLOAT(SECONDS)/24.0/3600.0)*FLOAT(INTEGER'last-10));
    end;

end;
